/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.database.stream.profiling;

import com.arm.streamline.analysis.database.api.profiling.IAnalysisCodeProfilingPerChannelWriter;
import com.arm.streamline.analysis.database.stream.ChannelExecutablePathWriter;
import com.arm.streamline.analysis.model.threads.IExecutablePath;
import com.arm.streamline.common.utility.io.CompressedOutputStream;
import com.arm.streamline.common.utility.io.Compression;
import com.arm.streamline.report.model.uids.IUniqueThreadID;
import com.arm.utils.NullChecking;
import com.arm.utils.function.Throwing;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class DatabaseCodeProfilerPerChannelEventWriter
implements IAnalysisCodeProfilingPerChannelWriter {
    public static final @NonNull String FILE_FORMAT = "%d.db.gz";
    public static final @NonNull Pattern FILE_PATTERN = Pattern.compile("(\\d+)\\.db\\.gz");
    private final @NonNull ChannelExecutablePathWriter executablePathWriter = new ChannelExecutablePathWriter();
    private boolean first = true;
    private long lastTimestamp;
    private final @NonNull OutputStream outputStream;
    private final long vmUID;

    public DatabaseCodeProfilerPerChannelEventWriter(@NonNull File profilingPath, long vmUID) throws IOException {
        File file = new File(profilingPath, String.format(FILE_FORMAT, vmUID));
        ((File)NullChecking.neverNull((Object)file.getParentFile())).mkdirs();
        this.outputStream = (OutputStream)Throwing.closeIfThrows(gos -> new BufferedOutputStream((OutputStream)gos), (Object)((CompressedOutputStream)Throwing.closeIfThrows(fos -> new CompressedOutputStream((OutputStream)fos), (Object)new FileOutputStream(file), (Closeable[])new Closeable[0])), (Closeable[])new Closeable[0]);
        this.vmUID = vmUID;
    }

    public DatabaseCodeProfilerPerChannelEventWriter(@NonNull OutputStream outputStream, long vmUID) {
        this.outputStream = outputStream;
        this.vmUID = vmUID;
    }

    @Override
    public void close() throws IOException {
        this.outputStream.close();
    }

    @Override
    public void consumeBacktrace(long timestamp, int source, @NonNull IUniqueThreadID utid, @Nullable IExecutablePath @NonNull [] offsetExecutablePaths, long @NonNull [] offsets) throws IOException {
        if (utid.getVmUID() != this.vmUID) {
            throw new IllegalArgumentException();
        }
        if (offsetExecutablePaths.length != offsets.length) {
            throw new AssertionError();
        }
        if (offsetExecutablePaths.length > 0) {
            assert (this.first || this.lastTimestamp <= timestamp);
            this.first = false;
            long delta = timestamp - this.lastTimestamp;
            this.lastTimestamp = timestamp;
            Compression.packInt((long)delta, (OutputStream)this.outputStream);
            Compression.packInt((long)utid.getUID(), (OutputStream)this.outputStream);
            Compression.packInt((long)source, (OutputStream)this.outputStream);
            Compression.packInt((long)offsetExecutablePaths.length, (OutputStream)this.outputStream);
            int i = 0;
            while (i < offsetExecutablePaths.length) {
                this.executablePathWriter.writeExecutablePath(offsetExecutablePaths[i], this.outputStream);
                Compression.packInt((long)offsets[i], (OutputStream)this.outputStream);
                ++i;
            }
        }
    }
}

