/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.database.stream.profiling;

import com.arm.streamline.analysis.database.api.IEventReader;
import com.arm.streamline.analysis.database.api.profiling.IAnalysisCodeProfilingPerChannelReader;
import com.arm.streamline.analysis.database.api.profiling.IAnalysisCodeProfilingReader;
import com.arm.streamline.analysis.database.api.profiling.IBacktraceSource;
import com.arm.streamline.analysis.database.stream.AbstractEventReader;
import com.arm.streamline.analysis.database.stream.profiling.DatabaseCodeProfilerPerChannelEventReader;
import com.arm.streamline.analysis.database.stream.profiling.DatabaseCodeProfilerPerChannelEventWriter;
import com.arm.streamline.analysis.database.stream.profiling.MetadataReaderWriter;
import com.arm.utils.NullChecking;
import com.arm.utils.function.IThrowingObjLongBiFunction;
import com.arm.utils.function.Throwing;
import gnu.trove.map.TIntObjectMap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class DatabaseCodeProfilerEventReader
extends AbstractEventReader<IAnalysisCodeProfilingPerChannelReader.IValue, IAnalysisCodeProfilingPerChannelReader.IValue, IAnalysisCodeProfilingPerChannelReader>
implements IAnalysisCodeProfilingReader {
    protected static @NonNull IAnalysisCodeProfilingPerChannelReader @NonNull [] createChannelReadersFor(@NonNull File profilingPath, @NonNull IThrowingObjLongBiFunction<@NonNull File, @NonNull IAnalysisCodeProfilingPerChannelReader, IOException> factory) throws IOException {
        @NonNull File @Nullable [] allFiles = profilingPath.listFiles();
        @NonNull ArrayList<@NonNull IAnalysisCodeProfilingPerChannelReader> channelReaders = new ArrayList<IAnalysisCodeProfilingPerChannelReader>();
        try {
            if (allFiles != null) {
                File[] fileArray = allFiles;
                int n = allFiles.length;
                int n2 = 0;
                while (n2 < n) {
                    Matcher matcher;
                    File file = fileArray[n2];
                    if (file.isFile() && (matcher = DatabaseCodeProfilerPerChannelEventWriter.FILE_PATTERN.matcher(file.getName())).matches()) {
                        @NonNull String uidStr = (String)NullChecking.neverNull((Object)matcher.group(1));
                        long vmuid = Long.parseLong(uidStr);
                        channelReaders.add((IAnalysisCodeProfilingPerChannelReader)factory.apply((Object)file, vmuid));
                    }
                    ++n2;
                }
            }
            return channelReaders.toArray(new IAnalysisCodeProfilingPerChannelReader[channelReaders.size()]);
        }
        catch (Throwable t) {
            Throwing.closeAll((Iterable[])new Iterable[]{channelReaders});
            throw t;
        }
    }

    public DatabaseCodeProfilerEventReader(@NonNull File profilingPath) throws IOException {
        this(DatabaseCodeProfilerEventReader.createChannelReadersFor(profilingPath, new ChannelFactory(profilingPath)));
    }

    DatabaseCodeProfilerEventReader(@NonNull IAnalysisCodeProfilingPerChannelReader @NonNull [] channelReaders) {
        super((IEventReader[])channelReaders);
    }

    @Override
    protected @NonNull IAnalysisCodeProfilingPerChannelReader.IValue adaptPerChannelValue(int channelIndex, @NonNull IAnalysisCodeProfilingPerChannelReader.IValue readValue) throws IOException {
        return readValue;
    }

    private static final class ChannelFactory
    implements IThrowingObjLongBiFunction<File, IAnalysisCodeProfilingPerChannelReader, IOException> {
        private final @NonNull TIntObjectMap<IBacktraceSource> backtraceSources;

        public ChannelFactory(@NonNull File profilingPath) throws IOException {
            this.backtraceSources = MetadataReaderWriter.read(profilingPath);
        }

        public @NonNull IAnalysisCodeProfilingPerChannelReader apply(@NonNull File dataFile, long vmUID) throws IOException {
            return new DatabaseCodeProfilerPerChannelEventReader(dataFile, vmUID, this.backtraceSources);
        }
    }
}

