/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.database.stream.icounter.spe;

import com.arm.streamline.analysis.database.api.icounter.IAnalysisRatioInstructionCounterWriter;
import com.arm.streamline.analysis.database.stream.icounter.DatabaseRatioInstructionCounterWriter;
import com.arm.streamline.analysis.model.threads.IExecutablePath;
import com.arm.streamline.common.model.topology.ProcessingElementReference;
import com.arm.streamline.report.model.uids.IUniqueThreadID;
import com.arm.streamline.report.shared.icounter.InstructionCounterMetadataXml;
import com.arm.utils.function.IThrowingConsumer;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class SpeHitMissRatioInstructionCounterWriter
implements IAnalysisRatioInstructionCounterWriter<Boolean> {
    public static final @NonNull Integer COLOUR_RBG_HIT = 7918216;
    public static final @NonNull Integer COLOUR_RBG_MISS = 16761512;
    public static final @NonNull Integer COLOUR_RBG_SET = 7899346;
    public static final @NonNull Integer COLOUR_RBG_CLEAR = 15909950;
    public static final int DP_ID_HIT = 1;
    public static final int DP_ID_MISS = 0;
    private final @NonNull IAnalysisRatioInstructionCounterWriter<@NonNull Boolean> counterWriter;
    private final @NonNull String description;
    private final @NonNull String hitLabel;
    private final @NonNull IThrowingConsumer<// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull InstructionCounterMetadataXml.RatioInstructionCounterMetadata, IOException> metadataConsumer;
    private final @NonNull String missLabel;
    private final @NonNull String title;
    private final @NonNull String unit;
    private final @NonNull ShowWhat showWhatByDefault;
    private final boolean useNeutralColours;

    private static int dataPointUniqueIDMapper(@NonNull Boolean hit) {
        return hit != false ? 1 : 0;
    }

    private static boolean validateDataPoint(@NonNull ProcessingElementReference peReference, @NonNull Boolean hit) {
        return true;
    }

    private static void writeMetadataXml(@NonNull File directory, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull InstructionCounterMetadataXml.RatioInstructionCounterMetadata metadata) throws IOException {
        @NonNull File xmlPath = new File(directory, "metadata.xml");
        InstructionCounterMetadataXml.save((File)xmlPath, (InstructionCounterMetadataXml)metadata);
    }

    public SpeHitMissRatioInstructionCounterWriter(@NonNull File directory, @NonNull String title, @NonNull String description, @NonNull String unit, @NonNull String hitLabel, @NonNull String missLabel, @NonNull ShowWhat showWhatByDefault, boolean useNeutralColours) {
        this(new DatabaseRatioInstructionCounterWriter<Boolean>(directory, SpeHitMissRatioInstructionCounterWriter::validateDataPoint, SpeHitMissRatioInstructionCounterWriter::dataPointUniqueIDMapper), (IThrowingConsumer<InstructionCounterMetadataXml.RatioInstructionCounterMetadata, IOException>)((IThrowingConsumer)metadata -> SpeHitMissRatioInstructionCounterWriter.writeMetadataXml(directory, metadata)), title, description, unit, hitLabel, missLabel, showWhatByDefault, useNeutralColours);
    }

    SpeHitMissRatioInstructionCounterWriter(@NonNull IAnalysisRatioInstructionCounterWriter<@NonNull Boolean> counterWriter, @NonNull IThrowingConsumer<// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull InstructionCounterMetadataXml.RatioInstructionCounterMetadata, IOException> metadataConsumer, @NonNull String title, @NonNull String description, @NonNull String unit, @NonNull String hitLabel, @NonNull String missLabel, @NonNull ShowWhat showWhatByDefault, boolean useNeutralColours) {
        this.counterWriter = counterWriter;
        this.metadataConsumer = metadataConsumer;
        this.title = title;
        this.description = description;
        this.unit = unit;
        this.hitLabel = hitLabel;
        this.missLabel = missLabel;
        this.showWhatByDefault = showWhatByDefault;
        this.useNeutralColours = useNeutralColours;
    }

    @Override
    public void close() throws IOException {
        this.counterWriter.close();
        int @Nullable [] dpToShowByDefault = switch (this.showWhatByDefault) {
            case ShowWhat.SHOW_HIT_BY_DEFAULT -> new int[]{1};
            case ShowWhat.SHOW_MISS_BY_DEFAULT -> new int[1];
            case ShowWhat.SHOW_RATIO_BY_DEFAULT -> {
                int[] v0 = new int[2];
                v0[0] = 1;
                yield v0;
            }
            default -> throw new AssertionError((Object)this.showWhatByDefault);
        };
        @NonNull Integer hitColour = this.useNeutralColours ? COLOUR_RBG_SET : COLOUR_RBG_HIT;
        @NonNull Integer missColour = this.useNeutralColours ? COLOUR_RBG_CLEAR : COLOUR_RBG_MISS;
        // Could not load outer class - annotation placement on inner may be incorrect
        @NonNull InstructionCounterMetadataXml.RatioInstructionCounterMetadata metadata = new InstructionCounterMetadataXml.RatioInstructionCounterMetadata(this.title, this.description, this.unit, dpToShowByDefault, Arrays.asList(new InstructionCounterMetadataXml.RatioInstructionCounterDataPoint(0, this.missLabel, missColour), new InstructionCounterMetadataXml.RatioInstructionCounterDataPoint(1, this.hitLabel, hitColour)));
        this.metadataConsumer.accept((Object)metadata);
    }

    @Override
    public void consumeCounterValue(long time, @NonNull ProcessingElementReference peReference, @NonNull IUniqueThreadID utid, @Nullable IExecutablePath executablePath, long offsetOrAddress, @NonNull Boolean hit) throws IOException {
        this.counterWriter.consumeCounterValue(time, peReference, utid, executablePath, offsetOrAddress, hit);
    }

    public static enum ShowWhat {
        SHOW_HIT_BY_DEFAULT,
        SHOW_MISS_BY_DEFAULT,
        SHOW_RATIO_BY_DEFAULT;

    }
}

