/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.database.stream.icounter.spe;

import com.arm.streamline.analysis.database.api.icounter.IAnalysisRatioInstructionCounterWriter;
import com.arm.streamline.analysis.database.stream.icounter.DatabaseRatioInstructionCounterWriter;
import com.arm.streamline.analysis.model.threads.IExecutablePath;
import com.arm.streamline.common.model.topology.ProcessingElementReference;
import com.arm.streamline.report.model.uids.IUniqueThreadID;
import com.arm.streamline.report.shared.icounter.InstructionCounterMetadataXml;
import com.arm.utils.NullChecking;
import com.arm.utils.function.IThrowingConsumer;
import com.arm.utils.function.Throwing;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.function.BiPredicate;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class SpeDataSourceRatioInstructionCounterWriter
implements IAnalysisRatioInstructionCounterWriter<Short> {
    private final @NonNull IAnalysisRatioInstructionCounterWriter<@NonNull Short> counterWriter;
    private final @NonNull TIntObjectMap<String> dataSourceNamesByIndex;
    private final @NonNull String description;
    private final @NonNull IThrowingConsumer<// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull InstructionCounterMetadataXml.RatioInstructionCounterMetadata, IOException> metadataConsumer;
    private final @NonNull String title;
    private final @NonNull String unit;

    private static int dataPointUniqueIDMapper(@NonNull Short index) {
        return Short.toUnsignedInt(index);
    }

    private static void writeMetadataXml(@NonNull File directory, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull InstructionCounterMetadataXml.RatioInstructionCounterMetadata metadata) throws IOException {
        @NonNull File xmlPath = new File(directory, "metadata.xml");
        InstructionCounterMetadataXml.save((File)xmlPath, (InstructionCounterMetadataXml)metadata);
    }

    public SpeDataSourceRatioInstructionCounterWriter(@NonNull File directory, @NonNull String title, @NonNull String description, @NonNull String unit, @NonNull TIntObjectMap<String> dataSourceNamesByIndex) {
        this(directory, new ValidateDataPoint(dataSourceNamesByIndex), title, description, unit);
    }

    private SpeDataSourceRatioInstructionCounterWriter(@NonNull File directory, @NonNull ValidateDataPoint validator, @NonNull String title, @NonNull String description, @NonNull String unit) {
        this(new DatabaseRatioInstructionCounterWriter<Short>(directory, validator, SpeDataSourceRatioInstructionCounterWriter::dataPointUniqueIDMapper), (IThrowingConsumer<InstructionCounterMetadataXml.RatioInstructionCounterMetadata, IOException>)((IThrowingConsumer)metadata -> SpeDataSourceRatioInstructionCounterWriter.writeMetadataXml(directory, metadata)), title, description, unit, validator.dataSourceNamesByIndex);
    }

    SpeDataSourceRatioInstructionCounterWriter(@NonNull IAnalysisRatioInstructionCounterWriter<@NonNull Short> counterWriter, @NonNull IThrowingConsumer<// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull InstructionCounterMetadataXml.RatioInstructionCounterMetadata, IOException> metadataConsumer, @NonNull String title, @NonNull String description, @NonNull String unit, @NonNull TIntObjectMap<String> dataSourceNamesByIndex) {
        this.counterWriter = counterWriter;
        this.metadataConsumer = metadataConsumer;
        this.title = title;
        this.description = description;
        this.unit = unit;
        this.dataSourceNamesByIndex = dataSourceNamesByIndex;
    }

    @Override
    public void close() throws IOException {
        this.counterWriter.close();
        ArrayList<@NonNull E> dataPoints = new ArrayList();
        Throwing.forEach(this.dataSourceNamesByIndex, (name, index) -> {
            boolean bl = dataPoints.add(new InstructionCounterMetadataXml.RatioInstructionCounterDataPoint(index, (String)NullChecking.neverNull((Object)name), null));
        });
        // Could not load outer class - annotation placement on inner may be incorrect
        @NonNull InstructionCounterMetadataXml.RatioInstructionCounterMetadata metadata = new InstructionCounterMetadataXml.RatioInstructionCounterMetadata(this.title, this.description, this.unit, null, dataPoints);
        this.metadataConsumer.accept((Object)metadata);
    }

    @Override
    public void consumeCounterValue(long time, @NonNull ProcessingElementReference peReference, @NonNull IUniqueThreadID utid, @Nullable IExecutablePath executablePath, long offsetOrAddress, @NonNull Short index) throws IOException {
        this.counterWriter.consumeCounterValue(time, peReference, utid, executablePath, offsetOrAddress, index);
    }

    private static final class ValidateDataPoint
    implements BiPredicate<ProcessingElementReference, Short> {
        protected final @NonNull TIntObjectMap<String> dataSourceNamesByIndex;

        public ValidateDataPoint(@NonNull TIntObjectMap<String> dataSourceNamesByIndex) {
            this.dataSourceNamesByIndex = new TIntObjectHashMap(dataSourceNamesByIndex);
        }

        @Override
        public boolean test(@NonNull ProcessingElementReference t, @NonNull Short u) {
            int key = Short.toUnsignedInt(u);
            if (!this.dataSourceNamesByIndex.containsKey(key)) {
                this.dataSourceNamesByIndex.put(key, (Object)String.format("<unknown data source %d>", key));
            }
            return true;
        }
    }
}

