/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.database.stream.icounter;

import com.arm.streamline.analysis.database.api.IEventReader;
import com.arm.streamline.analysis.database.api.icounter.IAnalysisRatioInstructionCounterChannelReader;
import com.arm.streamline.analysis.database.api.icounter.IAnalysisRatioInstructionCounterReader;
import com.arm.streamline.analysis.database.stream.AbstractEventReader;
import com.arm.streamline.analysis.database.stream.icounter.DatabaseRatioInstructionCounterChannelReader;
import com.arm.streamline.analysis.database.stream.icounter.DatabaseRatioInstructionCounterChannelWriter;
import com.arm.streamline.common.model.topology.DeviceType;
import com.arm.streamline.common.model.topology.ProcessingElementReference;
import com.arm.streamline.common.model.topology.ProcessingElementReferenceSet;
import com.arm.utils.NullChecking;
import com.arm.utils.collections.ObjIntPair;
import com.arm.utils.function.IThrowingIntFunction;
import com.arm.utils.function.Throwing;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class DatabaseRatioInstructionCounterReader<T>
extends AbstractEventReader<IAnalysisRatioInstructionCounterChannelReader.Value<T>, IAnalysisRatioInstructionCounterChannelReader.Value<T>, IAnalysisRatioInstructionCounterChannelReader<T>>
implements IAnalysisRatioInstructionCounterReader<T> {
    protected static <T> @NonNull IAnalysisRatioInstructionCounterChannelReader<T> @NonNull [] createChannelReadersFor(@NonNull File directory, @NonNull ProcessingElementReferenceSet peReferenceSet, @NonNull IThrowingIntFunction<T, IOException> dataPointMapper, @NonNull IChannelFactory<T> factory) throws IOException {
        @NonNull ArrayList<@NonNull IAnalysisRatioInstructionCounterChannelReader<Object>> channelReaders = new ArrayList<IAnalysisRatioInstructionCounterChannelReader<Object>>();
        try {
            for (ObjIntPair<ProcessingElementReference> channel : DatabaseRatioInstructionCounterReader.enumerateChannels(directory, peReferenceSet)) {
                ProcessingElementReference peReference = (ProcessingElementReference)channel.first;
                int dataPoint = channel.second;
                File file = DatabaseRatioInstructionCounterChannelWriter.getFile(directory, peReference, dataPoint);
                channelReaders.add(factory.create(file, peReference, dataPointMapper.apply(dataPoint)));
            }
            return channelReaders.toArray(new IAnalysisRatioInstructionCounterChannelReader[channelReaders.size()]);
        }
        catch (Throwable t) {
            Throwing.closeAll((Iterable[])new Iterable[]{channelReaders});
            throw t;
        }
    }

    public static @NonNull List<@NonNull ObjIntPair<@NonNull ProcessingElementReference>> enumerateChannels(@NonNull File directory, @NonNull ProcessingElementReferenceSet peReferenceSet) {
        @NonNull File @Nullable [] allFiles = directory.listFiles();
        @NonNull ArrayList<@NonNull ObjIntPair<@NonNull ProcessingElementReference>> channels = new ArrayList<ObjIntPair<ProcessingElementReference>>();
        if (allFiles != null) {
            File[] fileArray = allFiles;
            int n = allFiles.length;
            int n2 = 0;
            while (n2 < n) {
                Matcher matcher;
                File file = fileArray[n2];
                if (file.isFile() && (matcher = DatabaseRatioInstructionCounterChannelWriter.FILE_PATTERN.matcher(file.getName())).matches()) {
                    @NonNull String vmStr = (String)NullChecking.neverNull((Object)matcher.group(1));
                    @NonNull String cpuStr = (String)NullChecking.neverNull((Object)matcher.group(2));
                    @NonNull String dpStr = (String)NullChecking.neverNull((Object)matcher.group(3));
                    long vmUID = Long.parseLong(vmStr);
                    int deviceNumber = Integer.parseInt(cpuStr);
                    int dpID = Integer.parseInt(dpStr);
                    @NonNull ProcessingElementReference peReference = peReferenceSet.get(DeviceType.CPU, vmUID, deviceNumber);
                    channels.add((ObjIntPair<ProcessingElementReference>)new ObjIntPair((Object)peReference, dpID));
                }
                ++n2;
            }
        }
        return channels;
    }

    public DatabaseRatioInstructionCounterReader(@NonNull File directory, @NonNull ProcessingElementReferenceSet peReferenceSet, @NonNull IThrowingIntFunction<T, IOException> dataPointMapper) throws IOException {
        this(DatabaseRatioInstructionCounterReader.createChannelReadersFor(directory, peReferenceSet, dataPointMapper, DatabaseRatioInstructionCounterChannelReader::new));
    }

    DatabaseRatioInstructionCounterReader(@NonNull IAnalysisRatioInstructionCounterChannelReader<T> @NonNull [] channelReaders) {
        super((IEventReader[])channelReaders);
    }

    @Override
    protected @NonNull IAnalysisRatioInstructionCounterChannelReader.Value<T> adaptPerChannelValue(int channelIndex, @NonNull IAnalysisRatioInstructionCounterChannelReader.Value<T> readValue) throws IOException {
        return readValue;
    }

    @FunctionalInterface
    public static interface IChannelFactory<T> {
        public @NonNull IAnalysisRatioInstructionCounterChannelReader<T> create(@NonNull File var1, @NonNull ProcessingElementReference var2, T var3) throws IOException;
    }
}

