/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.database.stream.icounter;

import com.arm.streamline.analysis.database.api.icounter.IAnalysisRatioInstructionCounterChannelReader;
import com.arm.streamline.analysis.database.stream.ChannelExecutablePathReader;
import com.arm.streamline.analysis.model.threads.IExecutablePath;
import com.arm.streamline.common.model.topology.ProcessingElementReference;
import com.arm.streamline.common.utility.io.Compression;
import com.arm.utils.function.Throwing;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class DatabaseRatioInstructionCounterChannelReader<T>
implements IAnalysisRatioInstructionCounterChannelReader<T> {
    private final T dataPoint;
    private final @NonNull ChannelExecutablePathReader executablePathReader = new ChannelExecutablePathReader();
    private final @NonNull InputStream inputStream;
    private long lastTimestamp;
    private final @NonNull ProcessingElementReference processingElement;

    public DatabaseRatioInstructionCounterChannelReader(@NonNull File dataFile, @NonNull ProcessingElementReference processingElement, T dataPoint) throws FileNotFoundException, IOException {
        this.processingElement = processingElement;
        this.dataPoint = dataPoint;
        this.inputStream = (InputStream)Throwing.closeIfThrows(BufferedInputStream::new, (Object)((GZIPInputStream)Throwing.closeIfThrows(GZIPInputStream::new, (Object)((FileInputStream)Throwing.closeIfThrows(FileInputStream::new, (Object)dataFile, (Closeable[])new Closeable[0])), (Closeable[])new Closeable[0])), (Closeable[])new Closeable[0]);
    }

    DatabaseRatioInstructionCounterChannelReader(@NonNull InputStream inputStream, @NonNull ProcessingElementReference processingElement, T dataPoint) {
        this.inputStream = inputStream;
        this.processingElement = processingElement;
        this.dataPoint = dataPoint;
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
    }

    @Override
    public @Nullable IAnalysisRatioInstructionCounterChannelReader.Value<T> read() throws IOException {
        try {
            long timestamp;
            long delta = Compression.unpackInt((InputStream)this.inputStream);
            int utid = (int)Compression.unpackInt((InputStream)this.inputStream);
            this.lastTimestamp = timestamp = this.lastTimestamp + delta;
            @Nullable IExecutablePath executablePath = this.executablePathReader.readExecutablePath(this.inputStream);
            long offsetOrAddress = Compression.unpackInt((InputStream)this.inputStream);
            return new IAnalysisRatioInstructionCounterChannelReader.Value<T>(this.processingElement, this.dataPoint, timestamp, utid, executablePath, offsetOrAddress);
        }
        catch (EOFException e) {
            return null;
        }
    }
}

