/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.database.stream.icounter;

import com.arm.streamline.analysis.database.api.icounter.IAnalysisCounterInstructionCounterChannelWriter;
import com.arm.streamline.analysis.database.stream.ChannelExecutablePathWriter;
import com.arm.streamline.analysis.model.threads.IExecutablePath;
import com.arm.streamline.common.model.topology.ProcessingElementReference;
import com.arm.streamline.common.utility.io.CompressedOutputStream;
import com.arm.streamline.common.utility.io.Compression;
import com.arm.streamline.report.model.uids.IUniqueThreadID;
import com.arm.utils.NullChecking;
import com.arm.utils.function.Throwing;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class DatabaseCounterInstructionCounterChannelWriter
implements IAnalysisCounterInstructionCounterChannelWriter {
    public static final @NonNull Pattern FILE_PATTERN = Pattern.compile("(\\d+)-(\\d+)\\.db\\.gz");
    public static final @NonNull String FILENAME_FORMAT = "%d-%d.db.gz";
    private final @NonNull ChannelExecutablePathWriter executablePathWriter = new ChannelExecutablePathWriter();
    private boolean first = true;
    private long lastTimestamp;
    private final @NonNull OutputStream outputStream;
    private final long vmUID;

    public static @NonNull File getFile(@NonNull File directory, ProcessingElementReference peReference) {
        return new File(directory, String.format(FILENAME_FORMAT, peReference.vmUID, peReference.deviceNumber));
    }

    public DatabaseCounterInstructionCounterChannelWriter(@NonNull File directory, @NonNull ProcessingElementReference peReference) throws FileNotFoundException, RuntimeException, IOException {
        if (!peReference.deviceType.isCPU()) {
            throw new IllegalArgumentException();
        }
        @NonNull File outputFile = DatabaseCounterInstructionCounterChannelWriter.getFile(directory, peReference);
        @NonNull File parent = (File)NullChecking.neverNull((Object)outputFile.getParentFile());
        parent.mkdirs();
        this.vmUID = peReference.vmUID;
        this.outputStream = (OutputStream)Throwing.closeIfThrows(gos -> new BufferedOutputStream((OutputStream)gos), (Object)((CompressedOutputStream)Throwing.closeIfThrows(fos -> new CompressedOutputStream((OutputStream)fos), (Object)new FileOutputStream(outputFile), (Closeable[])new Closeable[0])), (Closeable[])new Closeable[0]);
    }

    DatabaseCounterInstructionCounterChannelWriter(@NonNull OutputStream outputStream, long vmUID) {
        this.outputStream = outputStream;
        this.vmUID = vmUID;
    }

    @Override
    public void close() throws IOException {
        this.outputStream.close();
    }

    @Override
    public void consumeCounterValue(long time, @NonNull IUniqueThreadID utid, @Nullable IExecutablePath executablePath, long offsetOrAddress, long n) throws IOException {
        this.writeHeader(utid, time);
        this.executablePathWriter.writeExecutablePath(executablePath, this.outputStream);
        Compression.packInt((long)offsetOrAddress, (OutputStream)this.outputStream);
        Compression.packInt((long)n, (OutputStream)this.outputStream);
    }

    private void writeHeader(@NonNull IUniqueThreadID utid, long timestamp) throws IOException {
        if (utid.getVmUID() != this.vmUID) {
            throw new IllegalArgumentException();
        }
        assert (this.first || this.lastTimestamp <= timestamp);
        this.first = false;
        long delta = timestamp - this.lastTimestamp;
        this.lastTimestamp = timestamp;
        Compression.packInt((long)delta, (OutputStream)this.outputStream);
        Compression.packInt((long)utid.getUID(), (OutputStream)this.outputStream);
    }
}

