/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.database.stream.factory;

import com.arm.streamline.analysis.database.ApplicationsWriter;
import com.arm.streamline.analysis.database.CoresReaderWriter;
import com.arm.streamline.analysis.database.DBPropertiesReaderWriter;
import com.arm.streamline.analysis.database.EventsChart;
import com.arm.streamline.analysis.database.KernelSymbolsReaderWriter;
import com.arm.streamline.analysis.database.ProcessingElementReferenceSetReaderWriter;
import com.arm.streamline.analysis.database.VirtualMachinePropertiesReaderWriter;
import com.arm.streamline.analysis.database.stream.cam.DatabaseCAMJobEventWriter;
import com.arm.streamline.analysis.database.stream.counters.DatabaseCounterWriter;
import com.arm.streamline.analysis.database.stream.factory.CAMTrack;
import com.arm.streamline.analysis.database.stream.factory.CAMView;
import com.arm.streamline.analysis.database.stream.factory.DatabaseLayout;
import com.arm.streamline.analysis.database.stream.factory.IAnalysisDatabaseWriterStateTracker;
import com.arm.streamline.analysis.model.AllCounters;
import com.arm.streamline.analysis.model.DeviceTypeCalculator;
import com.arm.streamline.analysis.model.ICounterSeriesKey;
import com.arm.streamline.analysis.model.IVirtualMachineProperties;
import com.arm.streamline.analysis.model.KernelSymbol;
import com.arm.streamline.analysis.model.StaticCounterSeriesKey;
import com.arm.streamline.analysis.model.threads.IUniqueProcess;
import com.arm.streamline.analysis.model.threads.IUniqueThread;
import com.arm.streamline.common.model.counters.CounterClass;
import com.arm.streamline.common.model.counters.CounterRecord;
import com.arm.streamline.common.model.counters.SpeCaptureRecord;
import com.arm.streamline.common.model.topology.DeviceType;
import com.arm.streamline.common.model.topology.ProcessingElementReference;
import com.arm.streamline.common.model.topology.ProcessingElementReferenceSet;
import com.arm.streamline.common.model.warnings.IWarnings;
import com.arm.streamline.common.model.warnings.WarningItem;
import com.arm.streamline.common.xml.spe.SpeTargetDescription;
import com.arm.streamline.report.model.pe.ProcessingElementDescriptor;
import com.arm.streamline.report.model.topology.IClustersInfo;
import com.arm.utils.NullChecking;
import com.arm.utils.function.IThrowingBiConsumer;
import com.arm.utils.io.FileUtils;
import gnu.trove.iterator.TIntObjectIterator;
import gnu.trove.iterator.TLongObjectIterator;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.TLongObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.map.hash.TLongObjectHashMap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class AnalysisDatabaseWriterStateTracker
implements IAnalysisDatabaseWriterStateTracker {
    private final @NonNull TLongObjectMap<CAMVmState> camVmStates = new TLongObjectHashMap(10, 0.5f, -1L);
    private final @NonNull Map<@NonNull ICounterSeriesKey, @NonNull File> counterDataPaths = new HashMap<ICounterSeriesKey, File>();
    private final @NonNull Map<@NonNull ICounterSeriesKey, @NonNull CounterRecord> counterRecords = new HashMap<ICounterSeriesKey, CounterRecord>();
    private final @NonNull File dbDirectory;
    private final @NonNull DeviceTypeCalculator deviceTypeCalculator;
    private final @NonNull Map<@NonNull ICounterSeriesKey, @NonNull File> eventDataPaths = new HashMap<ICounterSeriesKey, File>();
    private final @NonNull Map<@NonNull IAnalysisDatabaseWriterStateTracker.IInstructionCounterKey, @NonNull File> instructionCounterDataPaths = new HashMap<IAnalysisDatabaseWriterStateTracker.IInstructionCounterKey, File>();
    private final @NonNull Collection<@NonNull SpeCaptureRecord> spes;
    private final @NonNull IWarnings warnings;

    protected static @NonNull Map<@NonNull IUniqueProcess, @NonNull Set<@NonNull IUniqueThread>> filterIgnored(@NonNull Map<@NonNull IUniqueProcess, @NonNull Set<@NonNull IUniqueThread>> threadsByProcessThread) {
        @NonNull HashMap<@NonNull IUniqueProcess, @NonNull Set<@NonNull IUniqueThread>> result = new HashMap<IUniqueProcess, Set<IUniqueThread>>();
        for (Map.Entry<IUniqueProcess, Set<IUniqueThread>> entry : threadsByProcessThread.entrySet()) {
            @NonNull IUniqueProcess process = entry.getKey();
            @NonNull HashSet<@NonNull IUniqueThread> threads = new HashSet<IUniqueThread>((Collection)entry.getValue());
            threads.removeIf(IUniqueThread::isIgnored);
            if (threads.isEmpty()) continue;
            result.put(process, threads);
        }
        return result;
    }

    private static void removeUnwantedCounterStreams(@NonNull Map<@NonNull ICounterSeriesKey, @NonNull File> counterDataPaths, @NonNull Set<@NonNull ICounterSeriesKey> validSeriesKeys) {
        counterDataPaths.entrySet().forEach(e -> {
            if (!validSeriesKeys.contains(e.getKey())) {
                @NonNull @NonNull List result = FileUtils.delete((File)((File)e.getValue()));
                assert (result.isEmpty()) : "Not deleted: " + String.valueOf(result);
            }
        });
    }

    public AnalysisDatabaseWriterStateTracker(@NonNull File dbDirectory, @NonNull DeviceTypeCalculator deviceTypeCalculator, @NonNull Collection<@NonNull StaticCounterSeriesKey> staticCounters, @NonNull Collection<@NonNull SpeCaptureRecord> spes, @NonNull IWarnings warnings) throws IOException {
        this.dbDirectory = dbDirectory;
        this.deviceTypeCalculator = deviceTypeCalculator;
        this.warnings = warnings;
        this.spes = spes;
        if (!dbDirectory.isDirectory() && !dbDirectory.mkdirs()) {
            throw new IOException();
        }
        for (StaticCounterSeriesKey k : staticCounters) {
            @NonNull CounterRecord counterRecord = k.getCounterRecord();
            this.addDynamicOrKernelAnnotationCounterRecord(k, counterRecord);
            if (!CounterClass.ACTIVITY.equals((Object)counterRecord.getCounterClass())) {
                this.trackCounterPath(k);
                continue;
            }
            this.trackActivityStreamPath(k);
        }
    }

    @Override
    public void addDynamicOrKernelAnnotationCounterRecord(@NonNull ICounterSeriesKey key, @NonNull CounterRecord counterRecord) {
        counterRecord.setDynamic(!key.isStaticCounter());
        if (!counterRecord.ignore() && !this.counterRecords.containsKey(key)) {
            DeviceType deviceType = this.deviceTypeCalculator.addCounter(counterRecord);
            if (deviceType.isCPU() && !counterRecord.isPerCPU()) {
                deviceType = DeviceType.SYSTEM_WIDE;
            }
            counterRecord.setDeviceType(deviceType);
            assert (NullChecking.equalsNullable((Object)key.getDeviceTypeOrDefault(), (Object)counterRecord.getDeviceType()));
            this.counterRecords.put(key, counterRecord);
        }
    }

    @Override
    public @NonNull File getAnnotationsPath() throws IOException {
        return DatabaseLayout.getAnnotationsPath(this.dbDirectory, true);
    }

    @Override
    public @NonNull File getCodeProfilingEventsPath() throws IOException {
        return DatabaseLayout.getCodeProfilingEventsPath(this.dbDirectory, true);
    }

    @Override
    public @NonNull File getIdleStateEventsPath() throws IOException {
        return DatabaseLayout.getIdleStateEventsPath(this.dbDirectory, true);
    }

    @Override
    public @NonNull File getSchedulerEventsPath() throws IOException {
        return DatabaseLayout.getSchedulerEventsPath(this.dbDirectory, true);
    }

    @Override
    public @Nullable SpeTargetDescription getSpeTargetDescription(int key) {
        Optional<@NonNull SpeCaptureRecord> findFirst = this.spes.stream().filter(c -> c.getKey() == key).findFirst();
        if (findFirst.isPresent()) {
            return findFirst.get().getTargetDescription();
        }
        return null;
    }

    @Override
    public @NonNull File trackActivityStreamPath(@NonNull ICounterSeriesKey key) throws IOException {
        @Nullable File currentPath = this.eventDataPaths.get(key);
        if (currentPath != null) {
            return currentPath;
        }
        if (this.counterDataPaths.containsKey(key)) {
            throw new IllegalArgumentException(key.toString());
        }
        @NonNull File result = DatabaseLayout.getActivityEventsPath(this.dbDirectory, this.eventDataPaths.size(), true);
        this.eventDataPaths.put(key, result);
        return result;
    }

    @Override
    public @NonNull File trackCAMJobsPath(long vmUID, int viewUID) throws IOException {
        @NonNull File result = DatabaseLayout.getCAMJobsPath(this.dbDirectory, vmUID, viewUID, true);
        @NonNull CAMView viewState = this.getOrCreateCAMView(vmUID, viewUID);
        viewState.jobsPath = result;
        return result;
    }

    @Override
    public void trackCAMTrack(long vmUID, int viewUID, int parentTrack, int trackUID, @NonNull String name) {
        @NonNull CAMView camView = this.getOrCreateCAMView(vmUID, viewUID);
        camView.tracks.put(trackUID, (Object)new CAMTrack(parentTrack, trackUID, name));
    }

    @Override
    public void trackCAMView(long vmUID, int viewUID, @NonNull String name) {
        @NonNull CAMView camView = this.getOrCreateCAMView(vmUID, viewUID);
        camView.name = name;
    }

    @Override
    public @NonNull File trackCounterPath(@NonNull ICounterSeriesKey key) throws IOException {
        @Nullable File currentPath = this.counterDataPaths.get(key);
        if (currentPath != null) {
            return currentPath;
        }
        if (this.eventDataPaths.containsKey(key)) {
            throw new IllegalArgumentException(key.toString());
        }
        @NonNull File result = DatabaseLayout.getCounterPath(this.dbDirectory, this.counterDataPaths.size(), true);
        this.counterDataPaths.put(key, result);
        return result;
    }

    @Override
    public @NonNull File trackInstructionCounterPath(@NonNull IAnalysisDatabaseWriterStateTracker.IInstructionCounterKey key) throws IOException {
        @Nullable File currentPath = this.instructionCounterDataPaths.get(key);
        if (currentPath != null) {
            return currentPath;
        }
        @NonNull File result = DatabaseLayout.getInstructionCounterPath(this.dbDirectory, this.instructionCounterDataPaths.size(), true);
        this.instructionCounterDataPaths.put(key, result);
        return result;
    }

    @Override
    public void warning(@NonNull WarningItem warning) {
        this.warnings.add(warning);
    }

    @Override
    public void writeState(@NonNull ProcessingElementReferenceSet peReferenceSet, @NonNull TLongObjectMap<? extends IVirtualMachineProperties> vmStatesMap, @NonNull Map<@NonNull IUniqueProcess, @NonNull Set<@NonNull IUniqueThread>> threadsByProcessThread, long duration, @NonNull String captureName, boolean hasApplicationTracingMode, @NonNull List<@NonNull ProcessingElementReference> sortedCpuList, @NonNull Map<@NonNull ProcessingElementReference, @NonNull ProcessingElementDescriptor> processingElementProperties, @NonNull IClustersInfo clusterInfo, @NonNull TLongObjectMap<List<@NonNull KernelSymbol>> kernelSymbolsByVm) throws IOException {
        CoresReaderWriter.write(new File(this.dbDirectory, "cores.xml"), sortedCpuList, processingElementProperties, clusterInfo);
        clusterInfo.writeXML(this.dbDirectory);
        this.writeCounterAndEventXmlFilesAndRemoveUnknown(peReferenceSet);
        VirtualMachinePropertiesReaderWriter.write(new File(this.dbDirectory, "virtual-machines.xml"), vmStatesMap);
        ProcessingElementReferenceSetReaderWriter.write(new File(this.dbDirectory, "pe-references.xml"), peReferenceSet);
        AllCounters.write(new File(this.dbDirectory, "all_counters.xml"), this.counterRecords.values());
        ApplicationsWriter.write(new File(this.dbDirectory, "applications.xml"), AnalysisDatabaseWriterStateTracker.filterIgnored(threadsByProcessThread));
        KernelSymbolsReaderWriter.write(new File(this.dbDirectory, "kernel-symbols.xml"), kernelSymbolsByVm);
        this.writeCAMViewXmlFiles();
        this.warnings.save(this.dbDirectory);
        DBPropertiesReaderWriter.write(new File(this.dbDirectory, "state.xml"), System.currentTimeMillis() / 1000L, duration, captureName, hasApplicationTracingMode);
    }

    private @NonNull CAMView getOrCreateCAMView(long vmUID, int viewUID) {
        @NonNull CAMVmState vmState = this.getOrCreateCAMVmState(vmUID);
        CAMView result = (CAMView)vmState.views.get(viewUID);
        if (result == null) {
            result = new CAMView(vmUID, viewUID, null, null);
            vmState.views.put(viewUID, (Object)result);
        }
        return result;
    }

    private @NonNull CAMVmState getOrCreateCAMVmState(long vmUID) {
        CAMVmState result = (CAMVmState)this.camVmStates.get(vmUID);
        if (result == null) {
            result = new CAMVmState();
            this.camVmStates.put(vmUID, (Object)result);
        }
        return result;
    }

    private void writeCAMViewXmlFiles() throws IOException {
        TLongObjectIterator vmIt = this.camVmStates.iterator();
        while (vmIt.hasNext()) {
            vmIt.advance();
            long vmUID = vmIt.key();
            CAMVmState camVmState = (CAMVmState)vmIt.value();
            TIntObjectIterator viewIt = camVmState.views.iterator();
            while (viewIt.hasNext()) {
                viewIt.advance();
                int viewUID = viewIt.key();
                CAMView camView = (CAMView)viewIt.value();
                @Nullable File jobsPath = camView.jobsPath;
                if (jobsPath == null) continue;
                @Nullable String name = camView.name;
                @NonNull TIntObjectMap<CAMTrack> tracks = camView.tracks;
                DatabaseCAMJobEventWriter.writeState(jobsPath, vmUID, viewUID, name, tracks);
            }
        }
    }

    private void writeCounterAndEventXmlFilesAndRemoveUnknown(@NonNull ProcessingElementReferenceSet peReferenceSet) throws IOException {
        @NonNull HashSet<@NonNull ICounterSeriesKey> validSeriesKeys = new HashSet<ICounterSeriesKey>();
        this.writeCounterXmlFiles(peReferenceSet, validSeriesKeys);
        this.writeEventXmlFiles(peReferenceSet, validSeriesKeys);
        this.writeSchedulerXmlFile(peReferenceSet);
        AnalysisDatabaseWriterStateTracker.removeUnwantedCounterStreams(this.counterDataPaths, validSeriesKeys);
        AnalysisDatabaseWriterStateTracker.removeUnwantedCounterStreams(this.eventDataPaths, validSeriesKeys);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private void writeCounterXmlFiles(@NonNull ProcessingElementReferenceSet peReferenceSet, @NonNull Set<@NonNull ICounterSeriesKey> validSeriesKeys) throws IOException {
        @NonNull @NonNull @NonNull IThrowingBiConsumer writer = (dbPath, counterRecord) -> {
            if (CounterClass.ACTIVITY.equals((Object)counterRecord.getCounterClass())) {
                throw new AssertionError((Object)("An activity counter: " + counterRecord.getUniqueAtraceKey()));
            }
            @NonNull ArrayList<@NonNull E> peReferences = new ArrayList(peReferenceSet.getList(counterRecord.getDeviceTypeOrDefault()));
            DatabaseCounterWriter.writeChart(dbPath, counterRecord, peReferences.toArray(new ProcessingElementReference[peReferences.size()]));
        };
        this.writeXmlFiles(validSeriesKeys, this.counterDataPaths, (IThrowingBiConsumer<File, CounterRecord, IOException>)writer);
    }

    private void writeEventXmlFiles(@NonNull ProcessingElementReferenceSet peReferenceSet, @NonNull Set<@NonNull ICounterSeriesKey> validSeriesKeys) throws IOException {
        this.writeXmlFiles(validSeriesKeys, this.eventDataPaths, (IThrowingBiConsumer<File, CounterRecord, IOException>)((IThrowingBiConsumer)(dbPath, counterRecord) -> {
            if (!CounterClass.ACTIVITY.equals((Object)counterRecord.getCounterClass())) {
                throw new AssertionError((Object)("Not an activity counter: " + counterRecord.getUniqueAtraceKey()));
            }
            @NonNull ArrayList<@NonNull ProcessingElementReference> peReferences = new ArrayList<ProcessingElementReference>(peReferenceSet.getList(counterRecord.getDeviceTypeOrDefault()));
            EventsChart.write(dbPath, counterRecord, peReferences);
        }));
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private void writeSchedulerXmlFile(@NonNull ProcessingElementReferenceSet peReferenceSet) throws IOException {
        @NonNull File path = DatabaseLayout.getSchedulerEventsPath(this.dbDirectory, false);
        if (path.isDirectory()) {
            @NonNull @NonNull List cpuProcessingElements = peReferenceSet.getList(DeviceType.CPU);
            @NonNull EventsChart chart = new EventsChart(cpuProcessingElements.size(), true, true, "CPU Activity", DeviceType.CPU, cpuProcessingElements.toArray(new ProcessingElementReference[cpuProcessingElements.size()]), new String[]{"User", "System"}, new String[]{"User activity", "System activity"}, new int[]{-2143625405, -2132850878}, true);
            EventsChart.write(chart, path);
        }
    }

    private void writeXmlFiles(@NonNull Set<@NonNull ICounterSeriesKey> validSeriesKeys, @NonNull Map<@NonNull ICounterSeriesKey, @NonNull File> dbPaths, @NonNull IThrowingBiConsumer<@NonNull File, @NonNull CounterRecord, IOException> writer) throws IOException {
        for (Map.Entry<ICounterSeriesKey, File> dbPath : dbPaths.entrySet()) {
            @Nullable CounterRecord counterRecord = this.counterRecords.get(dbPath.getKey());
            if (counterRecord == null) continue;
            writer.accept((Object)dbPath.getValue(), (Object)counterRecord);
            validSeriesKeys.add(dbPath.getKey());
        }
    }

    public static final class CAMVmState {
        public final @NonNull TIntObjectMap<CAMView> views = new TIntObjectHashMap(10, 0.5f, -1);
    }
}

