/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.database.stream.factory;

import com.arm.streamline.analysis.database.ApplicationsReader;
import com.arm.streamline.analysis.database.CoresReaderWriter;
import com.arm.streamline.analysis.database.DBPropertiesReaderWriter;
import com.arm.streamline.analysis.database.EventsChart;
import com.arm.streamline.analysis.database.KernelSymbolsReaderWriter;
import com.arm.streamline.analysis.database.ProcessingElementReferenceSetReaderWriter;
import com.arm.streamline.analysis.database.VirtualMachinePropertiesReaderWriter;
import com.arm.streamline.analysis.database.api.IAnalysisReaderFactoryV2;
import com.arm.streamline.analysis.database.api.activity.IAnalysisActivityReader;
import com.arm.streamline.analysis.database.api.annotations.IAnalysisAnnotationsReader;
import com.arm.streamline.analysis.database.api.cam.IAnalysisCAMReader;
import com.arm.streamline.analysis.database.api.counters.IAnalysisHardwareCounterReader;
import com.arm.streamline.analysis.database.api.counters.IAnalysisHardwareCounterWriter;
import com.arm.streamline.analysis.database.api.counters.IAnalysisSpeMultiCounterReader;
import com.arm.streamline.analysis.database.api.icounter.IAnalysisCounterInstructionCounterChannelReader;
import com.arm.streamline.analysis.database.api.icounter.IAnalysisRatioInstructionCounterChannelReader;
import com.arm.streamline.analysis.database.api.profiling.IAnalysisCodeProfilingReader;
import com.arm.streamline.analysis.database.stream.activity.DatabaseActivityEventReader;
import com.arm.streamline.analysis.database.stream.annotations.DatabaseAnnotationEventReader;
import com.arm.streamline.analysis.database.stream.cam.DatabaseCAMJobEventReader;
import com.arm.streamline.analysis.database.stream.counters.DatabaseCounterReader;
import com.arm.streamline.analysis.database.stream.counters.DatabaseCounterWriter;
import com.arm.streamline.analysis.database.stream.factory.CAMView;
import com.arm.streamline.analysis.database.stream.factory.DatabaseLayout;
import com.arm.streamline.analysis.database.stream.icounter.DatabaseCounterInstructionCounterChannelReader;
import com.arm.streamline.analysis.database.stream.icounter.DatabaseCounterInstructionCounterChannelWriter;
import com.arm.streamline.analysis.database.stream.icounter.DatabaseCounterInstructionCounterReader;
import com.arm.streamline.analysis.database.stream.icounter.DatabaseHardwareCounterReaderForInstructionCounterFactory;
import com.arm.streamline.analysis.database.stream.icounter.DatabaseInstructionCounterReaderFactory;
import com.arm.streamline.analysis.database.stream.icounter.DatabaseRatioInstructionCounterChannelReader;
import com.arm.streamline.analysis.database.stream.icounter.DatabaseRatioInstructionCounterChannelWriter;
import com.arm.streamline.analysis.database.stream.icounter.DatabaseRatioInstructionCounterReader;
import com.arm.streamline.analysis.database.stream.profiling.DatabaseCodeProfilerEventReader;
import com.arm.streamline.analysis.model.AllCounters;
import com.arm.streamline.analysis.model.CounterMap;
import com.arm.streamline.analysis.model.DBProperties;
import com.arm.streamline.analysis.model.DeviceTypeCalculator;
import com.arm.streamline.analysis.model.KernelSymbol;
import com.arm.streamline.analysis.model.StaticCounterSeriesKey;
import com.arm.streamline.analysis.model.VirtualMachineProperties;
import com.arm.streamline.common.model.counters.CounterRecord;
import com.arm.streamline.common.model.counters.CounterRecordFile;
import com.arm.streamline.common.model.topology.ProcessingElementReference;
import com.arm.streamline.common.model.topology.ProcessingElementReferenceSet;
import com.arm.streamline.common.utility.io.CommonFileUtils;
import com.arm.streamline.report.model.topology.GatorClusters;
import com.arm.streamline.report.model.topology.IClustersInfo;
import com.arm.streamline.report.model.topology.ICores;
import com.arm.streamline.report.model.topology.XmlClustersInfo;
import com.arm.streamline.report.model.uids.IUniqueIds;
import com.arm.streamline.report.model.uids.IUniqueThreadID;
import com.arm.streamline.report.shared.icounter.InstructionCounterMetadataXml;
import com.arm.utils.NullChecking;
import com.arm.utils.StreamUtils;
import com.arm.utils.collections.ObjIntPair;
import com.arm.utils.function.IThrowingFunction;
import com.arm.utils.function.IThrowingSupplier;
import com.arm.utils.function.Throwing;
import gnu.trove.map.TLongObjectMap;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class AnalysisDatabaseReaderFactoryV2
implements IAnalysisReaderFactoryV2 {
    private final @NonNull CounterMap allCounters;
    private final @NonNull IUniqueIds applications;
    private final @NonNull IClustersInfo clustersInfo;
    private final @NonNull ICores cores;
    private final @NonNull File dbDirectory;
    private final @NonNull DBProperties dbProperties;
    private final @NonNull DatabaseHardwareCounterReaderForInstructionCounterFactory.IInstructionCounterChannelReaderSupplier instructionCounterChannelReaderSupplier;
    private final @NonNull TLongObjectMap<List<@NonNull KernelSymbol>> kernelSymbols;
    private final @NonNull ProcessingElementReferenceSet processingElementsReferenceSet;
    private final @NonNull TLongObjectMap<VirtualMachineProperties> vmStateMap;

    AnalysisDatabaseReaderFactoryV2(@NonNull File dbDirectory, @NonNull DeviceTypeCalculator deviceTypeCalculator) throws IOException {
        this.dbDirectory = dbDirectory;
        this.processingElementsReferenceSet = ProcessingElementReferenceSetReaderWriter.read(new File(dbDirectory, "pe-references.xml"));
        this.cores = CoresReaderWriter.read(new File(dbDirectory, "cores.xml"), this.processingElementsReferenceSet);
        this.clustersInfo = new XmlClustersInfo(new GatorClusters(dbDirectory), this.cores);
        this.vmStateMap = VirtualMachinePropertiesReaderWriter.read(new File(dbDirectory, "virtual-machines.xml"));
        this.dbProperties = DBPropertiesReaderWriter.create(new File(dbDirectory, "state.xml"));
        this.allCounters = AllCounters.read(new File(dbDirectory, "all_counters.xml"), deviceTypeCalculator);
        this.applications = ApplicationsReader.read(new File(dbDirectory, "applications.xml"));
        this.kernelSymbols = KernelSymbolsReaderWriter.read(new File(dbDirectory, "kernel-symbols.xml"));
        this.instructionCounterChannelReaderSupplier = new DatabaseHardwareCounterReaderForInstructionCounterFactory.IInstructionCounterChannelReaderSupplier(){

            @Override
            public @NonNull IAnalysisCounterInstructionCounterChannelReader createCounterChannelReader(@NonNull File path, @NonNull ProcessingElementReference pe) throws IOException {
                return new DatabaseCounterInstructionCounterChannelReader(DatabaseCounterInstructionCounterChannelWriter.getFile(path, pe), pe);
            }

            @Override
            public @NonNull IAnalysisRatioInstructionCounterChannelReader<?> createRatioChannelReader(@NonNull File path, @NonNull ProcessingElementReference pe, int dataPointId) throws IOException {
                return new DatabaseRatioInstructionCounterChannelReader<Object>(DatabaseRatioInstructionCounterChannelWriter.getFile(path, pe, dataPointId), pe, null);
            }

            @Override
            public @NonNull List<@NonNull ProcessingElementReference> enumerateCounterChannels(@NonNull File path) {
                return DatabaseCounterInstructionCounterReader.enumerateChannels(path, AnalysisDatabaseReaderFactoryV2.this.processingElementsReferenceSet);
            }

            @Override
            public @NonNull List<@NonNull ObjIntPair<@NonNull ProcessingElementReference>> enumerateRatioChannels(@NonNull File path) {
                return DatabaseRatioInstructionCounterReader.enumerateChannels(path, AnalysisDatabaseReaderFactoryV2.this.processingElementsReferenceSet);
            }
        };
    }

    @Override
    public @NonNull IAnalysisAnnotationsReader createAnnotationsReader() throws IOException {
        File directory = DatabaseLayout.getAnnotationsPath(this.dbDirectory, false);
        return new DatabaseAnnotationEventReader(directory);
    }

    @Override
    public @NonNull Stream<@NonNull IThrowingSupplier<@NonNull IAnalysisCodeProfilingReader, IOException>> createCodeProfilingReader() throws IOException {
        File defaultDirectory = DatabaseLayout.getCodeProfilingEventsPath(this.dbDirectory, false);
        Stream<@NonNull File> iCounterDirs = DatabaseLayout.enumerateInstructionCounterDirectories(this.dbDirectory);
        return StreamUtils.addFirst(() -> new DatabaseCodeProfilerEventReader(defaultDirectory), iCounterDirs.map(path -> () -> DatabaseInstructionCounterReaderFactory.createCodeProfilingReader(path, this.processingElementsReferenceSet)));
    }

    @Override
    public @NonNull IAnalysisHardwareCounterWriter createEnergyProcessorCounterWriter(final @NonNull CounterRecord counterRecord) throws IOException {
        int i = 0;
        while (i < Integer.MAX_VALUE) {
            @NonNull File path = DatabaseLayout.getCounterPath(this.dbDirectory, i, false);
            if (!path.exists()) {
                final @NonNull File pathCreated = DatabaseLayout.getCounterPath(this.dbDirectory, i, true);
                final @NonNull DatabaseCounterWriter writer = new DatabaseCounterWriter(pathCreated, counterRecord.getDeviceTypeOrDefault());
                return new IAnalysisHardwareCounterWriter(){

                    @Override
                    public void close() throws IOException {
                        writer.close();
                        DatabaseCounterWriter.writeChart(pathCreated, counterRecord, (ProcessingElementReference[])writer.getChannels());
                    }

                    @Override
                    public void consumerCounterValue(@NonNull ProcessingElementReference channel, long time, @Nullable IUniqueThreadID utid, long value) throws IOException {
                        writer.consumerCounterValue(channel, time, utid, value);
                    }
                };
            }
            ++i;
        }
        throw new AssertionError();
    }

    @Override
    public @NonNull Set<? extends @NonNull IAnalysisReaderFactoryV2.IAnalysisReaderActivityStream> enumerateActivityStreams() throws IOException {
        @NonNull HashSet<@NonNull E> result = new HashSet();
        DatabaseLayout.enumerateActivityDirectories(this.dbDirectory, (path, scheduler) -> {
            File chartXml = CommonFileUtils.getFile((File)new File(path, "chart.xml"));
            if (chartXml.isFile()) {
                @NonNull EventsChart eventsChart = EventsChart.read(path, this.processingElementsReferenceSet);
                result.add(new ActivityStream(path, eventsChart, scheduler));
            }
        });
        return result;
    }

    @Override
    public @NonNull Set<? extends @NonNull IAnalysisReaderFactoryV2.IAnalysisCAMDataStream> enumerateCAMDataStreams() throws IOException {
        @NonNull HashSet<@NonNull E> result = new HashSet();
        DatabaseLayout.enumerateCAMDirectories(this.dbDirectory, (directory, vmUID, viewUID) -> {
            CAMView camView;
            File dataFile = new File(directory, "db.gz");
            if (dataFile.isFile() && (camView = DatabaseCAMJobEventReader.readState(directory)) != null) {
                assert (camView.vmUID == vmUID);
                assert (camView.viewUID == viewUID);
                result.add(new CAMDataStream(dataFile, camView));
            }
        });
        return result;
    }

    @Override
    public @NonNull Set<? extends @NonNull IAnalysisReaderFactoryV2.IAnalysisReaderHardwareCounterStream> enumerateCounterStreams() throws IOException {
        @NonNull HashSet<@NonNull E> result = new HashSet();
        DatabaseLayout.enumerateCounterDirectories(this.dbDirectory, path -> {
            File counterXml = CommonFileUtils.getFile((File)new File((File)path, "counter.xml"));
            if (counterXml.isFile()) {
                @NonNull CounterRecord counterRecord = CounterRecordFile.counterRecordReader((File)path);
                @NonNull StaticCounterSeriesKey seriesKey = new StaticCounterSeriesKey(counterRecord);
                if (counterRecord.getChannelDescriptions() == null) {
                    List peList = this.processingElementsReferenceSet.getList(counterRecord.getDeviceTypeOrDefault());
                    @NonNull ProcessingElementReference @NonNull [] array = (ProcessingElementReference[])peList.toArray(ProcessingElementReference[]::new);
                    counterRecord.setChannelDescriptions(array);
                }
                result.add(new CounterStream((File)path, seriesKey.getCounterRecord()));
            }
        });
        return result;
    }

    @Override
    public @NonNull Stream<@NonNull IAnalysisReaderFactoryV2.IAnalysisReaderHardwareCounterStream> enumerateThreadCounterChannelStreams() throws IOException {
        return DatabaseLayout.enumerateInstructionCounterDirectories(this.dbDirectory).flatMap(Throwing.makeUnchecked(path -> DatabaseHardwareCounterReaderForInstructionCounterFactory.createHardwareCounterReaderCreatorForInstructionCounter(path, this.instructionCounterChannelReaderSupplier, (IThrowingFunction<File, InstructionCounterMetadataXml, IOException>)((IThrowingFunction)InstructionCounterMetadataXml::load))));
    }

    @Override
    public @NonNull CounterMap getAllCounters() {
        return this.allCounters;
    }

    @Override
    public @NonNull IUniqueIds getApplications() {
        return this.applications;
    }

    @Override
    public @NonNull IClustersInfo getClustersInfo() {
        return this.clustersInfo;
    }

    @Override
    public @NonNull ICores getCores() {
        return this.cores;
    }

    @Override
    public @NonNull DBProperties getDbProperties() {
        return this.dbProperties;
    }

    @Override
    public @NonNull TLongObjectMap<List<@NonNull KernelSymbol>> getKernelSymbols() {
        return this.kernelSymbols;
    }

    @Override
    public @NonNull ProcessingElementReferenceSet getProcessingElementsReferenceSet() {
        return this.processingElementsReferenceSet;
    }

    @Override
    public @NonNull IAnalysisReaderFactoryV2.IAnalysisReaderActivityStream getSchedulerTraceReaderStream() throws IOException {
        @NonNull File directory = DatabaseLayout.getSchedulerEventsPath(this.dbDirectory, false);
        @NonNull EventsChart eventsChart = EventsChart.read(directory, this.processingElementsReferenceSet);
        return new ActivityStream(directory, eventsChart, true);
    }

    @Override
    public @NonNull TLongObjectMap<VirtualMachineProperties> getVmStateMap() {
        return this.vmStateMap;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void writeApplicationsToReport(@NonNull File outputFile) throws IOException, InterruptedException {
        this.copyFiles(outputFile, "applications.xml");
    }

    @Override
    public void writeCoresToReport(@NonNull File outputFile) throws IOException, InterruptedException {
        this.copyFiles(outputFile, "cores.xml");
    }

    @Override
    public void writePeReferencesToReport(@NonNull File outputFile) throws IOException, InterruptedException {
        this.copyFiles(outputFile, "pe-references.xml");
    }

    @Override
    public void writeVmsToReport(@NonNull File outputFile) throws IOException, InterruptedException {
        this.copyFiles(outputFile, "virtual-machines.xml");
    }

    private void copyFiles(@NonNull File reportDir, @NonNull String filename) throws IOException, InterruptedException {
        File srcFile = new File(this.dbDirectory, (String)filename);
        if (!srcFile.isFile() && !srcFile.isDirectory()) {
            filename = (String)filename + ".gz";
            srcFile = new File(this.dbDirectory, (String)filename);
        }
        File dstFile = new File(reportDir, (String)filename);
        CommonFileUtils.copyFile((File)srcFile, (File)dstFile);
    }

    @Override
    public @Nullable IAnalysisSpeMultiCounterReader getSpeCounterReader() {
        return null;
    }

    private static final class ActivityStream
    implements IAnalysisReaderFactoryV2.IAnalysisReaderActivityStream {
        private final @NonNull File directory;
        private final @NonNull EventsChart eventsChart;
        private final boolean scheduler;

        public ActivityStream(@NonNull File directory, @NonNull EventsChart eventsChart, boolean scheduler) {
            this.directory = directory;
            this.eventsChart = eventsChart;
            this.scheduler = scheduler;
        }

        @Override
        public @NonNull IAnalysisActivityReader<ProcessingElementReference> createReader() throws IOException {
            return DatabaseActivityEventReader.create(this.directory, this.eventsChart.getChannelDescriptors());
        }

        @Override
        public @NonNull EventsChart getEventsChart() {
            return this.eventsChart;
        }

        @Override
        public @NonNull String getStreamName() {
            return this.directory.getName();
        }

        @Override
        public boolean isSchedulerTrace() {
            return this.scheduler;
        }
    }

    public static final class CAMDataStream
    implements IAnalysisReaderFactoryV2.IAnalysisCAMDataStream {
        private final @NonNull CAMView camView;
        private final @NonNull File file;

        public CAMDataStream(@NonNull File file, @NonNull CAMView camView) {
            this.file = file;
            this.camView = camView;
        }

        @Override
        public @NonNull IAnalysisCAMReader createReader() throws IOException {
            return new DatabaseCAMJobEventReader(this.file, this.camView.vmUID, this.camView.viewUID);
        }

        @Override
        public @NonNull CAMView getCAMView() {
            return this.camView;
        }
    }

    public static final class CounterStream
    implements IAnalysisReaderFactoryV2.IAnalysisReaderHardwareCounterStream {
        private final @NonNull ProcessingElementReference @NonNull [] channels;
        private final @NonNull File counterDirectory;
        private final @NonNull CounterRecord counterRecord;

        public CounterStream(@NonNull File counterDirectory, @NonNull CounterRecord counterRecord) {
            this.counterDirectory = counterDirectory;
            this.counterRecord = counterRecord;
            this.channels = (ProcessingElementReference[])NullChecking.neverNull((Object[])counterRecord.getChannelDescriptions());
        }

        @Override
        public int getChannelCount() {
            return this.channels.length;
        }

        @Override
        public @NonNull CounterRecord getCounterRecord() {
            return this.counterRecord;
        }

        @Override
        public @NonNull String getStreamName() {
            return this.counterDirectory.getName();
        }

        @Override
        public @NonNull IAnalysisHardwareCounterReader createReader() throws IOException {
            return new DatabaseCounterReader(this.counterDirectory, this.counterRecord.getCounterClass().isDelta(), this.channels);
        }
    }
}

