/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.database.stream.counters;

import com.arm.streamline.analysis.database.api.counters.IAnalysisHardwareCounterWriter;
import com.arm.streamline.analysis.database.api.idle.IAnalysisIdleStateWriter;
import com.arm.streamline.analysis.database.api.idle.IdleState;
import com.arm.streamline.analysis.database.api.scheduler.IAnalysisSchedulerTraceWriter;
import com.arm.streamline.analysis.database.stream.AbstractDynamicAllocatedChannelWriter;
import com.arm.streamline.analysis.database.stream.UtidToLong;
import com.arm.streamline.analysis.database.stream.chunkwriter.IAnalysisCounterValueConsumer;
import com.arm.streamline.analysis.database.stream.chunkwriter.IAnalysisDeltaThreadStreamWriter;
import com.arm.streamline.analysis.database.stream.counters.DatabaseCounterChannelWriter;
import com.arm.streamline.analysis.database.stream.counters.DatabaseSchedDerviedDeltaThreadCounterChannelWriter;
import com.arm.streamline.analysis.database.stream.counters.DatabaseSchedDerviedIncidentThreadCounterChannelWriter;
import com.arm.streamline.analysis.database.stream.counters.DatabaseSuppliedThreadCounterChannelWriter;
import com.arm.streamline.analysis.database.stream.counters.IDatabaseThreadCounterChannelWriter;
import com.arm.streamline.analysis.database.stream.counters.IDatabaseThreadCounterWriter;
import com.arm.streamline.analysis.processing.idle.AnalysisIdleStateStreamModifierWriter;
import com.arm.streamline.analysis.processing.idle.IAnalysisIdleStateStreamModifierWriter;
import com.arm.streamline.analysis.processing.idle.NoOpAnalysisIdleStateStreamModifierWriter;
import com.arm.streamline.common.model.topology.DeviceType;
import com.arm.streamline.common.model.topology.ProcessingElementReference;
import com.arm.streamline.report.model.uids.IUniqueThreadID;
import com.arm.utils.function.IThrowingFunction;
import com.arm.utils.function.Throwing;
import gnu.trove.map.TLongObjectMap;
import gnu.trove.map.TObjectLongMap;
import gnu.trove.map.hash.TLongObjectHashMap;
import gnu.trove.map.hash.TObjectLongHashMap;
import gnu.trove.set.TLongSet;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class DatabaseThreadCounterWriter
implements IAnalysisSchedulerTraceWriter,
IAnalysisHardwareCounterWriter,
IAnalysisIdleStateWriter {
    private final @NonNull TObjectLongMap<ProcessingElementReference> activeThreadByPE = new TObjectLongHashMap(10, 0.5f, -1L);
    private final @NonNull TLongObjectMap<ProcessingElementReference> lastPEByThread = new TLongObjectHashMap(10, 0.5f, Long.MAX_VALUE);
    private final @NonNull IDatabaseThreadCounterVmState vmState;
    private final @NonNull IDatabaseThreadCounterWriter writer;

    public DatabaseThreadCounterWriter(@NonNull Mode mode, @NonNull TLongSet vmUIDsWhereSuppliedTidShouldBeUsedInsteadOfScheduler, boolean isDeltaCounter, @NonNull DeviceType deviceType, @NonNull File dbPath) {
        this.vmState = IDatabaseThreadCounterVmState.create(mode, vmUIDsWhereSuppliedTidShouldBeUsedInsteadOfScheduler);
        this.writer = new WriterImplementation(isDeltaCounter, this.vmState, deviceType, dbPath);
    }

    DatabaseThreadCounterWriter(@NonNull IDatabaseThreadCounterVmState vmState, @NonNull IDatabaseThreadCounterWriter writer) {
        this.vmState = vmState;
        this.writer = writer;
    }

    @Override
    public final void close() throws IOException {
        this.writer.close();
    }

    @Override
    public void consumeIdleEvent(@NonNull ProcessingElementReference peReference, long time, @NonNull IdleState state) throws IOException {
        this.writer.consumeIdleEvent(peReference, time, state);
    }

    @Override
    public final void consumerCounterValue(@NonNull ProcessingElementReference peReference, long time, @Nullable IUniqueThreadID utid, long value) throws IOException {
        if (this.vmState.shouldUseSuppliedTid(peReference.vmUID)) {
            this.consumerCounterValueSupplied(peReference, time, utid, value);
        } else {
            this.consumerCounterValueFromSched(peReference, time, value);
        }
    }

    @Override
    public final void consumeSchedFree(@NonNull IUniqueThreadID utid, long time) throws IOException {
        long key = UtidToLong.mapUtid(utid);
        this.writer.consumeSchedFree(time, key);
    }

    @Override
    public final void consumeSchedSwitch(@NonNull ProcessingElementReference peReference, @Nullable IUniqueThreadID utid, long time, int state) throws IOException {
        long key = UtidToLong.mapUtid(utid);
        if (!this.canThreadBeOnMultipleCores(utid)) {
            long activeKeyOnLastPE;
            ProcessingElementReference lastPE = (ProcessingElementReference)this.lastPEByThread.get(key);
            if (lastPE != null && !peReference.equals((Object)lastPE) && (activeKeyOnLastPE = this.activeThreadByPE.get((Object)lastPE)) == key) {
                this.writer.consumeSchedSwitch(lastPE, time, -1L);
                this.activeThreadByPE.put((Object)lastPE, -1L);
            }
            long activeKeyOnPE = this.activeThreadByPE.get((Object)peReference);
            this.lastPEByThread.remove(activeKeyOnPE);
        }
        this.activeThreadByPE.put((Object)peReference, key);
        this.lastPEByThread.put(key, (Object)peReference);
        this.writer.consumeSchedSwitch(peReference, time, key);
    }

    private boolean canThreadBeOnMultipleCores(@Nullable IUniqueThreadID utid) {
        return utid == null || utid.isIdle() || !this.vmState.shouldUseSuppliedTid(utid.getVmUID());
    }

    private void consumerCounterValueFromSched(@NonNull ProcessingElementReference peReference, long time, long value) throws IOException {
        long activeKeyOnPE = this.activeThreadByPE.get((Object)peReference);
        this.writer.consumerCounterValue(peReference, time, activeKeyOnPE, value);
    }

    private void consumerCounterValueSupplied(@NonNull ProcessingElementReference peReference, long time, @Nullable IUniqueThreadID utid, long value) throws IOException {
        long activeKeyOnPE;
        long key = UtidToLong.mapUtid(utid);
        if (key != (activeKeyOnPE = this.activeThreadByPE.get((Object)peReference))) {
            this.consumeSchedSwitch(peReference, utid, time, 0);
        }
        this.writer.consumerCounterValue(peReference, time, key, value);
    }

    @FunctionalInterface
    public static interface IDatabaseThreadCounterVmState {
        public static final /* synthetic */ int[] $SWITCH_TABLE$com$arm$streamline$analysis$database$stream$counters$DatabaseThreadCounterWriter$Mode;

        public static @NonNull IDatabaseThreadCounterVmState create(@NonNull Mode mode, @NonNull TLongSet vmUIDsWhereSuppliedTidShouldBeUsedInsteadOfScheduler) {
            return vmUID -> {
                switch (mode) {
                    case USE_SCHED_OR_SUP_TID: {
                        return vmUIDsWhereSuppliedTidShouldBeUsedInsteadOfScheduler.contains(vmUID);
                    }
                    case USE_SUPPLIED_TID: {
                        return true;
                    }
                }
                throw new AssertionError((Object)mode);
            };
        }

        public boolean shouldUseSuppliedTid(long var1);
    }

    public static enum Mode {
        USE_SCHED_OR_SUP_TID,
        USE_SUPPLIED_TID;

    }

    private static final class WriterImplementation
    extends AbstractDynamicAllocatedChannelWriter<IDatabaseThreadCounterChannelWriter, ProcessingElementReference>
    implements IDatabaseThreadCounterWriter {
        private final @NonNull File dbPath;
        private final @NonNull DeviceType deviceType;
        private final boolean isDeltaCounter;
        private final @NonNull IDatabaseThreadCounterVmState vmState;

        public WriterImplementation(boolean isDeltaCounter, @NonNull IDatabaseThreadCounterVmState vmState, @NonNull DeviceType deviceType, @NonNull File dbPath) {
            super(ProcessingElementReference.class);
            this.isDeltaCounter = isDeltaCounter;
            this.vmState = vmState;
            this.deviceType = deviceType;
            this.dbPath = dbPath;
        }

        @Override
        public void consumeIdleEvent(@NonNull ProcessingElementReference peReference, long time, @NonNull IdleState state) throws IOException {
            IDatabaseThreadCounterChannelWriter channelWriter = (IDatabaseThreadCounterChannelWriter)this.getOrCreateChannel(peReference);
            channelWriter.consumeIdleEvent(time, state);
        }

        @Override
        public void consumerCounterValue(@NonNull ProcessingElementReference peReference, long time, long key, long value) throws IOException {
            IDatabaseThreadCounterChannelWriter channelWriter = (IDatabaseThreadCounterChannelWriter)this.getOrCreateChannel(peReference);
            channelWriter.consumeCounterValue(time, key, value);
        }

        @Override
        public void consumeSchedFree(long timestamp, long key) throws IOException {
            for (IDatabaseThreadCounterChannelWriter channelWriter : this.allChannels()) {
                channelWriter.consumeSchedFree(timestamp, key);
            }
        }

        @Override
        public void consumeSchedSwitch(@NonNull ProcessingElementReference peReference, long time, long key) throws IOException {
            IDatabaseThreadCounterChannelWriter channelWriter = (IDatabaseThreadCounterChannelWriter)this.getOrCreateChannel(peReference);
            channelWriter.consumeSchedSwitch(time, key);
        }

        @Override
        protected @Nullable Comparator<@NonNull ProcessingElementReference> comparator() {
            return Comparator.naturalOrder();
        }

        @Override
        protected @NonNull IDatabaseThreadCounterChannelWriter createNewChannel(@NonNull ProcessingElementReference channel) throws IOException {
            return (IDatabaseThreadCounterChannelWriter)Throwing.closeIfThrows(sw -> this.createDatabaseThreadCounterChannelWriter((IAnalysisDeltaThreadStreamWriter)sw, processingElementReference.vmUID), (Object)DatabaseCounterChannelWriter.makeStreamWriter(this.dbPath, channel.vmUID, channel.deviceNumber), (Closeable[])new Closeable[0]);
        }

        @Override
        protected boolean validChannel(@NonNull ProcessingElementReference channel) {
            return channel.deviceType.equals((Object)this.deviceType);
        }

        private @NonNull IDatabaseThreadCounterChannelWriter createDatabaseThreadCounterChannelWriter(@NonNull IAnalysisDeltaThreadStreamWriter streamWriter, long vmUID) throws IOException {
            if (this.vmState.shouldUseSuppliedTid(vmUID)) {
                return this.createDatabaseThreadCounterChannelWriter_SuppliedTid(streamWriter);
            }
            return this.createDatabaseThreadCounterChannelWriter_SchedTid(streamWriter);
        }

        private @NonNull IDatabaseThreadCounterChannelWriter createDatabaseThreadCounterChannelWriter_SchedTid(@NonNull IAnalysisDeltaThreadStreamWriter streamWriter) throws IOException {
            if (this.isDeltaCounter) {
                return new DatabaseSchedDerviedDeltaThreadCounterChannelWriter(streamWriter, (IThrowingFunction<IAnalysisCounterValueConsumer, IAnalysisIdleStateStreamModifierWriter, IOException>)((IThrowingFunction)AnalysisIdleStateStreamModifierWriter::new));
            }
            return new DatabaseSchedDerviedIncidentThreadCounterChannelWriter(streamWriter);
        }

        private @NonNull IDatabaseThreadCounterChannelWriter createDatabaseThreadCounterChannelWriter_SuppliedTid(@NonNull IAnalysisDeltaThreadStreamWriter streamWriter) {
            if (this.isDeltaCounter) {
                return new DatabaseSuppliedThreadCounterChannelWriter(streamWriter, (IThrowingFunction<IAnalysisCounterValueConsumer, IAnalysisIdleStateStreamModifierWriter, IOException>)((IThrowingFunction)AnalysisIdleStateStreamModifierWriter::new));
            }
            return new DatabaseSuppliedThreadCounterChannelWriter(streamWriter, (IThrowingFunction<IAnalysisCounterValueConsumer, IAnalysisIdleStateStreamModifierWriter, IOException>)((IThrowingFunction)NoOpAnalysisIdleStateStreamModifierWriter::new));
        }
    }
}

