/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.database.stream.counters;

import com.arm.streamline.analysis.database.api.counters.IAnalysisHardwareCounterReader;
import com.arm.streamline.analysis.database.stream.counters.DatabaseCounterChannelReader;
import com.arm.streamline.analysis.database.stream.counters.IDatabaseCounterChannelReader;
import com.arm.streamline.analysis.processing.ClosableCachingStreamReaderAdapter;
import com.arm.streamline.common.model.topology.ProcessingElementReference;
import com.arm.utils.function.Throwing;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class DatabaseCounterReader
implements IAnalysisHardwareCounterReader {
    private final @Nullable ClosableCachingStreamReaderAdapter<@Nullable IAnalysisHardwareCounterReader.Value, IDatabaseCounterChannelReader> @NonNull [] readers;

    public DatabaseCounterReader(@NonNull File counterDirectory, boolean deltaCounter, @NonNull ProcessingElementReference @NonNull [] channels) throws IOException {
        this.readers = new ClosableCachingStreamReaderAdapter[channels.length];
        Throwing.closeIfThrows(t -> {
            int i = 0;
            while (i < channels.length) {
                this.readers[i] = new ClosableCachingStreamReaderAdapter((IDatabaseCounterChannelReader)t.track((Closeable)new DatabaseCounterChannelReader(counterDirectory, deltaCounter, processingElementReferenceArray[i].vmUID, processingElementReferenceArray[i].deviceNumber, i)));
                ++i;
            }
            return null;
        });
    }

    public DatabaseCounterReader(@NonNull IDatabaseCounterChannelReader @NonNull [] readers) throws IOException {
        this.readers = new ClosableCachingStreamReaderAdapter[readers.length];
        int i = 0;
        while (i < readers.length) {
            this.readers[i] = new ClosableCachingStreamReaderAdapter(readers[i]);
            ++i;
        }
    }

    @Override
    public void close() throws IOException {
        Throwing.closeAll((Closeable[])this.readers);
    }

    @Override
    public int getChannelCount() {
        return this.readers.length;
    }

    @Override
    public @Nullable IAnalysisHardwareCounterReader.Value read() throws IOException {
        ClosableCachingStreamReaderAdapter<@Nullable IAnalysisHardwareCounterReader.Value, IDatabaseCounterChannelReader> bestReader = null;
        @Nullable IAnalysisHardwareCounterReader.Value bestValue = null;
        int i = 0;
        while (i < this.readers.length) {
            ClosableCachingStreamReaderAdapter<IAnalysisHardwareCounterReader.Value, IDatabaseCounterChannelReader> reader = this.readers[i];
            if (reader != null) {
                IAnalysisHardwareCounterReader.Value value = (IAnalysisHardwareCounterReader.Value)reader.head();
                if (value == null) {
                    reader.close();
                    this.readers[i] = null;
                } else if (bestValue == null || bestValue.timestamp > value.timestamp || bestValue.timestamp == value.timestamp && bestValue.sequenceNo > value.sequenceNo) {
                    bestValue = value;
                    bestReader = reader;
                }
            }
            ++i;
        }
        if (bestReader != null) {
            bestReader.next();
        }
        return bestValue;
    }
}

