/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.database.stream.chunkwriter;

import com.arm.streamline.analysis.database.stream.chunkwriter.AbstractBaseChunkWriter;
import com.arm.streamline.analysis.database.stream.chunkwriter.IAnalysisCounterValueConsumer;
import com.arm.streamline.common.utility.io.Compression;
import java.io.IOException;
import org.eclipse.jdt.annotation.NonNull;

public final class ZeroCompressingCounterValueChunkWriter
extends AbstractBaseChunkWriter
implements IAnalysisCounterValueConsumer {
    private boolean first = true;
    private long lastTimestamp = 0L;
    private long lastSequenceNo = 0L;
    private long lastTimestamp_SequenceNo = 0L;
    private boolean lastZeroWritten = false;
    private boolean lastZeroWritten_moreThanOne = false;
    private long lastZeroWritten_timestamp = 0L;

    public ZeroCompressingCounterValueChunkWriter(long key, @NonNull AbstractBaseChunkWriter.IChunkConsumer chunkConsumer) {
        super(key, chunkConsumer);
    }

    public ZeroCompressingCounterValueChunkWriter(long key, int chunkSize, @NonNull AbstractBaseChunkWriter.IChunkConsumer chunkConsumer) {
        super(key, chunkSize, chunkConsumer);
    }

    @Override
    public void consumeCounterValue(long time, long sequenceNo, long value) throws IOException {
        assert (this.first || this.lastTimestamp <= time);
        assert (this.lastSequenceNo <= sequenceNo);
        this.first = false;
        if (value == 0L && this.lastZeroWritten) {
            assert (this.lastZeroWritten_timestamp <= time);
            if (this.lastZeroWritten_timestamp != time) {
                this.lastZeroWritten_timestamp = time;
                this.lastZeroWritten_moreThanOne = true;
                this.lastTimestamp_SequenceNo = sequenceNo;
            }
            return;
        }
        if (this.lastZeroWritten && this.lastZeroWritten_moreThanOne) {
            assert (this.lastZeroWritten_timestamp <= time);
            this.outputRecord(this.lastZeroWritten_timestamp, this.lastTimestamp_SequenceNo, 0L);
        }
        this.outputRecord(time, sequenceNo, value);
        if (value != 0L) {
            this.lastZeroWritten = false;
        } else {
            this.lastZeroWritten = true;
            this.lastZeroWritten_timestamp = time;
            this.lastZeroWritten_moreThanOne = false;
            this.lastTimestamp_SequenceNo = sequenceNo;
        }
        this.completeRecord();
    }

    private void outputRecord(long time, long sequenceNo, long value) throws IOException {
        long deltaTimestamp = time - this.lastTimestamp;
        long deltaSequenceno = sequenceNo - this.lastSequenceNo;
        this.lastTimestamp = time;
        this.lastSequenceNo = sequenceNo;
        Compression.packInt((long)deltaTimestamp, (Compression.IBytesWriter)this);
        Compression.packInt((long)deltaSequenceno, (Compression.IBytesWriter)this);
        Compression.packInt((long)value, (Compression.IBytesWriter)this);
    }
}

