/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.database.stream.chunkwriter;

import com.arm.streamline.common.utility.io.Compression;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.jdt.annotation.NonNull;

public final class IndexFileReader
implements Closeable {
    private final @NonNull InputStream inputStream;

    public IndexFileReader(@NonNull InputStream inputStream) {
        this.inputStream = inputStream;
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
    }

    public void forEach( @NonNull IndexedChunkStreamWriter.IIndexConsumer consumer) throws IOException {
        try {
            while (true) {
                long key = Compression.unpackInt((InputStream)this.inputStream);
                long offset = Compression.unpackInt((InputStream)this.inputStream);
                int length = Math.toIntExact(Compression.unpackInt((InputStream)this.inputStream));
                consumer.consume(key, offset, length);
            }
        }
        catch (EOFException eOFException) {
            return;
        }
    }
}

