/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.database.stream.chunkwriter;

import com.arm.streamline.analysis.database.stream.chunkwriter.AbstractBaseChunkWriter;
import com.arm.streamline.analysis.database.stream.chunkwriter.IndexFileWriter;
import com.arm.streamline.analysis.database.stream.chunkwriter.IndexedChunkStreamWriter;
import com.arm.utils.function.Throwing;
import gnu.trove.map.TLongObjectMap;
import gnu.trove.map.hash.TLongObjectHashMap;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;

public abstract class AbstractChunkingCounterValueWriter<W extends AbstractBaseChunkWriter>
implements Closeable {
    private final @NonNull TLongObjectMap<W> chunkMap = new TLongObjectHashMap(10, 0.5f, Long.MIN_VALUE);
    private final @NonNull IndexedChunkStreamWriter index;
    private final @NonNull IndexFileWriter indexWriter;
    private final @NonNull OutputStream outputStream;

    public AbstractChunkingCounterValueWriter(@NonNull File dataPath, @NonNull File indexPath) throws IOException {
        this.outputStream = new FileOutputStream(dataPath);
        this.indexWriter = (IndexFileWriter)Throwing.closeIfThrows(IndexFileWriter::new, (Object)((FileOutputStream)Throwing.closeIfThrows(FileOutputStream::new, (Object)indexPath, (Closeable[])new Closeable[0])), (Closeable[])new Closeable[]{this.outputStream});
        this.index = new IndexedChunkStreamWriter(this.indexWriter, this.outputStream::write);
    }

    public AbstractChunkingCounterValueWriter(@NonNull OutputStream outputStream, @NonNull OutputStream indexOutputStream) {
        this.outputStream = outputStream;
        this.indexWriter = new IndexFileWriter(indexOutputStream);
        this.index = new IndexedChunkStreamWriter(this.indexWriter, outputStream::write);
    }

    @Override
    public void close() throws IOException {
        Throwing.closeAll((Iterable[])new Iterable[]{this.chunkMap.valueCollection(), List.of(this.outputStream, this.indexWriter)});
    }

    protected abstract @NonNull W createChunkWriter(long var1, @NonNull AbstractBaseChunkWriter.IChunkConsumer var3);

    protected final @NonNull W getChunkWriter(long key) {
        AbstractBaseChunkWriter chunkWriter = (AbstractBaseChunkWriter)this.chunkMap.get(key);
        if (chunkWriter == null) {
            chunkWriter = this.createChunkWriter(key, this.index);
            this.chunkMap.put(key, (Object)chunkWriter);
        }
        return (W)chunkWriter;
    }
}

