/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.database.stream.cam;

import com.arm.streamline.analysis.database.api.cam.IAnalysisCAMWriter;
import com.arm.streamline.analysis.database.stream.cam.CAMJobAggregatorMessages;
import com.arm.streamline.analysis.database.stream.cam.ICAMJobAggregator;
import com.arm.streamline.common.model.warnings.WarningItem;
import com.arm.streamline.common.model.warnings.WarningSeverity;
import com.arm.streamline.common.model.warnings.WarningType;
import gnu.trove.TIntCollection;
import gnu.trove.iterator.TIntObjectIterator;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.io.IOException;
import java.util.function.Consumer;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class CAMJobAggregator
implements ICAMJobAggregator {
    private final @NonNull TIntObjectMap<CAMEvent> camJobs = new TIntObjectHashMap();
    private final @NonNull IAnalysisCAMWriter camWriter;
    private final long vmEndTimestamp;
    private final @NonNull Consumer<@NonNull WarningItem> warningConsumer;

    public CAMJobAggregator(long vmEndTimestamp, @NonNull IAnalysisCAMWriter camWriter, @NonNull Consumer<@NonNull WarningItem> warningConsumer) {
        this.camWriter = camWriter;
        this.warningConsumer = warningConsumer;
        this.vmEndTimestamp = vmEndTimestamp;
    }

    @Override
    public void camJobDependencies(int jobUID, long timestamp, int primaryDependency, @Nullable TIntSet dependencies) throws IOException {
        @Nullable CAMEvent camEvent = (CAMEvent)this.camJobs.get(jobUID);
        if (camEvent == null) {
            return;
        }
        camEvent.setPrimaryDependency(primaryDependency);
        camEvent.setDependencies(dependencies);
    }

    @Override
    public void camJobStart(int jobUID, long timestamp, int track, @NonNull String name, int colour, @NonNull String detailText) throws IOException {
        @NonNull CAMEvent camEvent = new CAMEvent(jobUID, timestamp, name, colour, track, detailText);
        @Nullable CAMEvent oldCAMEvent = (CAMEvent)this.camJobs.put(jobUID, (Object)camEvent);
        if (oldCAMEvent != null) {
            this.warningConsumer.accept(CAMJobAggregator.incompletePartialCAMJobReceived());
        }
    }

    private static @NonNull WarningItem incompletePartialCAMJobReceived() {
        return new WarningItem(WarningType.CAM, WarningSeverity.MEDIUM, CAMJobAggregatorMessages.INCOMPLETE_PARTIAL_CAM_JOB_RECEIVED_TITLE, CAMJobAggregatorMessages.INCOMPLETE_PARTIAL_CAM_JOB_RECEIVED_DESCRIPTION);
    }

    @Override
    public void camJobStop(int jobUID, long timestamp) throws IOException {
        @Nullable CAMEvent camEvent = (CAMEvent)this.camJobs.remove(jobUID);
        if (camEvent == null) {
            return;
        }
        camEvent.setStopTime(timestamp);
        this.emit(camEvent);
    }

    @Override
    public void close() throws IOException {
        TIntObjectIterator it = this.camJobs.iterator();
        while (it.hasNext()) {
            it.advance();
            CAMEvent event = (CAMEvent)it.value();
            event.setStopTime(this.vmEndTimestamp);
            this.emit(event);
        }
    }

    private void emit(@NonNull CAMEvent camEvent) throws IOException {
        this.camWriter.consumeCAMJob(camEvent.getJobUID(), camEvent.getStartTime(), camEvent.getName(), camEvent.getTrack(), camEvent.getStopTime(), camEvent.getPrimaryDependency(), camEvent.getDependencies(), camEvent.getColor(), camEvent.getDetailText());
    }

    public static final class CAMEvent {
        private final int colour;
        private final @NonNull TIntSet dependencies = new TIntHashSet();
        private final int jobUID;
        private final @NonNull String name;
        private int primaryDependency = -1;
        private final long startTime;
        private long stopTime;
        private final int track;
        private final @NonNull String detailText;

        public CAMEvent(int jobUID, long startTime, @NonNull String name, int colour, int track, @NonNull String detailText) {
            this.startTime = startTime;
            this.jobUID = jobUID;
            this.name = name;
            this.colour = colour;
            this.track = track;
            this.detailText = detailText;
        }

        public void addDependency(int dependency) {
            if (dependency > 0) {
                this.dependencies.add(dependency);
            }
        }

        public int getColor() {
            return this.colour;
        }

        public @NonNull TIntSet getDependencies() {
            return this.dependencies;
        }

        public long getDuration() {
            return this.stopTime - this.startTime;
        }

        public int getJobUID() {
            return this.jobUID;
        }

        public @NonNull String getName() {
            return this.name;
        }

        public int getPrimaryDependency() {
            return this.primaryDependency;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public long getStopTime() {
            return this.stopTime;
        }

        public int getTrack() {
            return this.track;
        }

        public @NonNull String getDetailText() {
            return this.detailText;
        }

        public void setDependencies(@Nullable TIntSet dependencies) {
            this.dependencies.clear();
            if (dependencies != null) {
                this.dependencies.addAll((TIntCollection)dependencies);
            }
        }

        public void setPrimaryDependency(int primaryDependency) {
            this.primaryDependency = primaryDependency;
        }

        public void setStopTime(long stopTime) {
            this.stopTime = stopTime;
        }
    }

    @FunctionalInterface
    public static interface ICAMJobAggregatorFactory {
        public @NonNull ICAMJobAggregator create(long var1, @NonNull IAnalysisCAMWriter var3, @NonNull Consumer<@NonNull WarningItem> var4);
    }
}

