/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.database.stream.annotations;

import com.arm.streamline.analysis.database.api.annotations.AnnotationTextGroupChannelIdentifier;
import com.arm.streamline.analysis.database.api.annotations.IAnalysisAnnotationsPerChannelWriter;
import com.arm.streamline.analysis.database.api.annotations.IAnalysisAnnotationsWriter;
import com.arm.streamline.analysis.database.stream.AbstractDynamicAllocatedChannelWriter;
import com.arm.streamline.analysis.database.stream.annotations.DatabaseAnnotationPerChannelEventWriter;
import com.arm.streamline.report.model.uids.IUniqueThreadID;
import com.arm.utils.function.IThrowingLongFunction;
import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class DatabaseAnnotationEventWriter
extends AbstractDynamicAllocatedChannelWriter<IAnalysisAnnotationsPerChannelWriter, Long>
implements IAnalysisAnnotationsWriter {
    private final @NonNull IThrowingLongFunction<@NonNull IAnalysisAnnotationsPerChannelWriter, IOException> channelWriterFactory;

    public DatabaseAnnotationEventWriter(@NonNull File annotationsPath) throws IOException {
        super(Long.class);
        this.channelWriterFactory = uid -> new DatabaseAnnotationPerChannelEventWriter(annotationsPath, uid);
    }

    DatabaseAnnotationEventWriter(@NonNull IThrowingLongFunction<@NonNull IAnalysisAnnotationsPerChannelWriter, IOException> channelWriterFactory) {
        super(Long.class);
        this.channelWriterFactory = channelWriterFactory;
    }

    @Override
    public void consumeAnnotationError(@NonNull IUniqueThreadID utid, long timestamp, @NonNull String message) throws IOException {
        @NonNull IAnalysisAnnotationsPerChannelWriter channelWriter = this.getOrCreateChannel(utid);
        channelWriter.consumeAnnotationError(utid, timestamp, message);
    }

    @Override
    public void consumeAnnotationMarker(@NonNull IUniqueThreadID utid, long timestamp, int colour, @Nullable String message) throws IOException {
        @NonNull IAnalysisAnnotationsPerChannelWriter channelWriter = this.getOrCreateChannel(utid);
        channelWriter.consumeAnnotationMarker(utid, timestamp, colour, message);
    }

    @Override
    public void consumeAnnotationNameChannel(@NonNull IUniqueThreadID utid, long timestamp, @NonNull AnnotationTextGroupChannelIdentifier channel, @NonNull AnnotationTextGroupChannelIdentifier group, @NonNull String name) throws IOException {
        if (!channel.utid().equals(utid)) {
            throw new IllegalArgumentException();
        }
        if (!group.utid().equals(utid)) {
            throw new IllegalArgumentException();
        }
        if (!group.sameDomainAs(channel)) {
            throw new IllegalArgumentException();
        }
        @NonNull IAnalysisAnnotationsPerChannelWriter channelWriter = this.getOrCreateChannel(utid);
        channelWriter.consumeAnnotationNameChannel(utid, timestamp, channel, group, name);
    }

    @Override
    public void consumeAnnotationNameGroup(@NonNull IUniqueThreadID utid, long timestamp, @NonNull AnnotationTextGroupChannelIdentifier group, @NonNull String name) throws IOException {
        if (!group.utid().equals(utid)) {
            throw new IllegalArgumentException();
        }
        @NonNull IAnalysisAnnotationsPerChannelWriter channelWriter = this.getOrCreateChannel(utid);
        channelWriter.consumeAnnotationNameGroup(utid, timestamp, group, name);
    }

    @Override
    public void consumeAnnotationText(@NonNull IUniqueThreadID utid, long timestamp, @NonNull AnnotationTextGroupChannelIdentifier channel, int colour, @NonNull String message) throws IOException {
        if (!channel.utid().equals(utid)) {
            throw new IllegalArgumentException();
        }
        @NonNull IAnalysisAnnotationsPerChannelWriter channelWriter = this.getOrCreateChannel(utid);
        channelWriter.consumeAnnotationText(utid, timestamp, channel, colour, message);
    }

    @Override
    public void consumeAnnotationVisual(@NonNull IUniqueThreadID utid, long timestamp, @Nullable String msg, byte @NonNull [] imageData) throws IOException {
        @NonNull IAnalysisAnnotationsPerChannelWriter channelWriter = this.getOrCreateChannel(utid);
        channelWriter.consumeAnnotationVisual(utid, timestamp, msg, imageData);
    }

    @Override
    protected Comparator<@NonNull Long> comparator() {
        return Long::compare;
    }

    @Override
    protected @NonNull IAnalysisAnnotationsPerChannelWriter createNewChannel(@NonNull Long channel) throws IOException {
        return (IAnalysisAnnotationsPerChannelWriter)this.channelWriterFactory.apply(channel.longValue());
    }

    @Override
    protected boolean validChannel(@NonNull Long channel) {
        return true;
    }

    @Override
    private @NonNull IAnalysisAnnotationsPerChannelWriter getOrCreateChannel(@NonNull IUniqueThreadID utid) throws IOException {
        return (IAnalysisAnnotationsPerChannelWriter)this.getOrCreateChannel(utid.getVmUID());
    }
}

