/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.database.stream.activity;

import com.arm.streamline.analysis.database.api.activity.IAnalysisActivityWriter;
import com.arm.streamline.analysis.database.api.scheduler.IAnalysisSchedulerTraceWriter;
import com.arm.streamline.analysis.database.stream.activity.DatabaseActivityEventWriterV2;
import com.arm.streamline.common.model.topology.DeviceType;
import com.arm.streamline.common.model.topology.ProcessingElementReference;
import com.arm.streamline.common.model.topology.ProcessingElementReferenceSet;
import com.arm.streamline.report.model.uids.IUniqueThreadID;
import java.io.File;
import java.io.IOException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class DatabaseSchedulerTraceWriter
implements IAnalysisSchedulerTraceWriter {
    public static final int ACTIVITY_IDLE = 0;
    public static final int ACTIVITY_KERNEL = 2;
    public static final int ACTIVITY_USER = 1;
    private final @NonNull IAnalysisActivityWriter activityWriter;

    public DatabaseSchedulerTraceWriter(@NonNull File dbPath, @NonNull ProcessingElementReferenceSet peReferenceSet) {
        this.activityWriter = new DatabaseActivityEventWriterV2(dbPath, DeviceType.CPU, peReferenceSet);
    }

    @Override
    public void close() throws IOException {
        this.activityWriter.close();
    }

    @Override
    public void consumeSchedFree(@NonNull IUniqueThreadID utid, long time) throws IOException {
        this.activityWriter.consumeActivityFree(utid, time);
    }

    @Override
    public void consumeSchedSwitch(@NonNull ProcessingElementReference peReference, @Nullable IUniqueThreadID utid, long time, int state) throws IOException {
        int activity = utid == null || utid.isIdle() ? 0 : (utid.isKernel() ? 2 : 1);
        this.activityWriter.consumeActivitySwitch(peReference, utid, time, activity, state);
    }
}

