/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.database.stream.activity;

import com.arm.streamline.analysis.database.api.activity.IAnalysisActivityPerChannelWriter;
import com.arm.streamline.common.utility.io.CompressedOutputStream;
import com.arm.streamline.common.utility.io.Compression;
import com.arm.streamline.report.model.uids.IUniqueThreadID;
import com.arm.utils.NullChecking;
import com.arm.utils.function.Throwing;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class DatabaseActivityPerChannelWriter
implements IAnalysisActivityPerChannelWriter {
    public static final int EVENT_FREE = 0;
    public static final int EVENT_STOP = 1;
    public static final int EVENT_SWITCH_NO_UTID = 2;
    public static final int EVENT_SWITCH_WITH_UTID = 3;
    private boolean first = true;
    private long lastTimestamp = 0L;
    private final @NonNull OutputStream outputStream;

    public static @NonNull File makeFile(@NonNull File parentDirectory, int channelNumber) {
        return new File(parentDirectory, String.format("activity-%d.db.gz", channelNumber));
    }

    public static @NonNull File makeFile(@NonNull File parentDirectory, long vmUID, int deviceNumber) {
        return new File(parentDirectory, String.format("%d-%d.db.gz", vmUID, deviceNumber));
    }

    public DatabaseActivityPerChannelWriter(@NonNull File parentDirectory, long vmUID, int deviceNumber) throws IOException {
        File path = DatabaseActivityPerChannelWriter.makeFile(parentDirectory, vmUID, deviceNumber);
        File directory = (File)NullChecking.neverNull((Object)path.getParentFile());
        directory.mkdirs();
        this.outputStream = (OutputStream)Throwing.closeIfThrows(gos -> new BufferedOutputStream((OutputStream)gos), (Object)((CompressedOutputStream)Throwing.closeIfThrows(fos -> new CompressedOutputStream((OutputStream)fos), (Object)new FileOutputStream(path), (Closeable[])new Closeable[0])), (Closeable[])new Closeable[0]);
    }

    DatabaseActivityPerChannelWriter(@NonNull OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    @Override
    public void close() throws IOException {
        this.outputStream.close();
    }

    @Override
    public void consumeActivityFree(@NonNull IUniqueThreadID utid, long time) throws IOException {
        this.writeHeader(0, time);
        Compression.packInt((long)utid.getUID(), (OutputStream)this.outputStream);
    }

    @Override
    public void consumeActivityStop(long time, int state) throws IOException {
        this.writeHeader(1, time);
        Compression.packInt((long)state, (OutputStream)this.outputStream);
    }

    @Override
    public void consumeActivitySwitch(@Nullable IUniqueThreadID utid, long time, int activity, int state) throws IOException {
        int type = utid != null ? 3 : 2;
        this.writeHeader(type, time);
        Compression.packInt((long)activity, (OutputStream)this.outputStream);
        Compression.packInt((long)state, (OutputStream)this.outputStream);
        if (utid != null) {
            Compression.packInt((long)utid.getUID(), (OutputStream)this.outputStream);
        }
    }

    private void writeHeader(int type, long time) throws IOException {
        assert (this.first || this.lastTimestamp <= time);
        this.first = false;
        long delta = time - this.lastTimestamp;
        this.lastTimestamp = time;
        Compression.packInt((long)type, (OutputStream)this.outputStream);
        Compression.packInt((long)delta, (OutputStream)this.outputStream);
    }
}

