/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.database.stream.activity;

import com.arm.streamline.analysis.database.api.activity.IAnalysisActivityPerChannelWriter;
import com.arm.streamline.analysis.database.api.activity.IAnalysisActivityWriter;
import com.arm.streamline.analysis.database.stream.AbstractDynamicAllocatedChannelWriter;
import com.arm.streamline.analysis.database.stream.activity.DatabaseActivityPerChannelWriter;
import com.arm.streamline.common.model.topology.DeviceType;
import com.arm.streamline.common.model.topology.ProcessingElementReference;
import com.arm.streamline.common.model.topology.ProcessingElementReferenceSet;
import com.arm.streamline.report.model.uids.IUniqueThreadID;
import com.arm.utils.NullChecking;
import com.arm.utils.collections.Pair;
import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class DatabaseActivityEventWriterV2
extends AbstractDynamicAllocatedChannelWriter<IAnalysisActivityPerChannelWriter, ProcessingElementReference>
implements IAnalysisActivityWriter {
    private final @NonNull Map<@NonNull ProcessingElementReference, @Nullable Pair<@Nullable IUniqueThreadID, @NonNull Integer>> activeState = new HashMap<ProcessingElementReference, Pair<IUniqueThreadID, Integer>>();
    private final @NonNull DeviceType deviceType;
    private final @NonNull File dbPath;
    private final @NonNull ProcessingElementReferenceSet peReferenceSet;

    public DatabaseActivityEventWriterV2(@NonNull File dbPath, @NonNull DeviceType deviceType, @NonNull ProcessingElementReferenceSet peReferenceSet) {
        super(ProcessingElementReference.class);
        this.dbPath = dbPath;
        this.deviceType = deviceType;
        this.peReferenceSet = peReferenceSet;
    }

    DatabaseActivityEventWriterV2(@NonNull Map<@NonNull ProcessingElementReference, @NonNull IAnalysisActivityPerChannelWriter> channels, @NonNull File dbPath, @NonNull DeviceType deviceType, @NonNull ProcessingElementReferenceSet peReferenceSet) {
        super(ProcessingElementReference.class, channels);
        this.dbPath = dbPath;
        this.deviceType = deviceType;
        this.peReferenceSet = peReferenceSet;
    }

    @Override
    public void consumeActivityFree(@NonNull IUniqueThreadID utid, long time) throws IOException {
        @NonNull ProcessingElementReference channel = this.peReferenceSet.get(this.deviceType, utid.getVmUID(), 0);
        @NonNull IAnalysisActivityPerChannelWriter writer = (IAnalysisActivityPerChannelWriter)this.getOrCreateChannel(channel);
        writer.consumeActivityFree(utid, time);
    }

    @Override
    public void consumeActivityStop(@NonNull ProcessingElementReference peReference, long time, int state) throws IOException {
        @Nullable Pair<@Nullable IUniqueThreadID, @NonNull Integer> prevState = this.activeState.get(peReference);
        if (prevState != null) {
            @NonNull IAnalysisActivityPerChannelWriter writer = (IAnalysisActivityPerChannelWriter)this.getOrCreateChannel(peReference);
            writer.consumeActivityStop(time, state);
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public void consumeActivitySwitch(@NonNull ProcessingElementReference peReference, @Nullable IUniqueThreadID utid, long time, int activity, int state) throws IOException {
        @Nullable Pair<@Nullable IUniqueThreadID, @NonNull Integer> prevState = this.activeState.get(peReference);
        @NonNull @Nullable @NonNull Pair newState = new Pair((Object)utid, (Object)activity);
        if (!NullChecking.equalsNullable((Object)newState, prevState)) {
            this.activeState.put(peReference, (Pair<IUniqueThreadID, Integer>)newState);
            @NonNull IAnalysisActivityPerChannelWriter writer = (IAnalysisActivityPerChannelWriter)this.getOrCreateChannel(peReference);
            writer.consumeActivitySwitch(utid, time, activity, state);
        }
    }

    @Override
    protected Comparator<ProcessingElementReference> comparator() {
        return Comparator.naturalOrder();
    }

    @Override
    protected @NonNull DatabaseActivityPerChannelWriter createNewChannel(@NonNull ProcessingElementReference peReference) throws IOException {
        return new DatabaseActivityPerChannelWriter(this.dbPath, peReference.vmUID, peReference.deviceNumber);
    }

    @Override
    protected boolean validChannel(@NonNull ProcessingElementReference peReference) {
        return this.deviceType.equals((Object)peReference.deviceType);
    }
}

