/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.database.stream;

import com.arm.streamline.analysis.model.threads.IExecutablePath;
import com.arm.streamline.common.utility.io.Compression;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class ChannelExecutablePathReader {
    private final @NonNull TIntObjectMap<IExecutablePath> executablePaths = new TIntObjectHashMap(10, 0.5f, 1);

    private @NonNull IExecutablePath requireExecutablePath(int cookie) {
        @Nullable IExecutablePath result = (IExecutablePath)this.executablePaths.get(cookie);
        if (result == null) {
            throw new AssertionError();
        }
        return result;
    }

    public @Nullable IExecutablePath readExecutablePath(@NonNull InputStream inputStream) throws IOException {
        int cookie = (int)Compression.unpackInt((InputStream)inputStream);
        switch (cookie) {
            case -1: {
                return null;
            }
            case -2: {
                return IExecutablePath.IDLE;
            }
            case -3: {
                return IExecutablePath.KERNEL;
            }
            case 0: {
                return IExecutablePath.NONE;
            }
            case 1: {
                return this.readNewExecutablePath(inputStream);
            }
        }
        return this.requireExecutablePath(cookie);
    }

    private @NonNull IExecutablePath readNewExecutablePath(@NonNull InputStream inputStream) throws IOException {
        long type = Compression.unpackInt((InputStream)inputStream);
        switch (Math.toIntExact(type)) {
            case 0: {
                int cookie = (int)Compression.unpackInt((InputStream)inputStream);
                String path = Compression.readString((InputStream)inputStream);
                IExecutablePath executablePath = IExecutablePath.createFromPath(path);
                this.executablePaths.put(cookie, (Object)executablePath);
                return executablePath;
            }
            case 1: {
                int cookie = (int)Compression.unpackInt((InputStream)inputStream);
                String path = Compression.readString((InputStream)inputStream);
                String entry = Compression.readString((InputStream)inputStream);
                IExecutablePath executablePath = IExecutablePath.createFromZipEntry(path, entry);
                this.executablePaths.put(cookie, (Object)executablePath);
                return executablePath;
            }
        }
        throw new IOException("Invalid type code");
    }
}

