/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.database.stream;

import com.arm.utils.MapUtils;
import com.arm.utils.function.Throwing;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public abstract class AbstractDynamicAllocatedChannelWriter<T extends Closeable, U>
implements Closeable {
    private final @NonNull Map<@NonNull U, @NonNull T> channels;
    private final @NonNull Class<U> clazz;

    protected AbstractDynamicAllocatedChannelWriter(@NonNull Class<U> clazz) {
        this.clazz = clazz;
        this.channels = new HashMap<U, T>();
    }

    protected AbstractDynamicAllocatedChannelWriter(@NonNull Class<U> clazz, @NonNull Map<@NonNull U, @NonNull T> channels) {
        this.clazz = clazz;
        this.channels = channels;
    }

    @Override
    public void close() throws IOException {
        Throwing.closeAll((Iterable[])new Iterable[]{this.channels.values()});
    }

    public final @NonNull U @NonNull [] getChannels() {
        @NonNull Object @NonNull [] result = this.channels.keySet().toArray((Object[])Array.newInstance(this.clazz, this.channels.size()));
        @Nullable Comparator<U> comparator = this.comparator();
        if (comparator != null) {
            Arrays.sort(result, comparator);
        }
        return result;
    }

    protected final @NonNull Collection<@NonNull T> allChannels() {
        return Collections.unmodifiableCollection(this.channels.values());
    }

    protected abstract @Nullable Comparator<@NonNull U> comparator();

    protected abstract @NonNull T createNewChannel(@NonNull U var1) throws IOException;

    protected @NonNull T getOrCreateChannel(@NonNull U channel) throws IOException {
        if (!this.validChannel(channel)) {
            throw new IllegalArgumentException();
        }
        return (T)((Closeable)MapUtils.computeIfAbsentThrows(this.channels, channel, this::createNewChannel));
    }

    protected abstract boolean validChannel(@NonNull U var1);
}

