/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.database.api.counters;

import com.arm.streamline.analysis.database.api.IEventReader;
import com.arm.streamline.analysis.database.api.IEventReaderValue;
import com.arm.utils.NullChecking;
import org.eclipse.jdt.annotation.Nullable;

public interface IAnalysisHardwareCounterReader
extends IEventReader<Value> {
    public int getChannelCount();

    public static final class Value
    implements IEventReaderValue {
        public final int channelIndex;
        public final long duration;
        public final long sequenceNo;
        public final long timestamp;
        public final @Nullable Integer utid;
        public final long value;

        public Value(int channelIndex, long timestamp, long sequenceNo, long duration, @Nullable Integer utid, long value) {
            this.channelIndex = channelIndex;
            this.timestamp = timestamp;
            this.sequenceNo = sequenceNo;
            this.duration = duration;
            this.utid = utid;
            this.value = value;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (obj instanceof Value) {
                Value that = (Value)obj;
                return this.channelIndex == that.channelIndex && this.timestamp == that.timestamp && this.sequenceNo == that.sequenceNo && this.duration == that.duration && NullChecking.equalsNullable((Object)this.utid, (Object)that.utid) && this.value == that.value;
            }
            return false;
        }

        @Override
        public long getTimestamp() {
            return this.timestamp;
        }

        public int hashCode() {
            int result = Integer.hashCode(this.channelIndex) * 31;
            result ^= Long.hashCode(this.timestamp) * 31;
            result ^= Long.hashCode(this.sequenceNo) * 31;
            result ^= Long.hashCode(this.duration) * 31;
            result ^= Long.hashCode(this.value) * 31;
            return result ^= NullChecking.hashNullable((Object)this.utid) * 31;
        }

        public String toString() {
            return "Value [channelIndex=" + this.channelIndex + ", timestamp=" + this.timestamp + ", sequenceNo=" + this.sequenceNo + ", duration=" + this.duration + ", utid=" + String.valueOf(this.utid) + ", value=" + this.value + "]";
        }
    }
}

