/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.database;

import com.arm.streamline.analysis.database.ZeroLengthCaptureException;
import com.arm.streamline.analysis.model.IVirtualMachineProperties;
import com.arm.streamline.analysis.model.VirtualMachineProperties;
import com.arm.streamline.common.utility.io.XMLGenerator;
import com.arm.streamline.common.utility.io.XMLParser;
import com.arm.utils.NullChecking;
import gnu.trove.iterator.TLongObjectIterator;
import gnu.trove.map.TLongObjectMap;
import gnu.trove.map.hash.TLongObjectHashMap;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.eclipse.jdt.annotation.NonNull;

public class VirtualMachinePropertiesReaderWriter {
    private static final String ATTR_APP_MODE = "appmode";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_START_TIME = "start";
    private static final String ATTR_STOP_TIME = "end";
    private static final String ATTR_VM_TIMESTAMP_BASE = "base";
    private static final String ATTR_VMUID = "uid";
    private static final String TAG_VIRTUAL_MACHINE = "vm";
    private static final String TAG_VIRTUAL_MACHINES = "virtual-machines";

    public static @NonNull TLongObjectMap<VirtualMachineProperties> read(@NonNull File file) throws IOException {
        @NonNull TLongObjectHashMap result = new TLongObjectHashMap();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (XMLParser xml = XMLParser.create((File)file);){
                String rootTag;
                String rootMarker = xml.getMarker();
                while ((rootTag = xml.nextTag(rootMarker)) != null) {
                    if (TAG_VIRTUAL_MACHINES.equals(rootTag)) {
                        String vmTag;
                        String vmMarker = xml.getMarker();
                        while ((vmTag = xml.nextTag(vmMarker)) != null) {
                            if (TAG_VIRTUAL_MACHINE.equals(vmTag)) {
                                long vmUID = xml.getLongAttribute(ATTR_VMUID);
                                VirtualMachineProperties perVmState = VirtualMachinePropertiesReaderWriter.readAttributes(xml);
                                result.put(vmUID, (Object)perVmState);
                                continue;
                            }
                            xml.skip();
                        }
                        continue;
                    }
                    xml.skip();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        return result;
    }

    public static void write(@NonNull File file, @NonNull TLongObjectMap<? extends IVirtualMachineProperties> vmStatesMap) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (XMLGenerator xml = XMLGenerator.create((File)file);){
            xml.startDocument();
            xml.startTag(TAG_VIRTUAL_MACHINES);
            TLongObjectIterator it = vmStatesMap.iterator();
            while (it.hasNext()) {
                it.advance();
                long vmUID = it.key();
                IVirtualMachineProperties perVmState = (IVirtualMachineProperties)NullChecking.neverNull((Object)((IVirtualMachineProperties)it.value()));
                xml.startEmptyTag(TAG_VIRTUAL_MACHINE);
                xml.addAttribute(ATTR_VMUID, vmUID);
                VirtualMachinePropertiesReaderWriter.writeAttributes(xml, perVmState);
            }
            xml.endTag();
            xml.endDocument();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static @NonNull VirtualMachineProperties readAttributes(@NonNull XMLParser xml) {
        long stopTime;
        long startTime = xml.getLongAttribute(ATTR_START_TIME, Long.MAX_VALUE);
        if (startTime >= (stopTime = xml.getLongAttribute(ATTR_STOP_TIME, 0L))) {
            throw new ZeroLengthCaptureException();
        }
        return new VirtualMachineProperties(xml.getAttribute(ATTR_NAME), startTime, stopTime, xml.getLongAttribute(ATTR_VM_TIMESTAMP_BASE, 0L), xml.isAttributeSet(ATTR_APP_MODE, false));
    }

    private static void writeAttributes(@NonNull XMLGenerator xml, @NonNull IVirtualMachineProperties vmProperties) throws IOException {
        long vmStartTime = vmProperties.getVmStartTimestamp();
        xml.addAttributeNot(ATTR_NAME, vmProperties.getVmName(), null);
        xml.addAttributeNot(ATTR_APP_MODE, vmProperties.isApplicationTracingMode(), false);
        xml.addAttributeNot(ATTR_VM_TIMESTAMP_BASE, vmStartTime, 0L);
        if (vmProperties.isAnyTimesSeen()) {
            long rawStartTime = vmProperties.getMonotonicRawBase();
            long duration = vmProperties.getDuration();
            xml.addAttribute(ATTR_START_TIME, rawStartTime);
            xml.addAttribute(ATTR_STOP_TIME, rawStartTime + duration);
        }
    }
}

