/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.database;

import com.arm.streamline.analysis.model.AnnotationDataStructure;
import com.arm.streamline.common.utility.io.XMLGenerator;
import java.io.File;
import java.io.IOException;
import org.eclipse.jdt.annotation.NonNull;

public class ChannelsWriter {
    private static final String TAG_CHANNELS = "channels";
    private static final String ATTR_VERSION = "version";
    private static final String TAG_THREAD = "thread";
    private static final String ATTR_ID = "id";
    private static final String TAG_GROUP = "group";
    private static final String TAG_CHANNEL = "channel";
    private static final String ATTR_NUMBER = "number";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_ORIGINAL = "original";

    public static void write(@NonNull File file, @NonNull AnnotationDataStructure annotations) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (XMLGenerator xml = XMLGenerator.create((File)file);){
            int[] threads;
            xml.startDocument();
            xml.startTag(TAG_CHANNELS);
            xml.addAttribute(ATTR_VERSION, 1);
            int[] nArray = threads = annotations.getUtids();
            int n = threads.length;
            int n2 = 0;
            while (n2 < n) {
                int[] groups;
                int thread = nArray[n2];
                xml.startTag(TAG_THREAD);
                xml.addAttribute(ATTR_ID, thread);
                int[] nArray2 = groups = annotations.getGroups(thread);
                int n3 = groups.length;
                int n4 = 0;
                while (n4 < n3) {
                    int[] channels;
                    int group = nArray2[n4];
                    xml.startTag(TAG_GROUP);
                    String groupName = annotations.getGroupName(thread, group);
                    Integer originalGroup = annotations.getOriginalGroup(thread, group);
                    if (!groupName.isEmpty()) {
                        xml.addAttribute(ATTR_NAME, groupName);
                        if (originalGroup != null) {
                            xml.addAttribute(ATTR_ORIGINAL, originalGroup.intValue());
                        }
                    }
                    xml.addAttribute(ATTR_NUMBER, group);
                    int[] nArray3 = channels = annotations.getChannels(thread);
                    int n5 = channels.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        int channel = nArray3[n6];
                        if (annotations.containsChannel(thread, channel, group)) {
                            xml.startEmptyTag(TAG_CHANNEL);
                            String channelName = annotations.getChannelName(thread, channel);
                            Integer originalChannel = annotations.getOriginalChannel(thread, channel);
                            xml.addAttribute(ATTR_NAME, channelName);
                            xml.addAttribute(ATTR_NUMBER, channel);
                            if (originalChannel != null) {
                                xml.addAttribute(ATTR_ORIGINAL, originalChannel.intValue());
                            }
                        }
                        ++n6;
                    }
                    xml.endTag();
                    ++n4;
                }
                xml.endTag();
                ++n2;
            }
            xml.endTag();
            xml.endDocument();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

