/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.database;

import com.arm.streamline.analysis.model.cam.ICAMTrackBase;
import com.arm.streamline.common.utility.io.CommonFileUtils;
import com.arm.streamline.common.utility.io.StreamUtils;
import gnu.trove.iterator.TIntObjectIterator;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.eclipse.jdt.annotation.NonNull;

public class CAMTrackWriter {
    public static <T extends ICAMTrackBase> void write(@NonNull File tracksFile, @NonNull TIntObjectIterator<T> tracks) throws IOException {
        CommonFileUtils.makeDirectory((File)tracksFile.getParentFile());
        Throwable throwable = null;
        Object var3_4 = null;
        try (DataOutputStream out = StreamUtils.createCompressedDataOutput((File)tracksFile);){
            while (tracks.hasNext()) {
                tracks.advance();
                ICAMTrackBase track = (ICAMTrackBase)tracks.value();
                assert (track != null);
                out.writeInt(track.getId());
                byte[] bytes = track.getTitle().getBytes(StandardCharsets.UTF_8);
                out.writeInt(bytes.length);
                out.write(bytes);
                out.writeInt(track.getParentId());
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

