/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.spe.decoders;

import com.arm.streamline.spe.decoders.ISpeRawPacketConsumer;
import com.arm.streamline.spe.decoders.SpeDecodeException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.eclipse.jdt.annotation.NonNull;

public class SpeRawDecoder<T extends Throwable> {
    private @NonNull ISpeRawPacketConsumer<T> consumer;
    private @NonNull ByteBuffer payload;
    private @NonNull SpeHeaderTypes type;
    private boolean isExtendeHeader;
    private byte extendedHeader;
    private byte header;

    public SpeRawDecoder(@NonNull ISpeRawPacketConsumer<T> consumer) {
        this.consumer = consumer;
        this.payload = ByteBuffer.allocate(8);
        this.payload.order(ByteOrder.LITTLE_ENDIAN);
        this.type = SpeHeaderTypes.NONE;
    }

    public void decode(byte speRawByte) throws T, SpeDecodeException {
        switch (this.type) {
            case NONE: {
                this.header = speRawByte;
                this.type = SpeRawDecoder.decoderHeader(speRawByte);
                if (this.type != SpeHeaderTypes.EXTENDED_HEADER) break;
                this.header = 0;
                this.extendedHeader = speRawByte;
                this.isExtendeHeader = true;
                break;
            }
            case EXTENDED_HEADER: {
                this.header = speRawByte;
                this.type = SpeRawDecoder.decoderHeader(speRawByte);
                if (this.type != SpeHeaderTypes.EXTENDED_HEADER) break;
                int fullHeader = Byte.toUnsignedInt(this.extendedHeader) | Byte.toUnsignedInt(this.header) << 8;
                this.reset(this.payload);
                throw new SpeDecodeException(SpeDecodeException.Reason.RESERVED_HEADER, "Reserved header type: 0x" + Integer.toHexString(fullHeader));
            }
            default: {
                this.payload.put(speRawByte);
            }
        }
        this.type = this.processPayload(this.type, this.payload, this.extendedHeader, this.header, this.isExtendeHeader);
    }

    private @NonNull SpeHeaderTypes processPayload(@NonNull SpeHeaderTypes type, @NonNull ByteBuffer payload, byte extendedHeader, byte header, boolean isExtendeHeader) throws T, SpeDecodeException {
        switch (type) {
            case NO_PAYLOAD: {
                if (isExtendeHeader) {
                    this.consumer.rawPacketExtended(extendedHeader, header);
                } else {
                    this.consumer.rawPacket(header);
                }
                type = this.reset(payload);
                break;
            }
            case BYTE_PAYLOAD: {
                if (payload.position() != SpeHeaderTypes.BYTE_PAYLOAD.getPayloadSize()) break;
                if (isExtendeHeader) {
                    this.consumer.rawPacketExtended(extendedHeader, header, payload.get(0));
                } else {
                    this.consumer.rawPacket(header, payload.get(0));
                }
                type = this.reset(payload);
                break;
            }
            case SHORT_PAYLOAD: {
                if (payload.position() != SpeHeaderTypes.SHORT_PAYLOAD.getPayloadSize()) break;
                if (isExtendeHeader) {
                    this.consumer.rawPacketExtended(extendedHeader, header, payload.getShort(0));
                } else {
                    this.consumer.rawPacket(header, payload.getShort(0));
                }
                type = this.reset(payload);
                break;
            }
            case INT_PAYLOAD: {
                if (payload.position() != SpeHeaderTypes.INT_PAYLOAD.getPayloadSize()) break;
                if (isExtendeHeader) {
                    this.consumer.rawPacketExtended(extendedHeader, header, payload.getInt(0));
                } else {
                    this.consumer.rawPacket(header, payload.getInt(0));
                }
                type = this.reset(payload);
                break;
            }
            case LONG_PAYLOAD: {
                if (payload.position() != SpeHeaderTypes.LONG_PAYLOAD.getPayloadSize()) break;
                if (isExtendeHeader) {
                    this.consumer.rawPacketExtended(extendedHeader, header, payload.getLong(0));
                } else {
                    this.consumer.rawPacket(header, payload.getLong(0));
                }
                type = this.reset(payload);
                break;
            }
            case NONE: 
            case EXTENDED_HEADER: {
                break;
            }
            default: {
                throw new AssertionError((Object)type);
            }
        }
        return type;
    }

    private @NonNull SpeHeaderTypes reset(@NonNull ByteBuffer payload) {
        payload.clear();
        this.extendedHeader = 0;
        this.header = 0;
        this.isExtendeHeader = false;
        return SpeHeaderTypes.NONE;
    }

    @SuppressFBWarnings(value={"UC_USELESS_CONDITION"}, justification="See comments inside the function")
    private static @NonNull SpeHeaderTypes decoderHeader(byte b) throws AssertionError {
        if (b >= 0 && b <= 31) {
            return SpeHeaderTypes.NO_PAYLOAD;
        }
        if (b >= 64 && b <= 79 || b >= -128 && b <= -113 || b >= -64 && b <= -49) {
            return SpeHeaderTypes.BYTE_PAYLOAD;
        }
        if (b >= 80 && b <= 95 || b >= -112 && b <= -97 || b >= -48 && b <= -33) {
            return SpeHeaderTypes.SHORT_PAYLOAD;
        }
        if (b >= 96 && b <= 111 || b >= -96 && b <= -81 || b >= -32 && b <= -17) {
            return SpeHeaderTypes.INT_PAYLOAD;
        }
        if (b >= 112 && b <= 127 || b >= -80 && b <= -65 || b >= -16 && b <= -1) {
            return SpeHeaderTypes.LONG_PAYLOAD;
        }
        if (b >= 32 && b <= 63) {
            return SpeHeaderTypes.EXTENDED_HEADER;
        }
        throw new AssertionError((Object)("Unknown header type " + b));
    }

    private static enum SpeHeaderTypes {
        NONE(-1),
        NO_PAYLOAD(0),
        BYTE_PAYLOAD(1),
        SHORT_PAYLOAD(2),
        INT_PAYLOAD(4),
        LONG_PAYLOAD(8),
        EXTENDED_HEADER(-1);

        private int size;

        private SpeHeaderTypes(int size) {
            this.size = size;
        }

        public int getPayloadSize() {
            return this.size;
        }
    }
}

