/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.common.xml.spe;

import com.arm.streamline.common.utility.io.XMLGenerator;
import com.arm.streamline.common.utility.io.XMLParser;
import com.arm.streamline.common.xml.spe.AbstractSpeEventProperties;
import com.arm.streamline.common.xml.spe.SpeCounterProperties;
import com.arm.streamline.common.xml.spe.SpeDataSourceProperties;
import com.arm.streamline.common.xml.spe.SpeFilterConfiguration;
import com.arm.streamline.common.xml.spe.SpeFilterEventProperties;
import com.arm.streamline.common.xml.spe.SpeOperationTypeClass;
import com.arm.streamline.common.xml.spe.SpePacketEventProperties;
import com.arm.streamline.common.xml.spe.SpeParsingException;
import com.arm.streamline.common.xml.spe.SpeTargetDescription;
import com.arm.util.Objects;
import com.arm.utils.NullChecking;
import com.arm.utils.function.Throwing;
import com.arm.utils.text.BasicNumberUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class SpeXMLParser {
    private static final int INVALID_BIT = -1;
    public static final byte @NonNull [] VALID_OP_SUBCLASS_MASK_ANY = new byte[2];
    public static final byte @NonNull [] VALID_OP_SUBCLASS_MASK_BRANCH_CONDITIONAL = new byte[]{1, 1};
    public static final byte @NonNull [] VALID_OP_SUBCLASS_MASK_BRANCH_INDIRECT = new byte[]{2, -2};
    public static final byte @NonNull [] VALID_OP_SUBCLASS_MASK_LS_EXT = new byte[]{2, -30};
    public static final byte @NonNull [] VALID_OP_SUBCLASS_MASK_LS_FP_SIMD = new byte[]{4, -2};
    public static final byte @NonNull [] VALID_OP_SUBCLASS_MASK_LS_GP;
    public static final byte @NonNull [] VALID_OP_SUBCLASS_MASK_LS_XFORMED_SYSREG;
    public static final byte @NonNull [] VALID_OP_SUBCLASS_MASK_LS_UNSPECIFIED_REG;
    public static final byte @NonNull [] VALID_OP_SUBCLASS_MASK_LS_SVE;
    public static final byte @NonNull [] VALID_OP_SUBCLASS_MASK_LS_LOAD;
    public static final byte @NonNull [] VALID_OP_SUBCLASS_MASK_LS_STORE;
    public static final byte @NonNull [] VALID_OP_SUBCLASS_MASK_OTHER_CONDITIONAL;
    public static final byte @NonNull [] VALID_OP_SUBCLASS_MASK_OTHER_SVE;

    static {
        byte[] byArray = new byte[2];
        byArray[1] = -2;
        VALID_OP_SUBCLASS_MASK_LS_GP = byArray;
        VALID_OP_SUBCLASS_MASK_LS_XFORMED_SYSREG = new byte[]{48, -2};
        VALID_OP_SUBCLASS_MASK_LS_UNSPECIFIED_REG = new byte[]{16, -2};
        VALID_OP_SUBCLASS_MASK_LS_SVE = new byte[]{8, 10};
        byte[] byArray2 = new byte[2];
        byArray2[1] = 1;
        VALID_OP_SUBCLASS_MASK_LS_LOAD = byArray2;
        VALID_OP_SUBCLASS_MASK_LS_STORE = new byte[]{1, 1};
        VALID_OP_SUBCLASS_MASK_OTHER_CONDITIONAL = new byte[]{1, -1};
        VALID_OP_SUBCLASS_MASK_OTHER_SVE = new byte[]{8, -119};
    }

    public static @NonNull SpeFilterConfiguration parseSpeConfigXml(@NonNull XMLParser in, @NonNull Map<@NonNull String, @NonNull SpeTargetDescription> map, @NonNull Consumer<@NonNull Throwable> errorHandler) throws SpeParsingException {
        @NonNull String id = in.getAttribute("id", "");
        SpeTargetDescription speTargetDescription = map.get(id);
        if (speTargetDescription == null) {
            throw new SpeParsingException("SPE event could not be added as no confiuration found for : " + id);
        }
        @NonNull SpeFilterConfiguration speFilterConfiguration = new SpeFilterConfiguration(speTargetDescription);
        String event_str = in.getAttribute("event-filter", "");
        long event = 0L;
        if (event_str != null && !event_str.isEmpty()) {
            try {
                event = BasicNumberUtils.decodeUnsignedLong((String)event_str);
            }
            catch (NumberFormatException exception) {
                errorHandler.accept(new Exception("Exception while parsing event in spe " + id, exception));
                event = 0L;
            }
        }
        @NonNull Set<@NonNull SpeFilterEventProperties> allSpeEvents = speTargetDescription.getAllSpeFilterEvents();
        long lcl_event = 0L;
        int i = 0;
        while (i < 64) {
            Stream<SpeFilterEventProperties> eventMatched;
            Optional<SpeFilterEventProperties> findFirst;
            int position = i;
            lcl_event = event >>> i;
            if (lcl_event == 0L) break;
            if ((lcl_event & 1L) == 1L && (findFirst = (eventMatched = allSpeEvents.stream().filter(e -> e.getBitPosition() == position)).findFirst()).isPresent()) {
                speFilterConfiguration.addEvent(findFirst.get());
            }
            ++i;
        }
        @NonNull HashSet<@NonNull SpeFilterConfiguration.OpType> optypes = new HashSet<SpeFilterConfiguration.OpType>();
        if (in.isAttributeSet("load-filter", false)) {
            optypes.add(SpeFilterConfiguration.OpType.Load);
        }
        if (in.isAttributeSet("store-filter", false)) {
            optypes.add(SpeFilterConfiguration.OpType.Store);
        }
        if (in.isAttributeSet("branch-filter", false)) {
            optypes.add(SpeFilterConfiguration.OpType.Branch);
        }
        if (in.hasAttribute("min-latency")) {
            int min_latency = 0;
            String attribute = in.getAttribute("min-latency", "");
            try {
                min_latency = Integer.parseInt(attribute);
            }
            catch (NumberFormatException exception) {
                errorHandler.accept(new Exception("Minimum latency is not integer in the xml for spe " + id, exception));
            }
            try {
                speFilterConfiguration.setMinLatency(min_latency);
            }
            catch (IllegalArgumentException exception) {
                errorHandler.accept(exception);
            }
        }
        speFilterConfiguration.setOpType(optypes);
        return speFilterConfiguration;
    }

    public static @NonNull SpeTargetDescription parseSpeEventsXML(@NonNull XMLParser in, @NonNull Map<@NonNull String, @NonNull SpeTargetDescription> speTargetDescritionMap, Predicate<@NonNull String> validSpesPredicate) throws SpeParsingException, IOException {
        @NonNull String name = in.getAttribute("name", "").trim();
        if (name.isEmpty()) {
            throw new SpeParsingException("Spe name is a mandatory field, is not present or empty in the xml");
        }
        @NonNull String id = in.getAttribute("id", "").trim();
        if (id.isEmpty()) {
            throw new SpeParsingException("Spe id is a mandatory field, is not present in the xml");
        }
        if (speTargetDescritionMap.containsKey(id)) {
            throw new SpeParsingException("Spe id is already added ," + id);
        }
        @NonNull String parentId = in.getAttribute("extends", "").trim();
        if (parentId.equals(id)) {
            throw new SpeParsingException("Exception while parsing : due to cyclic reference");
        }
        @Nullable SpeTargetDescription speTargetDescription = speTargetDescritionMap.get(parentId);
        AtomicBoolean isCyclic = new AtomicBoolean(false);
        if (speTargetDescription == null || !SpeXMLParser.checkCyclicRefOfId(speTargetDescription, id, speTargetDescritionMap, isCyclic).get()) {
            String tag;
            @NonNull HashSet<@NonNull SpeFilterEventProperties> speFltEvents = new HashSet<SpeFilterEventProperties>();
            @NonNull HashSet<@NonNull SpePacketEventProperties> spePktEvents = new HashSet<SpePacketEventProperties>();
            @NonNull HashSet<@NonNull SpeCounterProperties> speCounterProperties = new HashSet<SpeCounterProperties>();
            @NonNull HashSet<@NonNull SpeDataSourceProperties> speDataSourceProperties = new HashSet<SpeDataSourceProperties>();
            String marker = in.getMarker();
            while ((tag = in.nextTag(marker)) != null) {
                if (tag.equals("event")) {
                    SpeXMLParser.parseEventElement(in, name, speFltEvents, spePktEvents);
                    continue;
                }
                if (tag.equals("counter")) {
                    SpeXMLParser.parseCounterElement(in, name, speCounterProperties);
                    continue;
                }
                if (tag.equals("data-source")) {
                    SpeXMLParser.parseDataSourceElement(in, name, speDataSourceProperties);
                    continue;
                }
                in.skip();
            }
            boolean tobeAdded = validSpesPredicate == null || validSpesPredicate.test(id);
            SpeTargetDescription speTarget = new SpeTargetDescription(id, name, parentId.isEmpty() ? null : parentId, spePktEvents, speFltEvents, speCounterProperties, speDataSourceProperties, speTargetDescritionMap, tobeAdded);
            return speTarget;
        }
        throw new SpeParsingException("Exception while parsing : due to cyclic reference");
    }

    public static void saveConfiguration(@NonNull XMLGenerator xml, @NonNull SpeFilterConfiguration spe) throws IOException {
        xml.startEmptyTag("spe");
        xml.addAttribute("id", spe.getId());
        if (!spe.getEvents().isEmpty()) {
            long eventFilter = 0L;
            for (SpeFilterEventProperties event : spe.getEvents()) {
                int bitPosition = event.getBitPosition();
                assert (bitPosition >= 0 && bitPosition <= 63);
                eventFilter |= 1L << bitPosition;
            }
            if (eventFilter != 0L) {
                xml.addAttribute("event-filter", Long.toUnsignedString(eventFilter));
            }
        }
        Throwing.forEach(spe.getOpType().stream(), oprType -> SpeXMLParser.addOpType(xml, oprType));
        xml.addAttribute("min-latency", spe.getMinLatency());
    }

    public static void validate(@NonNull Map<@NonNull String, @NonNull SpeTargetDescription> speTargetDescritionMap, @NonNull Consumer<@NonNull Throwable> errorHandler) throws SpeParsingException {
        SpeXMLParser.removeSpeIfExtendsNotPresent(speTargetDescritionMap);
        SpeXMLParser.removeSpeIfDuplicateSpeEventsAdded(speTargetDescritionMap, errorHandler);
    }

    private static void addOpType(@NonNull XMLGenerator xml, SpeFilterConfiguration.OpType opType) throws IOException {
        switch (opType) {
            case Load: {
                xml.addAttributeBool("load-filter", true);
                break;
            }
            case Store: {
                xml.addAttributeBool("store-filter", true);
                break;
            }
            case Branch: {
                xml.addAttributeBool("branch-filter", true);
                break;
            }
        }
    }

    private static AtomicBoolean checkCyclicRefOfId(@NonNull SpeTargetDescription speTargetDescription, @NonNull String id, @NonNull Map<String, SpeTargetDescription> speTargetDescritionMap, @NonNull AtomicBoolean isCyclic) {
        @Nullable String parentId = speTargetDescription.getParentId();
        if (!id.equals(parentId) && !speTargetDescription.getId().equals(id)) {
            @Nullable SpeTargetDescription speTargetDescription2 = speTargetDescritionMap.get(parentId);
            if (speTargetDescription2 == null) {
                isCyclic.set(false);
            } else {
                SpeXMLParser.checkCyclicRefOfId(speTargetDescription2, id, speTargetDescritionMap, isCyclic);
            }
        } else {
            isCyclic.set(true);
        }
        return isCyclic;
    }

    private static void checkIfExists(@NonNull Set<@NonNull String> keySet, @Nullable String parentId, @NonNull Map<@NonNull String, @NonNull SpeTargetDescription> speTargetDescritionMap) throws SpeParsingException {
        if (parentId != null && !parentId.isEmpty() && !keySet.contains(parentId)) {
            @NonNull Optional<@NonNull SpeTargetDescription> findFirst = speTargetDescritionMap.values().stream().filter(spe -> spe.getParentId() != null && parentId.equals(spe.getParentId())).findFirst();
            @NonNull Stream<@NonNull String> key = speTargetDescritionMap.entrySet().stream().filter(entry -> Objects.equals(entry.getValue(), findFirst.get())).map(Map.Entry::getKey);
            speTargetDescritionMap.remove(key.findFirst().get());
            throw new SpeParsingException("Error while validation , extended spe not found for " + parentId);
        }
    }

    private static @NonNull SpeCounterProperties.Type decodeCounterType(@NonNull String name, @NonNull String counterName, @NonNull String type) throws SpeParsingException {
        switch (type.toLowerCase()) {
            case "absolute": {
                return SpeCounterProperties.Type.ABSOLUTE;
            }
            case "latency": {
                return SpeCounterProperties.Type.LATENCY;
            }
        }
        throw new SpeParsingException(String.format("Invalid 'type' for SPE counter '%s.%s', was '%s'", name, counterName, type));
    }

    private static @NonNull Set<@NonNull AbstractSpeEventProperties.ValidOpType> decodeValidOpTypes(@NonNull String name, @NonNull String eventname, @NonNull XMLParser in) throws IOException, SpeParsingException {
        String tag;
        @NonNull HashSet<@NonNull T> result = new HashSet();
        String marker = in.getMarker();
        while ((tag = in.nextTag(marker)) != null) {
            if ("valid-op-type".equals(tag)) {
                String clazz = in.getAttribute("class", "").trim();
                String subclazz = in.getAttribute("sub-class", "").trim();
                String subclazzMask = in.getAttribute("sub-class-mask", "").trim();
                @NonNull SpeOperationTypeClass speOperationTypeClass = SpeXMLParser.parseOperationTypeClass(name, eventname, clazz);
                byte @NonNull [] subclassTestAndMask = SpeXMLParser.parseOperationTypeSubclass(name, eventname, speOperationTypeClass, subclazz, subclazzMask);
                result.add(new AbstractSpeEventProperties.ValidOpType(speOperationTypeClass, subclassTestAndMask[0], subclassTestAndMask[1]));
                continue;
            }
            in.skip();
        }
        return result.isEmpty() ? Collections.emptySet() : result;
    }

    private static int extractBitAttribute(@NonNull String name, @NonNull String eventName, @NonNull XMLParser in, @NonNull String attributeName, @NonNull String errorMessage) throws SpeParsingException {
        String attributeValue = in.getAttribute(attributeName, "").trim();
        if (attributeValue.isEmpty()) {
            return -1;
        }
        try {
            int result = Integer.parseInt(attributeValue);
            if (result < 0 || result > 63) {
                throw new SpeParsingException(String.format("%s'%s.%s'", errorMessage, name, eventName));
            }
            return result;
        }
        catch (NumberFormatException exception) {
            throw new SpeParsingException(String.format("%s%s for SPE event '%s.%s'", "Event bit field must be an integer for attribute ", attributeName, name, eventName));
        }
    }

    private static @NonNull String extractMandatoryAttribute(@NonNull String name, @NonNull String eventName, @NonNull XMLParser in, @NonNull String attributeName) throws SpeParsingException {
        String attributeValue = in.getAttribute(attributeName, "").trim();
        if (attributeValue.isEmpty()) {
            throw new SpeParsingException(String.format("attribute %s missing for SPE event %s.%s", attributeName, name, eventName));
        }
        return attributeValue;
    }

    private static void parseDataSourceElement(@NonNull XMLParser in, @NonNull String name, @NonNull Set<@NonNull SpeDataSourceProperties> speDataSourceProperties) throws SpeParsingException {
        if (!in.hasAttribute("index")) {
            throw new SpeParsingException(String.format("Data Source had missing index attribute for SPE '%s'", name));
        }
        int index = in.getIntegerAttribute("index", -1);
        @NonNull String dsName = in.getAttribute("name", "").trim();
        @NonNull String description = in.getAttribute("description", "").trim();
        if (index < 0 || index > 65535) {
            throw new SpeParsingException(String.format("Data Source 'index' invalid for SPE '%s', was '%d'", name, index));
        }
        if (dsName.isEmpty()) {
            throw new SpeParsingException(String.format("Data Source 'name' missing for SPE '%s' @ '%d'", name, index));
        }
        if (!speDataSourceProperties.add(new SpeDataSourceProperties(index, dsName, description))) {
            throw new SpeParsingException(String.format("SPE data-source '%s.%s' had duplicate index '%d'", name, dsName, index));
        }
    }

    private static void parseCounterElement(@NonNull XMLParser in, @NonNull String name, @NonNull Set<@NonNull SpeCounterProperties> speCounterProperties) throws SpeParsingException {
        if (!in.hasAttribute("index")) {
            throw new SpeParsingException(String.format("Counter had missing index attribute for SPE '%s'", name));
        }
        int index = in.getIntegerAttribute("index", -1);
        @NonNull String counterName = in.getAttribute("name", "").trim();
        @NonNull String description = in.getAttribute("description", "").trim();
        @NonNull String unit = in.getAttribute("unit", "").trim();
        if (index < 0 || index > 31) {
            throw new SpeParsingException(String.format("Counter 'index' invalid for SPE '%s', was '%d'", name, index));
        }
        if (counterName.isEmpty()) {
            throw new SpeParsingException(String.format("Counter 'name' missing for SPE '%s' @ '%d'", name, index));
        }
        @NonNull SpeCounterProperties.Type type = SpeXMLParser.decodeCounterType(name, counterName, in.getAttribute("type", "").trim());
        if (!speCounterProperties.add(new SpeCounterProperties(index, type, counterName, description, unit))) {
            throw new SpeParsingException(String.format("SPE counter '%s.%s' had duplicate index '%d'", name, counterName, index));
        }
    }

    private static void parseEventElement(@NonNull XMLParser in, @NonNull String name, @NonNull Set<@NonNull SpeFilterEventProperties> speFltEvents, @NonNull Set<@NonNull SpePacketEventProperties> spePktEvents) throws SpeParsingException, IOException {
        SpeFilterEventProperties speFilterEventProperties;
        boolean add;
        HashSet<AbstractSpeEventProperties.ValidOpType> validOpTypes;
        int filterBit;
        String description;
        String eventname;
        block35: {
            eventname = in.getAttribute("name", "").trim();
            if (eventname.isEmpty()) {
                throw new SpeParsingException("Event name is a mandatory field, is not present or empty in the xml " + name);
            }
            description = in.getAttribute("description", "").trim();
            int bit = SpeXMLParser.extractBitAttribute(name, eventname, in, "bit", "Bit is invalid for event ");
            filterBit = SpeXMLParser.extractBitAttribute(name, eventname, in, "filter-bit", "Filter Bit (filter-bit) is invalid for event ");
            if (bit == -1 && filterBit == -1) {
                throw new SpeParsingException("Event should have at least bit or filter-bit present in the xml for spe " + name);
            }
            validOpTypes = new HashSet<AbstractSpeEventProperties.ValidOpType>();
            if (bit == -1) break block35;
            int conditionBit = SpeXMLParser.extractBitAttribute(name, eventname, in, "condition-bit", "Condition Bit (condition-bit) is invalid for event ");
            @NonNull String clearLbl = SpeXMLParser.extractMandatoryAttribute(name, eventname, in, "clear-label");
            @NonNull String setLbl = SpeXMLParser.extractMandatoryAttribute(name, eventname, in, "set-label");
            @NonNull String ratioLbl = SpeXMLParser.extractMandatoryAttribute(name, eventname, in, "ratio-label");
            boolean conditionalAccessIsOnBitClear = in.isAttributeSet("condition-inverted", false);
            @NonNull SpePacketEventProperties.ShowByDefault showByDefault = switch (in.getAttribute("show-by-default", "").trim()) {
                case "", "ratio" -> SpePacketEventProperties.ShowByDefault.RATIO;
                case "set" -> SpePacketEventProperties.ShowByDefault.SET;
                case "clear" -> SpePacketEventProperties.ShowByDefault.CLEAR;
                default -> throw new SpeParsingException(String.format("Invalid show-by-default for SPE event '%s.%s'", name, eventname));
            };
            @NonNull SpePacketEventProperties.SetMode setMode = switch (in.getAttribute("set-mode", "").trim()) {
                case "", "negative" -> SpePacketEventProperties.SetMode.NEGATIVE;
                case "positive" -> SpePacketEventProperties.SetMode.POSITIVE;
                case "neutral" -> SpePacketEventProperties.SetMode.NEUTRAL;
                default -> throw new SpeParsingException(String.format("Invalid set-mode for SPE event '%s.%s'", name, eventname));
            };
            validOpTypes.addAll(SpeXMLParser.decodeValidOpTypes(name, eventname, in));
            if (bit == conditionBit) {
                throw new SpeParsingException(String.format("%s'%s.%s'", "Condition Bit (condition-bit) is invalid for event ", name, eventname));
            }
            SpePacketEventProperties spePktEvent = new SpePacketEventProperties(bit, eventname, description, validOpTypes, NullChecking.nullIfEqual((int)conditionBit, (int)-1), ratioLbl, setLbl, clearLbl, showByDefault, conditionalAccessIsOnBitClear, setMode);
            boolean add2 = spePktEvents.add(spePktEvent);
            if (!add2) {
                throw new SpeParsingException("Error while validation, duplicates found in events " + name + " -- " + eventname);
            }
        }
        if (filterBit != -1 && !(add = speFltEvents.add(speFilterEventProperties = new SpeFilterEventProperties(eventname, filterBit, description, validOpTypes)))) {
            throw new SpeParsingException("Error while validation, duplicates found in events " + name + " -- " + eventname);
        }
    }

    private static @NonNull SpeOperationTypeClass parseOperationTypeClass(@NonNull String name, @NonNull String eventName, String clazz) throws SpeParsingException {
        switch (clazz) {
            case "branch": {
                return SpeOperationTypeClass.BRANCH;
            }
            case "load-store": {
                return SpeOperationTypeClass.LOAD_STORE;
            }
            case "other": {
                return SpeOperationTypeClass.OTHER;
            }
        }
        throw new SpeParsingException(String.format("Invalid 'valid-op-type' for SPE event '%s.%s' was '%s'", name, eventName, clazz));
    }

    private static byte @NonNull [] parseOperationTypeSubclass(@NonNull String name, @NonNull String eventName, @NonNull SpeOperationTypeClass speOperationTypeClass, @NonNull String subclazz, @NonNull String subclazzMask) throws SpeParsingException {
        if (subclazz.isEmpty()) {
            if (!subclazzMask.isEmpty()) {
                throw new SpeParsingException(String.format("Invalid 'valid-op-type' for SPE event '%s.%s' was '%s'", name, eventName, "sub-class-mask present without sub-class"));
            }
            return VALID_OP_SUBCLASS_MASK_ANY;
        }
        switch (speOperationTypeClass) {
            case BRANCH: {
                switch (subclazz) {
                    case "conditional": {
                        if (!subclazzMask.isEmpty()) {
                            throw new SpeParsingException(String.format("Invalid 'valid-op-type' for SPE event '%s.%s' was '%s'", name, eventName, "branch.conditional has mask"));
                        }
                        return VALID_OP_SUBCLASS_MASK_BRANCH_CONDITIONAL;
                    }
                    case "indirect": {
                        if (!subclazzMask.isEmpty()) {
                            throw new SpeParsingException(String.format("Invalid 'valid-op-type' for SPE event '%s.%s' was '%s'", name, eventName, "branch.indirect has mask"));
                        }
                        return VALID_OP_SUBCLASS_MASK_BRANCH_INDIRECT;
                    }
                }
                return SpeXMLParser.parseOperationTypeSubclass(name, eventName, subclazz, subclazzMask);
            }
            case LOAD_STORE: {
                switch (subclazz) {
                    case "load": {
                        if (!subclazzMask.isEmpty()) {
                            throw new SpeParsingException(String.format("Invalid 'valid-op-type' for SPE event '%s.%s' was '%s'", name, eventName, "load-store.load has mask"));
                        }
                        return VALID_OP_SUBCLASS_MASK_LS_LOAD;
                    }
                    case "store": {
                        if (!subclazzMask.isEmpty()) {
                            throw new SpeParsingException(String.format("Invalid 'valid-op-type' for SPE event '%s.%s' was '%s'", name, eventName, "load-store.store has mask"));
                        }
                        return VALID_OP_SUBCLASS_MASK_LS_STORE;
                    }
                    case "general-purpose": {
                        if (!subclazzMask.isEmpty()) {
                            throw new SpeParsingException(String.format("Invalid 'valid-op-type' for SPE event '%s.%s' was '%s'", name, eventName, "load-store.general-purpose has mask"));
                        }
                        return VALID_OP_SUBCLASS_MASK_LS_GP;
                    }
                    case "float-or-simd": {
                        if (!subclazzMask.isEmpty()) {
                            throw new SpeParsingException(String.format("Invalid 'valid-op-type' for SPE event '%s.%s' was '%s'", name, eventName, "load-store.float-or-simd has mask"));
                        }
                        return VALID_OP_SUBCLASS_MASK_LS_FP_SIMD;
                    }
                    case "extended": {
                        if (!subclazzMask.isEmpty()) {
                            throw new SpeParsingException(String.format("Invalid 'valid-op-type' for SPE event '%s.%s' was '%s'", name, eventName, "load-store.extended has mask"));
                        }
                        return VALID_OP_SUBCLASS_MASK_LS_EXT;
                    }
                    case "xformed-sysreg": {
                        if (!subclazzMask.isEmpty()) {
                            throw new SpeParsingException(String.format("Invalid 'valid-op-type' for SPE event '%s.%s' was '%s'", name, eventName, "load-store.xformed-sysreg has mask"));
                        }
                        return VALID_OP_SUBCLASS_MASK_LS_XFORMED_SYSREG;
                    }
                    case "sve": {
                        if (!subclazzMask.isEmpty()) {
                            throw new SpeParsingException(String.format("Invalid 'valid-op-type' for SPE event '%s.%s' was '%s'", name, eventName, "load-store.sve has mask"));
                        }
                        return VALID_OP_SUBCLASS_MASK_LS_SVE;
                    }
                    case "unspecified": {
                        if (!subclazzMask.isEmpty()) {
                            throw new SpeParsingException(String.format("Invalid 'valid-op-type' for SPE event '%s.%s' was '%s'", name, eventName, "load-store.unspecified has mask"));
                        }
                        return VALID_OP_SUBCLASS_MASK_LS_UNSPECIFIED_REG;
                    }
                }
                return SpeXMLParser.parseOperationTypeSubclass(name, eventName, subclazz, subclazzMask);
            }
            case OTHER: {
                switch (subclazz) {
                    case "conditional": {
                        if (!subclazzMask.isEmpty()) {
                            throw new SpeParsingException(String.format("Invalid 'valid-op-type' for SPE event '%s.%s' was '%s'", name, eventName, "other.conditional has mask"));
                        }
                        return VALID_OP_SUBCLASS_MASK_OTHER_CONDITIONAL;
                    }
                    case "sve": {
                        if (!subclazzMask.isEmpty()) {
                            throw new SpeParsingException(String.format("Invalid 'valid-op-type' for SPE event '%s.%s' was '%s'", name, eventName, "other.sve has mask"));
                        }
                        return VALID_OP_SUBCLASS_MASK_OTHER_SVE;
                    }
                }
                return SpeXMLParser.parseOperationTypeSubclass(name, eventName, subclazz, subclazzMask);
            }
        }
        throw new AssertionError((Object)speOperationTypeClass);
    }

    private static byte @NonNull [] parseOperationTypeSubclass(@NonNull String name, @NonNull String eventName, @NonNull String subclazz, @NonNull String subclazzMask) throws SpeParsingException {
        try {
            byte test = (byte)Integer.decode(subclazz).intValue();
            byte mask = (byte)(subclazzMask.isEmpty() ? 255 : Integer.decode(subclazzMask));
            if (test == 0 && mask == 0) {
                return new byte[]{test, mask};
            }
            if (mask == 0 || test != 0 && (test & mask) != test) {
                throw new SpeParsingException(String.format("Invalid 'valid-op-type' for SPE event '%s.%s' was '%s'", name, eventName, String.format("test/mask combination 0x%02x & 0x%02x will never match", test, mask)));
            }
            return new byte[]{test, mask};
        }
        catch (NumberFormatException e) {
            throw new SpeParsingException(String.format("Invalid 'valid-op-type' for SPE event '%s.%s' was '%s'", name, eventName, String.format("test/mask attributes: '%s' / '%s'", subclazz, subclazzMask)));
        }
    }

    private static void removeSpeIfDuplicateSpeEventsAdded(Map<@NonNull String, @NonNull SpeTargetDescription> speTargetDescritionMap, @NonNull Consumer<@NonNull Throwable> errorHandler) {
        ArrayList filterEventstoBeRemoved = new ArrayList();
        speTargetDescritionMap.entrySet().stream().forEach(speMap -> {
            @NonNull SpeTargetDescription value = (SpeTargetDescription)speMap.getValue();
            @Nullable String parentId = value.getParentId();
            @NonNull Set<@NonNull SpeFilterEventProperties> speEvents = value.getSpeFilterEventsForThisOnly();
            @Nullable SpeTargetDescription parentTarget = (SpeTargetDescription)speTargetDescritionMap.get(parentId);
            if (parentTarget != null) {
                speEvents.stream().forEach(speEvent -> {
                    @NonNull Set<@NonNull SpeFilterEventProperties> allSpeEventsofParent = parentTarget.getAllSpeFilterEvents();
                    int frequency = Collections.frequency(allSpeEventsofParent, speEvent);
                    if (frequency == 1) {
                        filterEventstoBeRemoved.add((String)speMap.getKey());
                    }
                });
            }
        });
        if (filterEventstoBeRemoved.size() > 0) {
            filterEventstoBeRemoved.stream().forEach(key -> {
                Object v = speTargetDescritionMap.remove(key);
            });
            try {
                SpeXMLParser.removeSpeIfExtendsNotPresent(speTargetDescritionMap);
            }
            catch (SpeParsingException exception) {
                errorHandler.accept(exception);
            }
            errorHandler.accept(new SpeParsingException("Error while validation, duplicates found in events "));
        }
        ArrayList packetEventsToBeremoved = new ArrayList();
        speTargetDescritionMap.entrySet().stream().forEach(speMap -> {
            @NonNull SpeTargetDescription value = (SpeTargetDescription)speMap.getValue();
            @Nullable String parentId = value.getParentId();
            @NonNull Set<@NonNull SpePacketEventProperties> speEvents = ((SpeTargetDescription)speMap.getValue()).getSpePacketEventsForThisOnly();
            @Nullable SpeTargetDescription parentTarget = (SpeTargetDescription)speTargetDescritionMap.get(parentId);
            if (parentTarget != null) {
                speEvents.stream().forEach(speEvent -> {
                    @NonNull Set<@NonNull SpePacketEventProperties> allSpePktEventsofParent = parentTarget.getAllSpePacketEvents();
                    int frequency = Collections.frequency(allSpePktEventsofParent, speEvent);
                    if (frequency == 1) {
                        packetEventsToBeremoved.add((String)speMap.getKey());
                    }
                });
            }
        });
        if (packetEventsToBeremoved.size() > 0) {
            packetEventsToBeremoved.stream().forEach(key -> {
                Object v = speTargetDescritionMap.remove(key);
            });
            try {
                SpeXMLParser.removeSpeIfExtendsNotPresent(speTargetDescritionMap);
            }
            catch (SpeParsingException exception) {
                errorHandler.accept(exception);
            }
            errorHandler.accept(new SpeParsingException("Error while validation, duplicates found in events "));
        }
    }

    private static void removeSpeIfExtendsNotPresent(Map<@NonNull String, @NonNull SpeTargetDescription> speTargetDescritionMap) throws SpeParsingException {
        @NonNull Set<@NonNull String> keySet = speTargetDescritionMap.keySet();
        @NonNull Collection<@NonNull SpeTargetDescription> values = speTargetDescritionMap.values();
        @NonNull Set<@Nullable T> parentIds = values.stream().map(spe -> spe.getParentId()).collect(Collectors.toSet());
        Throwing.forEach(parentIds, parentId -> SpeXMLParser.checkIfExists(keySet, parentId, speTargetDescritionMap));
    }
}

