/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.common.xml.spe;

import com.arm.streamline.common.xml.counters.CounterModelMessages;
import com.arm.streamline.common.xml.counters.IAvailableEvent;
import com.arm.streamline.common.xml.spe.SpeCounterProperties;
import com.arm.streamline.common.xml.spe.SpeDataSourceProperties;
import com.arm.streamline.common.xml.spe.SpeFilterEventProperties;
import com.arm.streamline.common.xml.spe.SpePacketEventProperties;
import com.arm.utils.NullChecking;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class SpeTargetDescription
implements IAvailableEvent {
    private final @NonNull Set<@NonNull SpeCounterProperties> counters = new HashSet<SpeCounterProperties>();
    private final @NonNull Set<@NonNull SpeDataSourceProperties> dataSources = new HashSet<SpeDataSourceProperties>();
    private final @NonNull Set<@NonNull SpeFilterEventProperties> filterEvents = new HashSet<SpeFilterEventProperties>();
    private final boolean isAvailableInTarget;
    private final @NonNull Set<@NonNull SpePacketEventProperties> packetEvents = new HashSet<SpePacketEventProperties>();
    private final @Nullable String parentId;
    private final @NonNull String speId;
    private final @NonNull String speName;
    private final @NonNull Map<@NonNull String, @NonNull SpeTargetDescription> speTargetDescritionMap;

    public SpeTargetDescription(@NonNull String speId, @NonNull String speName, @Nullable String parentId, @NonNull Set<@NonNull SpePacketEventProperties> packetEvents, @NonNull Set<@NonNull SpeFilterEventProperties> filterEvents, @NonNull Set<@NonNull SpeCounterProperties> counters, @NonNull Set<@NonNull SpeDataSourceProperties> dataSources, @NonNull Map<@NonNull String, @NonNull SpeTargetDescription> speTargetDescritionMap, boolean isAdded) {
        this.speId = speId;
        this.speName = speName;
        this.parentId = parentId;
        this.speTargetDescritionMap = speTargetDescritionMap;
        this.filterEvents.addAll(filterEvents);
        this.packetEvents.addAll(packetEvents);
        this.counters.addAll(counters);
        this.dataSources.addAll(dataSources);
        this.isAvailableInTarget = isAdded;
    }

    public @NonNull Set<@NonNull SpeCounterProperties> getAllSpeCounters() {
        @NonNull HashSet<@NonNull SpeCounterProperties> allCounters = new HashSet<SpeCounterProperties>();
        if (this.parentId != null) {
            allCounters.addAll(((SpeTargetDescription)NullChecking.neverNull((Object)this.speTargetDescritionMap.get(this.parentId))).getAllSpeCounters());
        }
        allCounters.addAll(this.counters);
        return Collections.unmodifiableSet(allCounters);
    }

    public @NonNull Set<@NonNull SpeDataSourceProperties> getAllSpeDataSources() {
        @NonNull HashSet<@NonNull SpeDataSourceProperties> allDataSources = new HashSet<SpeDataSourceProperties>();
        if (this.parentId != null) {
            allDataSources.addAll(((SpeTargetDescription)NullChecking.neverNull((Object)this.speTargetDescritionMap.get(this.parentId))).getAllSpeDataSources());
        }
        allDataSources.addAll(this.dataSources);
        return Collections.unmodifiableSet(allDataSources);
    }

    public @NonNull Set<@NonNull SpeFilterEventProperties> getAllSpeFilterEvents() {
        @NonNull HashSet<@NonNull SpeFilterEventProperties> allEvents = new HashSet<SpeFilterEventProperties>();
        if (this.parentId != null) {
            allEvents.addAll(((SpeTargetDescription)NullChecking.neverNull((Object)this.speTargetDescritionMap.get(this.parentId))).getAllSpeFilterEvents());
        }
        allEvents.addAll(this.filterEvents);
        return Collections.unmodifiableSet(allEvents);
    }

    public @NonNull Set<@NonNull SpePacketEventProperties> getAllSpePacketEvents() {
        @NonNull HashSet<@NonNull SpePacketEventProperties> allEvents = new HashSet<SpePacketEventProperties>();
        if (this.parentId != null) {
            allEvents.addAll(((SpeTargetDescription)NullChecking.neverNull((Object)this.speTargetDescritionMap.get(this.parentId))).getAllSpePacketEvents());
        }
        allEvents.addAll(this.packetEvents);
        return Collections.unmodifiableSet(allEvents);
    }

    @Override
    public @NonNull String getDescription() {
        return CounterModelMessages.SPE_DESCRIPTION;
    }

    public @NonNull String getId() {
        return this.speId;
    }

    public @NonNull String getName() {
        return this.speName;
    }

    public @Nullable String getParentId() {
        return this.parentId;
    }

    public @NonNull Set<@NonNull SpeCounterProperties> getSpeCountersForThisOnly() {
        return Collections.unmodifiableSet(this.counters);
    }

    public @NonNull Set<@NonNull SpeDataSourceProperties> getSpeDataSourcesForThisOnly() {
        return Collections.unmodifiableSet(this.dataSources);
    }

    public @NonNull Set<@NonNull SpeFilterEventProperties> getSpeFilterEventsForThisOnly() {
        return Collections.unmodifiableSet(this.filterEvents);
    }

    public @NonNull Set<@NonNull SpePacketEventProperties> getSpePacketEventsForThisOnly() {
        return Collections.unmodifiableSet(this.packetEvents);
    }

    @Override
    public @NonNull String getTitleNameEvent() {
        return this.speName;
    }

    public boolean isAvailableInTarget() {
        return this.isAvailableInTarget;
    }
}

