/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.common.xml.gatorConfig;

import com.arm.streamline.common.utility.io.XMLParser;
import com.arm.util.ParseXMLException;
import com.arm.utils.NullChecking;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;

public class GatorCurrentConfig {
    private final int pid;
    private final int uid;
    private final boolean isSystemWide;
    private final boolean isWaitingForCommand;
    private final @NonNull Optional<@NonNull String> waitForProcessCommand;
    private final @NonNull Optional<@NonNull String> captureWorkingDir;
    private final @NonNull Set<@NonNull Integer> pidsToCapture;

    public static @NonNull GatorCurrentConfig create(@NonNull InputStream xml) throws ParseXMLException, IOException {
        int uid;
        int pid;
        HashSet<Integer> pidsToCapture;
        Optional<String> captureWorkingDir;
        Optional<String> waitForProcessCommand;
        boolean isWaitingForCommand;
        boolean isSystemWide;
        block23: {
            isSystemWide = false;
            isWaitingForCommand = false;
            waitForProcessCommand = Optional.empty();
            captureWorkingDir = Optional.empty();
            pidsToCapture = new HashSet<Integer>();
            Throwable throwable = null;
            Object var9_8 = null;
            try (XMLParser in = new XMLParser(xml);){
                String tag;
                block24: {
                    tag = in.nextTag();
                    if (tag == null || !tag.equals("current_config")) break block24;
                    pid = Integer.parseInt(in.getAttribute("pid"));
                    uid = Integer.parseInt(in.getAttribute("uid"));
                    String marker = in.getMarker();
                    block13: while ((tag = in.nextTag(marker)) != null) {
                        switch (tag) {
                            case "state": {
                                isSystemWide = in.hasAttribute("is_system_wide") && in.getAttribute("is_system_wide").equals("yes");
                                boolean bl = isWaitingForCommand = in.hasAttribute("is_waiting_on_command") && in.getAttribute("is_waiting_on_command").equals("yes");
                                if (in.hasAttribute("wait_for_process")) {
                                    waitForProcessCommand = Optional.of((String)NullChecking.neverNull((Object)in.getAttribute("wait_for_process")));
                                }
                                if (!in.hasAttribute("capture_working_directory")) continue block13;
                                captureWorkingDir = Optional.of((String)NullChecking.neverNull((Object)in.getAttribute("capture_working_directory")));
                                break;
                            }
                            case "pids_to_capture": {
                                String pidsMarker = in.getMarker();
                                while ((tag = in.nextTag(pidsMarker)) != null) {
                                    if (tag.equals("pid")) {
                                        pidsToCapture.add(Integer.parseInt(in.getAttribute("value")));
                                        continue;
                                    }
                                    throw new ParseXMLException(String.format("Recieved unexpected XML tag (%s) when expecting %s", tag, "pid"));
                                }
                                continue block13;
                            }
                            default: {
                                throw new ParseXMLException(String.format("Recieved unexpected XML tag: %s", tag));
                            }
                        }
                    }
                    break block23;
                }
                throw new ParseXMLException(String.format("Recieved unexpected XML tag (%s) when expecting %s", tag, "current_config"));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        return new GatorCurrentConfig(pid, uid, isSystemWide, isWaitingForCommand, waitForProcessCommand, captureWorkingDir, pidsToCapture);
    }

    private GatorCurrentConfig(int pid, int uid, boolean isSystemWide, boolean isWaitingforCommand, @NonNull Optional<@NonNull String> waitForProcessCommand, @NonNull Optional<@NonNull String> captureWorkingDir, @NonNull Set<@NonNull Integer> pidsToCapture) {
        this.pid = pid;
        this.uid = uid;
        this.isSystemWide = isSystemWide;
        this.isWaitingForCommand = isWaitingforCommand;
        this.waitForProcessCommand = waitForProcessCommand;
        this.captureWorkingDir = captureWorkingDir;
        this.pidsToCapture = pidsToCapture;
    }

    public int getPid() {
        return this.pid;
    }

    public int getUid() {
        return this.uid;
    }

    public boolean isSystemWide() {
        return this.isSystemWide;
    }

    public boolean isWaitingForCommand() {
        return this.isWaitingForCommand;
    }

    public @NonNull Optional<@NonNull String> getWaitForProcessCommand() {
        return this.waitForProcessCommand;
    }

    public @NonNull Optional<@NonNull String> getCaptureWorkingDir() {
        return this.captureWorkingDir;
    }

    public @NonNull Set<@NonNull Integer> getPidsToCapture() {
        return this.pidsToCapture;
    }
}

