/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.common.xml.counters;

import com.arm.streamline.common.utility.io.XMLParser;
import com.arm.utils.text.NumericStringComparator;
import java.io.IOException;

public class Option
implements Comparable<Option> {
    private static final String ATTR_DESCRIPTION = "description";
    private static final String ATTR_EVENT_DELTA = "event_delta";
    private static final String ATTR_NAME = "name";
    private String mDescription;
    private long mEventDelta;
    private String mName;

    public Option(XMLParser in) throws IOException {
        this.mEventDelta = in.getLongAttribute(ATTR_EVENT_DELTA, 0L);
        this.mName = in.getAttribute(ATTR_NAME, "");
        this.mDescription = in.getAttribute(ATTR_DESCRIPTION, "");
        in.skip();
    }

    @Override
    public int compareTo(Option other) {
        return NumericStringComparator.caselessCompareStrings((String)this.mName, (String)other.mName);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Option other = (Option)obj;
        if (this.mDescription == null ? other.mDescription != null : !this.mDescription.equals(other.mDescription)) {
            return false;
        }
        if (this.mEventDelta != other.mEventDelta) {
            return false;
        }
        return !(this.mName == null ? other.mName != null : !this.mName.equals(other.mName));
    }

    public String getDescription() {
        return this.mDescription;
    }

    public long calculateEventCode(long baseEvent) {
        return baseEvent + this.mEventDelta;
    }

    public String getName() {
        return this.mName;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.mDescription == null ? 0 : this.mDescription.hashCode());
        result = 31 * result + (int)(this.mEventDelta & 0xFFFFFFFFFFFFFFFFL);
        result = 31 * result + (int)(this.mEventDelta >> 32);
        result = 31 * result + (this.mName == null ? 0 : this.mName.hashCode());
        return result;
    }

    public String toString() {
        return this.mName;
    }
}

