/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.common.xml.counters;

import com.arm.streamline.common.utility.io.XMLParser;
import com.arm.streamline.common.xml.counters.BadXmlException;
import com.arm.utils.text.NumericStringComparator;
import java.util.ArrayList;
import java.util.function.Predicate;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class CounterSet
extends ArrayList<String>
implements Comparable<CounterSet> {
    private static final @NonNull String CNT_SUFFIX = "_cnt";
    private final @NonNull String mName;
    private final @NonNull String mTitle;

    public CounterSet(@NonNull String name, @NonNull String title) {
        this.mName = name;
        this.mTitle = title;
    }

    public CounterSet(@NonNull XMLParser in, @Nullable Predicate<@NonNull String> validCounterPredicate) throws BadXmlException {
        this(in.getAttribute("name", ""), in.getAttribute("title", ""));
        int count = in.getIntegerAttribute("count", -1);
        int index = 0;
        while (index < count) {
            @NonNull String baseName = in.getAttribute("name", "");
            if (baseName.isEmpty()) {
                throw new BadXmlException("Empty name attribute");
            }
            String counterName = baseName + index;
            if (validCounterPredicate == null || validCounterPredicate.test(counterName)) {
                this.add(counterName);
            }
            ++index;
        }
    }

    @Override
    public int compareTo(CounterSet other) {
        return NumericStringComparator.caselessCompareStrings((String)this.mName, (String)other.mName);
    }

    public @NonNull String getName() {
        return this.mName;
    }

    public @Nullable String getPmuId() {
        return CounterSet.toPmuId(this.mName);
    }

    public static @Nullable String toPmuId(@NonNull String counterSetName) {
        return counterSetName.endsWith(CNT_SUFFIX) ? counterSetName.substring(0, counterSetName.length() - CNT_SUFFIX.length()) : null;
    }

    public @NonNull String getTitle() {
        return this.mTitle;
    }
}

