/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.common.utility.io;

import com.arm.streamline.common.utility.Ternary;
import com.arm.streamline.common.utility.io.CommonFileUtils;
import com.arm.utils.NullChecking;
import com.arm.utils.text.BasicNumberUtils;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.zip.GZIPInputStream;
import javax.xml.stream.Location;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.xml.sax.SAXException;

public class XMLParser
implements Closeable {
    private static final String SEPARATOR = "\u0000";
    private static final byte[] XML_MARKER = new byte[]{60, 63, 120, 109, 108};
    private int mDepth;
    private String mMarker;
    private XMLStreamReader mReader;
    private InputStream mStream;
    private ParallelValidatorThread mThread;

    public static @NonNull XMLParser create(@NonNull File file) throws IOException {
        return XMLParser.create(new FileInputStream(CommonFileUtils.getFile(file)));
    }

    public static @NonNull XMLParser create(InputStream stream) throws IOException {
        byte[] buffer = new byte[XML_MARKER.length];
        FilterInputStream in = new BufferedInputStream(stream);
        ((InputStream)in).mark(XML_MARKER.length);
        int amt = ((InputStream)in).read(buffer, 0, XML_MARKER.length);
        ((InputStream)in).reset();
        if (amt == XML_MARKER.length) {
            int i = 0;
            while (i < XML_MARKER.length) {
                if (XML_MARKER[i] != buffer[i]) {
                    amt = 0;
                    break;
                }
                ++i;
            }
        }
        if (amt == -1) {
            throw new EOFException();
        }
        if (amt != XML_MARKER.length && buffer[0] == 31 && buffer[1] == -117) {
            in = new GZIPInputStream(in);
        }
        return new XMLParser(in);
    }

    public XMLParser(@NonNull InputStream stream) throws IOException {
        this.mStream = stream;
        this.mThread = null;
        XMLInputFactory factory = XMLInputFactory.newInstance();
        factory.setProperty("javax.xml.stream.isCoalescing", Boolean.TRUE);
        factory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
        try {
            this.mReader = (XMLStreamReader)NullChecking.neverNull((Object)factory.createXMLStreamReader(stream));
        }
        catch (XMLStreamException exception) {
            throw new IOException(exception);
        }
    }

    public XMLParser(@NonNull InputStream stream, @NonNull InputStream schemaStream) throws IOException {
        try {
            this.mStream = null;
            this.mThread = new ParallelValidatorThread(stream, schemaStream);
            XMLInputFactory factory = XMLInputFactory.newInstance();
            factory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
            factory.setProperty("javax.xml.stream.isCoalescing", Boolean.TRUE);
            this.mReader = (XMLStreamReader)NullChecking.neverNull((Object)factory.createXMLStreamReader(((ParallelValidatorThread)NullChecking.neverNull((Object)this.mThread)).getValidatedInputStream()));
        }
        catch (XMLStreamException | SAXException exception) {
            throw new IOException(exception);
        }
    }

    @Override
    public void close() throws IOException {
        IOException ioe;
        block23: {
            block21: {
                block19: {
                    ioe = null;
                    if (this.mReader != null) {
                        try {
                            try {
                                this.mReader.close();
                            }
                            catch (XMLStreamException exception) {
                                ioe = new IOException(exception);
                                this.mReader = null;
                                break block19;
                            }
                        }
                        catch (Throwable throwable) {
                            this.mReader = null;
                            throw throwable;
                        }
                        this.mReader = null;
                    }
                }
                if (this.mStream != null) {
                    try {
                        try {
                            this.mStream.close();
                        }
                        catch (IOException e) {
                            if (ioe != null) {
                                ioe = e;
                            }
                            this.mStream = null;
                            break block21;
                        }
                    }
                    catch (Throwable throwable) {
                        this.mStream = null;
                        throw throwable;
                    }
                    this.mStream = null;
                }
            }
            if (this.mThread != null) {
                try {
                    try {
                        this.mThread.close();
                    }
                    catch (IOException e) {
                        if (ioe != null) {
                            ioe = e;
                        }
                        this.mThread = null;
                        break block23;
                    }
                }
                catch (Throwable throwable) {
                    this.mThread = null;
                    throw throwable;
                }
                this.mThread = null;
            }
        }
        if (ioe != null) {
            throw ioe;
        }
    }

    public String getAttribute(String name) {
        return this.mReader.getAttributeValue(null, name);
    }

    public @NonNull String getAttribute(String name, @NonNull String def) {
        String value = this.getAttribute(name);
        return value != null ? value : def;
    }

    public @NonNull Ternary getAttribute(String name, @NonNull Ternary def) {
        block13: {
            @Nullable String value = this.getAttribute(name);
            if (value == null) break block13;
            switch (value) {
                case "yes": {
                    return Ternary.TRUE;
                }
                case "no": {
                    return Ternary.FALSE;
                }
                case "maybe": {
                    return Ternary.MAYBE;
                }
            }
            return def;
        }
        return def;
    }

    public int getAttributeCount() {
        return this.mReader.getAttributeCount();
    }

    public String getAttributeName(int index) {
        return this.mReader.getAttributeLocalName(index);
    }

    public String getAttributeValue(int index) {
        return this.mReader.getAttributeValue(index);
    }

    public String getCurrentTag() {
        return this.mReader.getLocalName();
    }

    public double getDoubleAttribute(String name) {
        return this.getDoubleAttribute(name, 0.0);
    }

    public double getDoubleAttribute(String name, double def) {
        return BasicNumberUtils.getNonLocalizedDouble((String)this.getAttribute(name), (double)def);
    }

    public int getIntegerAttribute(String name) {
        return this.getIntegerAttribute(name, 0);
    }

    public int getIntegerAttribute(String name, int def) {
        return BasicNumberUtils.getNonLocalizedInteger((String)this.getAttribute(name), (int)def);
    }

    public Location getLocation() {
        return this.mReader.getLocation();
    }

    public String getLocationAsString() {
        Location location = this.mReader.getLocation();
        return location.getLineNumber() + ":" + location.getColumnNumber();
    }

    public long getLongAttribute(String name) {
        return this.getLongAttribute(name, 0L);
    }

    public long getLongAttribute(String name, long def) {
        return BasicNumberUtils.getNonLocalizedLong((String)this.getAttribute(name), (long)def);
    }

    public String getMarker() {
        return this.mMarker;
    }

    public String getText() throws IOException {
        try {
            String text = this.mReader.getElementText();
            this.mMarker = --this.mDepth + SEPARATOR + this.mReader.getLocalName();
            return text;
        }
        catch (XMLStreamException exception) {
            throw new IOException(exception);
        }
    }

    public boolean hasAttribute(String name) {
        return this.getAttribute(name) != null;
    }

    public boolean isAttributeSet(String name) {
        return this.isAttributeSet(name, false);
    }

    public boolean isAttributeSet(String name, boolean def) {
        return BasicNumberUtils.getBoolean((String)this.getAttribute(name, (String)NullChecking.neverNull((Object)Boolean.toString(def))));
    }

    public String nextTag() throws IOException {
        return this.nextTag(null);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String nextTag(String marker) throws IOException {
        try {
            block8: while (true) {
                if (!this.mReader.hasNext()) {
                    return null;
                }
                switch (this.mReader.next()) {
                    case 1: {
                        name = this.mReader.getLocalName();
                        this.mMarker = this.mDepth++ + "\u0000" + name;
                        return name;
                    }
                    case 2: {
                        this.mMarker = --this.mDepth + "\u0000" + this.mReader.getLocalName();
                        if (marker == null || !marker.equals(this.mMarker)) continue block8;
                        return null;
                    }
                    case 7: {
                        this.mMarker = null;
                        if (marker == null) ** break;
                        return null;
                    }
                    case 8: {
                        this.mMarker = null;
                        return null;
                    }
                }
            }
        }
        catch (XMLStreamException exception) {
            throw new IOException(exception);
        }
    }

    public void skip() throws IOException {
        this.skip(this.getMarker());
    }

    public void skip(String marker) throws IOException {
        while (this.nextTag(marker) != null) {
        }
    }

    private static final class ParallelValidatorThread
    extends Thread
    implements Closeable {
        private volatile boolean mClosed;
        private final @NonNull InputStream mSchemaStream;
        private final @NonNull InputStream mStream;
        private final @NonNull Object mutex = new Object();
        private final @NonNull PipedInputStream mValidatedInputStream;
        private final @NonNull Validator mValidator;
        private final @NonNull PipedOutputStream mValidatorOutputStream;
        private final @NonNull Result mValidatorResult;
        private final @NonNull Source mValidatorSource;

        public ParallelValidatorThread(@NonNull InputStream stream, @NonNull InputStream schemaStream) throws SAXException, IOException {
            StreamSource schemaSource = new StreamSource(schemaStream);
            SchemaFactory sFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = sFactory.newSchema(schemaSource);
            Validator validator = schema.newValidator();
            StreamSource source = new StreamSource(stream);
            PipedOutputStream validationOutput = new PipedOutputStream();
            PipedInputStream validationInput = new PipedInputStream(validationOutput);
            StreamResult result = new StreamResult(validationOutput);
            this.mStream = stream;
            this.mSchemaStream = schemaStream;
            this.mValidator = (Validator)NullChecking.neverNull((Object)validator);
            this.mValidatorSource = source;
            this.mValidatorResult = result;
            this.mValidatorOutputStream = validationOutput;
            this.mValidatedInputStream = validationInput;
            this.mClosed = false;
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            try {
                this.doClose();
            }
            catch (Throwable throwable) {
                Object object = this.mutex;
                synchronized (object) {
                    this.mClosed = true;
                    this.mutex.notifyAll();
                }
                throw throwable;
            }
            Object object = this.mutex;
            synchronized (object) {
                this.mClosed = true;
                this.mutex.notifyAll();
            }
        }

        public @NonNull PipedInputStream getValidatedInputStream() {
            return this.mValidatedInputStream;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            try {
                try {
                    this.mValidator.validate(this.mValidatorSource, this.mValidatorResult);
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            }
            finally {
                try {
                    this.doClose();
                }
                catch (IOException var3_6) {}
                ** while (!this.mClosed)
            }
lbl-1000:
            // 1 sources

            {
                try {
                    var3_7 = this.mutex;
                    synchronized (var3_7) {
                        while (!this.mClosed) {
                            this.mutex.wait();
                        }
                    }
                }
                catch (InterruptedException var3_8) {
                    // empty catch block
                }
                continue;
            }
lbl26:
            // 1 sources

        }

        private void doClose() throws IOException {
            IOException ioe = null;
            try {
                this.mValidatorOutputStream.close();
            }
            catch (IOException e) {
                ioe = e;
            }
            try {
                this.mSchemaStream.close();
            }
            catch (IOException e) {
                ioe = e;
            }
            try {
                this.mStream.close();
            }
            catch (IOException e) {
                ioe = e;
            }
            if (ioe != null) {
                throw ioe;
            }
        }
    }
}

