/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.common.utility.io;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;

public class StdLog {
    private static volatile boolean BYPASS_LOG = false;

    public static void cancel(Plugin plugin, String msg, Throwable throwable) {
        StdLog.log(8, plugin, msg, throwable);
    }

    public static void error(Plugin plugin, String msg, Throwable throwable) {
        StdLog.log(4, plugin, msg, throwable);
    }

    public static String extractMessage(Throwable throwable) {
        String message = null;
        if (throwable != null) {
            message = throwable.getLocalizedMessage();
            while (throwable.getCause() != null) {
                String msg = (throwable = throwable.getCause()).getLocalizedMessage();
                if (msg == null || msg.isEmpty()) continue;
                message = msg;
            }
        }
        return message;
    }

    public static String extractMultiLineMessage(Throwable throwable) {
        StringBuilder sb = new StringBuilder(512);
        if (throwable != null) {
            String lastMessage = throwable.getLocalizedMessage();
            if (lastMessage != null && !lastMessage.isEmpty()) {
                sb.append(lastMessage);
            }
            while (throwable.getCause() != null) {
                String msg = (throwable = throwable.getCause()).getLocalizedMessage();
                if (msg == null || msg.isEmpty() || lastMessage != null && msg.compareTo(lastMessage) == 0) continue;
                if (sb.length() > 0) {
                    sb.append("\n");
                }
                sb.append(msg);
                lastMessage = msg;
            }
        }
        return sb.toString();
    }

    public static void info(Plugin plugin, String msg) {
        StdLog.info(plugin, msg, null);
    }

    public static void info(Plugin plugin, String msg, Throwable throwable) {
        StdLog.log(1, plugin, msg, throwable);
    }

    /*
     * Unable to fully structure code
     */
    @SuppressFBWarnings(value={"INFORMATION_EXPOSURE_THROUGH_AN_ERROR_MESSAGE"})
    public static void log(int severity, Plugin plugin, String msg, Throwable throwable) {
        try {
            if (StdLog.BYPASS_LOG || plugin == null) ** GOTO lbl-1000
            try {
                plugin.getLog().log((IStatus)new Status(severity, plugin.getBundle().getSymbolicName(), 0, msg == null ? StdLog.extractMessage(throwable) : msg, throwable));
                return;
            }
            catch (Throwable var4_4) {
                if (msg != null) {
                    (severity == 4 ? System.err : System.out).println(String.format("[%s]: %s", new Object[]{StdLog.getStatusSeverityLabel(severity), msg}));
                }
                if (throwable != null) {
                    throwable.printStackTrace(severity == 4 ? System.err : System.out);
                }
            }
        }
        finally {
            System.out.flush();
            System.err.flush();
        }
    }

    public static void log(Plugin plugin, String msg) {
        StdLog.log(plugin, msg, null);
    }

    public static void log(Plugin plugin, String msg, Throwable throwable) {
        StdLog.log(4, plugin, msg, throwable);
    }

    public static void log(Plugin plugin, Throwable throwable) {
        StdLog.log(plugin, null, throwable);
    }

    public static void ok(Plugin plugin, String msg, Throwable throwable) {
        StdLog.log(0, plugin, msg, throwable);
    }

    public static void setBypass(boolean bypass) {
        BYPASS_LOG = bypass;
    }

    public static void warn(Plugin plugin, String msg) {
        StdLog.warning(plugin, msg, null);
    }

    public static void warning(Plugin plugin, String msg, Throwable throwable) {
        StdLog.log(2, plugin, msg, throwable);
    }

    private static String getStatusSeverityLabel(int severity) {
        switch (severity) {
            case 1: {
                return "INFO   ";
            }
            case 2: {
                return "WARNING";
            }
            case 4: {
                return "ERROR  ";
            }
        }
        return "!!!!!!!";
    }
}

