/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.common.utility.io;

import com.arm.streamline.common.utility.io.BufferUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;

public class RandomAccessLittleEndianFile
extends RandomAccessFile {
    private byte[] mBuffer = new byte[8];

    public RandomAccessLittleEndianFile(File file, String mode) throws FileNotFoundException {
        super(file, mode);
    }

    public RandomAccessLittleEndianFile(String path, String mode) throws FileNotFoundException {
        super(path, mode);
    }

    public final double readLEDouble() throws IOException {
        this.readFully(this.mBuffer, 0, 8);
        return BufferUtils.readLEDouble(this.mBuffer, 0);
    }

    public final float readLEFloat() throws IOException {
        this.readFully(this.mBuffer, 0, 4);
        return BufferUtils.readLEFloat(this.mBuffer, 0);
    }

    public final int readLEInt() throws IOException {
        this.readFully(this.mBuffer, 0, 4);
        return BufferUtils.readLEInt(this.mBuffer, 0);
    }

    public final long readLELong() throws IOException {
        this.readFully(this.mBuffer, 0, 8);
        return BufferUtils.readLELong(this.mBuffer, 0);
    }

    public final short readLEShort() throws IOException {
        this.readFully(this.mBuffer, 0, 2);
        return BufferUtils.readLEShort(this.mBuffer, 0);
    }

    public final int readLEUnsignedShort() throws IOException {
        this.readFully(this.mBuffer, 0, 2);
        return BufferUtils.readLEUnsignedShort(this.mBuffer, 0);
    }

    public final void writeLEDouble(double v) throws IOException {
        BufferUtils.writeLEDouble(this.mBuffer, 0, v);
        this.write(this.mBuffer, 0, 8);
    }

    public final void writeLEFloat(float v) throws IOException {
        BufferUtils.writeLEFloat(this.mBuffer, 0, v);
        this.write(this.mBuffer, 0, 4);
    }

    public final void writeLEInt(int v) throws IOException {
        BufferUtils.writeLEInt(this.mBuffer, 0, v);
        this.write(this.mBuffer, 0, 4);
    }

    public final void writeLELong(long v) throws IOException {
        BufferUtils.writeLELong(this.mBuffer, 0, v);
        this.write(this.mBuffer, 0, 8);
    }

    public final void writeLEShort(int v) throws IOException {
        BufferUtils.writeLEShort(this.mBuffer, 0, v);
        this.write(this.mBuffer, 0, 2);
    }
}

