/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.common.utility.io;

import com.arm.streamline.common.utility.io.IProgressProvider;
import com.arm.utils.function.Throwing;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.jdt.annotation.NonNull;

public final class CountedInputStream
extends FilterInputStream
implements IProgressProvider {
    private final long length;
    private long mCount;

    public CountedInputStream(@NonNull File file) throws FileNotFoundException {
        this((InputStream)Throwing.closeIfThrows(BufferedInputStream::new, (Object)((FileInputStream)Throwing.closeIfThrows(FileInputStream::new, (Object)file, (Closeable[])new Closeable[0])), (Closeable[])new Closeable[0]), file.length());
    }

    public CountedInputStream(@NonNull InputStream input, long length) {
        super(input);
        this.length = length;
    }

    public CountedInputStream(String path) throws FileNotFoundException {
        this(new File(path));
    }

    @Override
    public long getCurrentProgress() {
        return this.mCount;
    }

    @Override
    public long getTotalLength() {
        return this.length;
    }

    @Override
    public int read() throws IOException {
        int result = super.read();
        if (result != -1) {
            ++this.mCount;
        }
        return result;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int result = super.read(b, off, len);
        if (result != -1) {
            this.mCount += (long)result;
        }
        return result;
    }

    @Override
    public long skip(long n) throws IOException {
        long result = super.skip(n);
        this.mCount += result;
        return result;
    }
}

