/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.common.utility.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.eclipse.jdt.annotation.NonNull;

public class Compression {
    public static int packInt(long value, OutputStream out) throws IOException {
        return Compression.packInt(value, out::write);
    }

    public static int packInt(long value, @NonNull IBytesWriter out) throws IOException {
        int packedBytes = 0;
        boolean more = true;
        byte[] bytes = new byte[10];
        while (more) {
            byte b = (byte)(value & 0x7FL);
            if ((value >>= 7) == 0L && (b & 0x40) == 0 || value == -1L && (b & 0x40) != 0) {
                more = false;
            } else {
                b = (byte)(b | 0x80);
            }
            bytes[packedBytes++] = b;
        }
        out.write(bytes, 0, packedBytes);
        return packedBytes;
    }

    public static @NonNull String readString(InputStream mIn) throws IOException {
        int len = (int)Compression.unpackInt(mIn);
        if (len <= 0) {
            return "";
        }
        byte[] buf = new byte[len];
        if (mIn.read(buf) != len) {
            throw new EOFException();
        }
        return new String(buf, StandardCharsets.UTF_8);
    }

    public static long unpackInt(InputStream in) throws IOException {
        long l = 0L;
        long shift = 0L;
        long size = 64L;
        int b = -1;
        while ((b & 0x80) != 0) {
            int ch = in.read();
            if (ch == -1) {
                throw new EOFException();
            }
            b = (byte)ch;
            l |= (long)(b & 0x7F) << (int)shift;
            shift += 7L;
        }
        if (shift < 64L && (b & 0x40) != 0) {
            l |= -(1L << (int)shift);
        }
        return l;
    }

    public static long unpackInt(ByteBuffer in) {
        long l = 0L;
        long shift = 0L;
        long size = 64L;
        int b = -1;
        while ((b & 0x80) != 0) {
            b = in.get();
            l |= (long)(b & 0x7F) << (int)shift;
            shift += 7L;
        }
        if (shift < 64L && (b & 0x40) != 0) {
            l |= -(1L << (int)shift);
        }
        return l;
    }

    public static long[] unpackIntsOptimized(byte[] data) {
        if (data == null) {
            return null;
        }
        int arraySize = 0;
        byte[] byArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            byte element = byArray[n2];
            if ((element & 0x80) == 0) {
                ++arraySize;
            }
            ++n2;
        }
        long[] values = new long[arraySize];
        int index = 0;
        int dataPtr = 0;
        while (dataPtr < data.length) {
            long l = 0L;
            long shift = 0L;
            long size = 64L;
            int b = -1;
            while ((b & 0x80) != 0) {
                b = data[dataPtr++];
                l |= (long)(b & 0x7F) << (int)shift;
                shift += 7L;
            }
            if (shift < 64L && (b & 0x40) != 0) {
                l |= -(1L << (int)shift);
            }
            values[index++] = l;
        }
        return values;
    }

    public static void writeString(String s, OutputStream out) throws IOException {
        if (s == null) {
            Compression.packInt(0L, out);
            return;
        }
        byte[] buf = s.getBytes(StandardCharsets.UTF_8);
        Compression.packInt((long)buf.length, out);
        if (buf.length > 0) {
            out.write(buf);
        }
    }

    @FunctionalInterface
    public static interface IBytesWriter {
        public void write(byte @NonNull [] var1, int var2, int var3) throws IOException;
    }
}

