/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.common.utility.io;

import com.arm.streamline.common.utility.io.BufferUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.CRC32;
import java.util.zip.Deflater;

public class CompressedOutputStream
extends OutputStream {
    private static final byte[] GZIP_HEADER;
    private OutputStream mOut;
    private CRC32 mCRC;
    private Deflater mDeflater;
    private int mInputCount;
    private byte[] mInputBuffer;
    private byte[] mOutputBuffer;

    static {
        byte[] byArray = new byte[10];
        byArray[0] = 31;
        byArray[1] = -117;
        byArray[2] = 8;
        GZIP_HEADER = byArray;
    }

    public CompressedOutputStream(OutputStream stream) throws IOException {
        this(stream, 3, 0x100000);
    }

    public CompressedOutputStream(OutputStream stream, int compressionLevel, int bufferSize) throws IOException {
        this.mOut = stream;
        this.mCRC = new CRC32();
        this.mDeflater = new Deflater(compressionLevel, true);
        this.mInputBuffer = new byte[bufferSize];
        this.mOutputBuffer = new byte[bufferSize];
        this.mOut.write(GZIP_HEADER);
        this.mCRC.reset();
    }

    @Override
    public void close() throws IOException {
        if (this.mDeflater != null) {
            if (!this.mDeflater.finished()) {
                this.flushInputBuffer();
                this.mDeflater.finish();
                while (!this.mDeflater.finished()) {
                    int length = this.mDeflater.deflate(this.mOutputBuffer, 0, this.mOutputBuffer.length);
                    if (length <= 0) continue;
                    this.mOut.write(this.mOutputBuffer, 0, length);
                }
                BufferUtils.writeLEInt(this.mOutputBuffer, 0, (int)this.mCRC.getValue());
                BufferUtils.writeLEInt(this.mOutputBuffer, 4, this.mDeflater.getTotalIn());
                this.mOut.write(this.mOutputBuffer, 0, 8);
            }
            this.mDeflater.end();
            this.mOut.close();
            this.mDeflater = null;
        }
    }

    @Override
    public void flush() throws IOException {
        this.flushInputBuffer();
        this.mOut.flush();
    }

    @Override
    public synchronized void write(byte[] buffer, int offset, int length) throws IOException {
        if (length > 0) {
            int remaining = this.mInputBuffer.length - this.mInputCount;
            while (length >= remaining) {
                System.arraycopy(buffer, offset, this.mInputBuffer, this.mInputCount, remaining);
                this.mInputCount = this.mInputBuffer.length;
                this.flushInputBuffer();
                offset += remaining;
                length -= remaining;
                remaining = this.mInputBuffer.length;
            }
            if (length > 0) {
                System.arraycopy(buffer, offset, this.mInputBuffer, this.mInputCount, length);
                this.mInputCount += length;
            }
        }
    }

    @Override
    public synchronized void write(int byteValue) throws IOException {
        if (this.mInputCount >= this.mInputBuffer.length) {
            this.flushInputBuffer();
        }
        this.mInputBuffer[this.mInputCount++] = (byte)byteValue;
    }

    private synchronized void flushInputBuffer() throws IOException {
        if (this.mInputCount > 0) {
            if (this.mDeflater != null && !this.mDeflater.finished()) {
                int i = 0;
                while (i < this.mInputCount) {
                    this.mDeflater.setInput(this.mInputBuffer, i, Math.min(this.mOutputBuffer.length, this.mInputCount - i));
                    while (!this.mDeflater.needsInput()) {
                        int len1 = this.mDeflater.deflate(this.mOutputBuffer);
                        if (len1 <= 0) continue;
                        this.mOut.write(this.mOutputBuffer, 0, len1);
                    }
                    i += this.mOutputBuffer.length;
                }
                this.mCRC.update(this.mInputBuffer, 0, this.mInputCount);
            }
            this.mInputCount = 0;
        }
    }
}

