/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.common.utility.io;

import com.arm.streamline.common.utility.io.FilePath;
import com.arm.streamline.common.utility.io.IOMessages;
import com.arm.utils.IterUtils;
import com.arm.utils.Platform;
import com.arm.utils.io.FileUtils;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class CommonFileUtils
extends FileUtils {
    public static final String COMPRESSED_EXTENSION = ".gz";
    public static final String DELETE_EXTENSION = ".del";
    protected static final long TRANSFER_LIMIT = 0x100000L;
    private static final int MAX_FILE_NAME_LENGTH = 255;

    public static final void copyFile(File src, File dst) throws IOException, InterruptedException {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (FileInputStream srcIn = new FileInputStream(src);){
                Throwable throwable2 = null;
                Object var6_11 = null;
                try (FileChannel srcChannel = srcIn.getChannel();){
                    Throwable throwable3 = null;
                    Object var9_16 = null;
                    try (FileOutputStream dstOut = new FileOutputStream(dst);){
                        Throwable throwable4 = null;
                        Object var12_21 = null;
                        try (FileChannel dstChannel = dstOut.getChannel();){
                            long remaining = srcChannel.size();
                            long pos = 0L;
                            while (remaining > 0L) {
                                long transfer = remaining > 0x100000L ? 0x100000L : remaining;
                                long amt = dstChannel.transferFrom(srcChannel, pos, transfer);
                                remaining -= amt;
                                pos += amt;
                            }
                        }
                        catch (Throwable throwable5) {
                            if (throwable4 == null) {
                                throwable4 = throwable5;
                            } else if (throwable4 != throwable5) {
                                throwable4.addSuppressed(throwable5);
                            }
                            throw throwable4;
                        }
                    }
                    catch (Throwable throwable6) {
                        if (throwable3 == null) {
                            throwable3 = throwable6;
                        } else if (throwable3 != throwable6) {
                            throwable3.addSuppressed(throwable6);
                        }
                        throw throwable3;
                    }
                }
                catch (Throwable throwable7) {
                    if (throwable2 == null) {
                        throwable2 = throwable7;
                    } else if (throwable2 != throwable7) {
                        throwable2.addSuppressed(throwable7);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable8) {
                if (throwable == null) {
                    throwable = throwable8;
                } else if (throwable != throwable8) {
                    throwable.addSuppressed(throwable8);
                }
                throw throwable;
            }
        }
        catch (ClosedByInterruptException exception) {
            InterruptedException ie = new InterruptedException();
            ie.initCause(exception);
            throw ie;
        }
    }

    public static final void copyFileTree(@NonNull File src, @NonNull File dst) throws IOException, InterruptedException {
        CommonFileUtils.copyFileTree(src, dst, null);
    }

    public static final void copyFileTree(@NonNull File src, @NonNull File dst, @Nullable FileFilter filter) throws IOException, InterruptedException {
        if (filter == null || filter.accept(src)) {
            if (src.isDirectory()) {
                dst.mkdirs();
                File[] files = src.listFiles();
                if (files != null) {
                    File[] fileArray = files;
                    int n = files.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File file = fileArray[n2];
                        CommonFileUtils.copyFileTree(file, new File(dst, file.getName()), filter);
                        ++n2;
                    }
                }
            } else {
                CommonFileUtils.copyFile(src, dst);
            }
        }
    }

    public static long countDiskUsage(@NonNull File path) {
        if (path.isDirectory()) {
            @NonNull File @Nullable [] children = path.listFiles();
            if (children == null) {
                return 0L;
            }
            return Arrays.stream(children).mapToLong(CommonFileUtils::countDiskUsage).sum();
        }
        if (path.isFile()) {
            return path.length();
        }
        return 0L;
    }

    public static long countFileTree(@NonNull File src, @Nullable FileFilter filter) {
        if (filter == null || filter.accept(src)) {
            if (src.isDirectory()) {
                long result = 0L;
                @NonNull File @Nullable [] files = src.listFiles();
                if (files != null) {
                    File[] fileArray = files;
                    int n = files.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File file = fileArray[n2];
                        result += CommonFileUtils.countFileTree(file, filter);
                        ++n2;
                    }
                }
                return result;
            }
            return 1L;
        }
        return 0L;
    }

    public static final @NonNull File createPrivateTempDir() {
        File file;
        String base = System.getProperty("user.name") + "-";
        String tmpDir = System.getProperty("java.io.tmpdir");
        while ((file = new File(tmpDir, base + System.nanoTime())).exists() || !file.mkdir()) {
        }
        return file;
    }

    public static final boolean exists(@NonNull File file) {
        return CommonFileUtils.getFile(file).exists();
    }

    public static @Nullable File findExecutableOnPath(@NonNull String name) {
        String path = System.getenv("PATH");
        if (path == null) {
            path = System.getenv("Path");
        }
        if (path == null) {
            return null;
        }
        return CommonFileUtils.findExecutableIn(name, Arrays.asList(path.split(File.pathSeparator)));
    }

    public static @Nullable File findExecutableIn(@NonNull String name, @NonNull Iterable<@NonNull String> directories) {
        String[] extensions;
        if (Platform.isWindows()) {
            String pathext = System.getenv("PATHEXT");
            if (pathext == null) {
                pathext = System.getenv("PathExt");
            }
            extensions = pathext != null ? pathext.split(File.pathSeparator) : null;
        } else {
            extensions = null;
        }
        for (String dir : directories) {
            File file = new File(dir, name);
            if (file.isFile() && file.canExecute()) {
                return file;
            }
            if (extensions == null) continue;
            String[] stringArray = extensions;
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                String ext = stringArray[n2];
                file = new File(dir, name + ext);
                if (file.isFile() && file.canExecute()) {
                    return file;
                }
                ++n2;
            }
        }
        return null;
    }

    public static final @NonNull File getCompressedFile(@NonNull File file) {
        if (!FilePath.getExtension(file.getName()).equals(COMPRESSED_EXTENSION)) {
            file = new File(file.getParentFile(), file.getName() + COMPRESSED_EXTENSION);
        }
        return file;
    }

    public static long getCreatedModifiedOrAccessedTimeInSeconds(@NonNull File file) {
        try {
            BasicFileAttributes attributes = Files.readAttributes(file.toPath(), BasicFileAttributes.class, new LinkOption[0]);
            long creationTimeMS = attributes.creationTime().toMillis();
            if (creationTimeMS > 0L) {
                return creationTimeMS / 1000L;
            }
            long modifiedTimeMS = attributes.lastModifiedTime().toMillis();
            if (modifiedTimeMS > 0L) {
                return modifiedTimeMS / 1000L;
            }
            long accessedTimeMS = attributes.lastAccessTime().toMillis();
            if (accessedTimeMS > 0L) {
                return accessedTimeMS / 1000L;
            }
            return -1L;
        }
        catch (IOException exception) {
            return -1L;
        }
    }

    public static final @NonNull File getFile(@NonNull File file) {
        File compressed = CommonFileUtils.getCompressedFile(file);
        if (compressed.exists()) {
            return compressed;
        }
        return file;
    }

    public static final int getModifiedTime(File file) {
        return (int)(file.lastModified() / 1000L);
    }

    public static final int getModifiedTime(String path) {
        return CommonFileUtils.getModifiedTime(new File(path));
    }

    public static final void ignoredClose(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void makeDirectory(File path) throws IOException {
        if (!path.mkdirs() && !path.isDirectory()) {
            boolean pathTooLong = !path.exists() && path.getName().length() > 255;
            String errorMessage = pathTooLong ? IOMessages.MKDIR_TOO_LONG_FAILED : IOMessages.MKDIR_FAILED;
            throw new IOException(MessageFormat.format(errorMessage, path.getAbsolutePath()));
        }
    }

    public static void makeDirectory(String pathname) throws IOException {
        CommonFileUtils.makeDirectory(new File(pathname));
    }

    public static void makeDirectory(String path, String name) throws IOException {
        CommonFileUtils.makeDirectory(new File(path, name));
    }

    public static boolean scanFiles(@NonNull File directory, @NonNull FileFilter filter, @NonNull Consumer<@NonNull File> consumer) {
        return CommonFileUtils.scanFiles(directory, filter, consumer, () -> false);
    }

    public static boolean scanFiles(@NonNull File directory, @NonNull FileFilter filter, @NonNull Consumer<@NonNull File> consumer, @NonNull BooleanSupplier interruptedSupplier) {
        if (!directory.isDirectory()) {
            return true;
        }
        @NonNull Object @Nullable [] files = (directory = CommonFileUtils.canonicalise((File)directory)).listFiles(filter);
        if (files == null) {
            return true;
        }
        return IterUtils.forEachInterruptable((Object[])files, (BooleanSupplier)interruptedSupplier, file -> consumer.accept(CommonFileUtils.canonicalise((File)file)));
    }

    public static void scanFiles(@NonNull File directory, @NonNull FilenameFilter filter, @NonNull Consumer<@NonNull File> consumer) {
        CommonFileUtils.scanFiles(directory, filter, consumer, () -> false);
    }

    public static boolean scanFiles(@NonNull File directory, @NonNull FilenameFilter filter, @NonNull Consumer<@NonNull File> consumer, @NonNull BooleanSupplier interruptedSupplier) {
        return CommonFileUtils.scanFiles(directory, (File file) -> filter.accept(file.getParentFile(), file.getName()), consumer, interruptedSupplier);
    }
}

