/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.common.utility.io;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.InflaterInputStream;

public class BufferUtils {
    public static final InputStream createInputStream(byte[] data, boolean compressed) {
        InputStream is = new ByteArrayInputStream(data);
        if (compressed) {
            is = new InflaterInputStream(is);
        }
        return is;
    }

    public static final boolean equals(byte[] b1, byte[] b2) {
        if (b1 == b2) {
            return true;
        }
        if (b1 != null && b2 != null && b1.length == b2.length) {
            int i = 0;
            while (i < b1.length) {
                if (b1[i] != b2[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public static final double readDouble(byte[] buffer, int offset) throws IOException {
        return Double.longBitsToDouble(BufferUtils.readLong(buffer, offset));
    }

    public static final float readFloat(byte[] buffer, int offset) throws IOException {
        return Float.intBitsToFloat(BufferUtils.readInt(buffer, offset));
    }

    public static final int readInt(byte[] buffer, int offset) throws IOException {
        if (offset + 4 > buffer.length) {
            throw new IOException();
        }
        return (buffer[offset] & 0xFF) << 24 | (buffer[offset + 1] & 0xFF) << 16 | (buffer[offset + 2] & 0xFF) << 8 | (buffer[offset + 3] & 0xFF) << 0;
    }

    public static final double readLEDouble(byte[] buffer, int offset) throws IOException {
        return Double.longBitsToDouble(BufferUtils.readLELong(buffer, offset));
    }

    public static final float readLEFloat(byte[] buffer, int offset) throws IOException {
        return Float.intBitsToFloat(BufferUtils.readLEInt(buffer, offset));
    }

    public static final int readLEInt(byte[] buffer, int offset) throws IOException {
        if (offset + 4 > buffer.length) {
            throw new IOException();
        }
        return (buffer[offset] & 0xFF) << 0 | (buffer[offset + 1] & 0xFF) << 8 | (buffer[offset + 2] & 0xFF) << 16 | (buffer[offset + 3] & 0xFF) << 24;
    }

    public static final long readLEIntSize(byte[] buffer, int offset, int size, boolean signed) throws IOException {
        switch (size) {
            case 1: {
                if (signed) {
                    return buffer[offset];
                }
                return buffer[offset] & 0xFF;
            }
            case 2: {
                if (signed) {
                    return BufferUtils.readLEShort(buffer, offset);
                }
                return BufferUtils.readLEShort(buffer, offset) & 0xFFFF;
            }
            case 4: {
                if (signed) {
                    return BufferUtils.readLEInt(buffer, offset);
                }
                return (long)BufferUtils.readLEInt(buffer, offset) & 0xFFFFFFFFL;
            }
            case 8: {
                return BufferUtils.readLELong(buffer, offset);
            }
        }
        throw new IOException();
    }

    public static final long readLELong(byte[] buffer, int offset) throws IOException {
        if (offset + 8 > buffer.length) {
            throw new IOException();
        }
        return ((long)buffer[offset] & 0xFFL) << 0 | ((long)buffer[offset + 1] & 0xFFL) << 8 | ((long)buffer[offset + 2] & 0xFFL) << 16 | ((long)buffer[offset + 3] & 0xFFL) << 24 | ((long)buffer[offset + 4] & 0xFFL) << 32 | ((long)buffer[offset + 5] & 0xFFL) << 40 | ((long)buffer[offset + 6] & 0xFFL) << 48 | ((long)buffer[offset + 7] & 0xFFL) << 56;
    }

    public static final short readLEShort(byte[] buffer, int offset) throws IOException {
        if (offset + 2 > buffer.length) {
            throw new IOException();
        }
        return (short)((buffer[offset] & 0xFF) << 0 | (buffer[offset + 1] & 0xFF) << 8);
    }

    public static final int readLEUnsignedShort(byte[] buffer, int offset) throws IOException {
        if (offset + 2 > buffer.length) {
            throw new IOException();
        }
        return (buffer[offset] & 0xFF) << 0 | (buffer[offset + 1] & 0xFF) << 8;
    }

    public static final long readLong(byte[] buffer, int offset) throws IOException {
        if (offset + 8 > buffer.length) {
            throw new IOException();
        }
        return ((long)buffer[offset] & 0xFFL) << 56 | ((long)buffer[offset + 1] & 0xFFL) << 48 | ((long)buffer[offset + 2] & 0xFFL) << 40 | ((long)buffer[offset + 3] & 0xFFL) << 32 | ((long)buffer[offset + 4] & 0xFFL) << 24 | ((long)buffer[offset + 5] & 0xFFL) << 16 | ((long)buffer[offset + 6] & 0xFFL) << 8 | ((long)buffer[offset + 7] & 0xFFL) << 0;
    }

    public static final short readShort(byte[] buffer, int offset) throws IOException {
        if (offset + 2 > buffer.length) {
            throw new IOException();
        }
        return (short)((buffer[offset] & 0xFF) << 8 | (buffer[offset + 1] & 0xFF) << 0);
    }

    public static final int readUnsignedShort(byte[] buffer, int offset) throws IOException {
        if (offset + 2 > buffer.length) {
            throw new IOException();
        }
        return (buffer[offset] & 0xFF) << 8 | (buffer[offset + 1] & 0xFF) << 0;
    }

    public static final void writeDouble(byte[] buffer, int offset, double v) throws IOException {
        BufferUtils.writeLong(buffer, offset, Double.doubleToLongBits(v));
    }

    public static final void writeFloat(byte[] buffer, int offset, float v) throws IOException {
        BufferUtils.writeInt(buffer, offset, Float.floatToIntBits(v));
    }

    public static final void writeInt(byte[] buffer, int offset, int v) throws IOException {
        if (offset + 4 > buffer.length) {
            throw new IOException();
        }
        buffer[offset] = (byte)(v >>> 24 & 0xFF);
        buffer[offset + 1] = (byte)(v >>> 16 & 0xFF);
        buffer[offset + 2] = (byte)(v >>> 8 & 0xFF);
        buffer[offset + 3] = (byte)(v >>> 0 & 0xFF);
    }

    public static final void writeLEDouble(byte[] buffer, int offset, double v) throws IOException {
        BufferUtils.writeLELong(buffer, offset, Double.doubleToLongBits(v));
    }

    public static final void writeLEFloat(byte[] buffer, int offset, float v) throws IOException {
        BufferUtils.writeLEInt(buffer, offset, Float.floatToIntBits(v));
    }

    public static final void writeLEInt(byte[] buffer, int offset, int v) throws IOException {
        if (offset + 4 > buffer.length) {
            throw new IOException();
        }
        buffer[offset] = (byte)(v >>> 0 & 0xFF);
        buffer[offset + 1] = (byte)(v >>> 8 & 0xFF);
        buffer[offset + 2] = (byte)(v >>> 16 & 0xFF);
        buffer[offset + 3] = (byte)(v >>> 24 & 0xFF);
    }

    public static final void writeLELong(byte[] buffer, int offset, long v) throws IOException {
        if (offset + 8 > buffer.length) {
            throw new IOException();
        }
        buffer[offset] = (byte)(v >>> 0 & 0xFFL);
        buffer[offset + 1] = (byte)(v >>> 8 & 0xFFL);
        buffer[offset + 2] = (byte)(v >>> 16 & 0xFFL);
        buffer[offset + 3] = (byte)(v >>> 24 & 0xFFL);
        buffer[offset + 4] = (byte)(v >>> 32 & 0xFFL);
        buffer[offset + 5] = (byte)(v >>> 40 & 0xFFL);
        buffer[offset + 6] = (byte)(v >>> 48 & 0xFFL);
        buffer[offset + 7] = (byte)(v >>> 56 & 0xFFL);
    }

    public static final void writeLEShort(byte[] buffer, int offset, int v) throws IOException {
        if (offset + 2 > buffer.length) {
            throw new IOException();
        }
        buffer[offset] = (byte)(v >>> 0 & 0xFF);
        buffer[offset + 1] = (byte)(v >>> 8 & 0xFF);
    }

    public static final void writeLong(byte[] buffer, int offset, long v) throws IOException {
        if (offset + 8 > buffer.length) {
            throw new IOException();
        }
        buffer[offset] = (byte)(v >>> 56 & 0xFFL);
        buffer[offset + 1] = (byte)(v >>> 48 & 0xFFL);
        buffer[offset + 2] = (byte)(v >>> 40 & 0xFFL);
        buffer[offset + 3] = (byte)(v >>> 32 & 0xFFL);
        buffer[offset + 4] = (byte)(v >>> 24 & 0xFFL);
        buffer[offset + 5] = (byte)(v >>> 16 & 0xFFL);
        buffer[offset + 6] = (byte)(v >>> 8 & 0xFFL);
        buffer[offset + 7] = (byte)(v >>> 0 & 0xFFL);
    }

    public static final void writeShort(byte[] buffer, int offset, int v) throws IOException {
        if (offset + 2 > buffer.length) {
            throw new IOException();
        }
        buffer[offset] = (byte)(v >>> 8 & 0xFF);
        buffer[offset + 1] = (byte)(v >>> 0 & 0xFF);
    }
}

