/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.common.utility;

import com.arm.streamline.common.preferences.CommonPreferences;
import com.arm.streamline.common.utility.UtilityMessages;
import com.arm.streamline.common.utility.WorkspaceUtils;
import com.arm.streamline.common.utility.io.FilePath;
import com.arm.utils.io.FileUtils;
import java.io.File;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.widgets.FileDialog;

public class PathChoice {
    public static final @Nullable String chooseCaptureSavePath() {
        return PathChoice.chooseCaptureSavePath(PathChoice.getDefaultCapturePath(null));
    }

    public static final @Nullable String chooseCaptureSavePath(@NonNull String capturePath) {
        String extension = ".apc";
        String extensionDescription = UtilityMessages.APC_DESCRIPTION;
        FileDialog dialog = new FileDialog(WorkspaceUtils.getShell(), 8192);
        dialog.setFilterExtensions(new String[]{"*" + extension, "*.*"});
        dialog.setFilterNames(new String[]{extensionDescription, UtilityMessages.ALL_FILES});
        dialog.setOverwrite(true);
        dialog.setFilterPath(FilePath.getParent(capturePath));
        dialog.setFileName(FilePath.getLeafName(capturePath));
        String path = dialog.open();
        if (path != null) {
            CommonPreferences.setLastSavePath(FilePath.getParent(path));
            path = FilePath.enforceExtension(path, ".apc");
            CommonPreferences.setLastCaptureName(CommonPreferences.getBaseName(path));
        }
        return path;
    }

    public static @NonNull String getDefaultCapturePath(@Nullable String captureName) {
        if (captureName == null) {
            captureName = CommonPreferences.getLastCaptureName();
        }
        File path = new File(CommonPreferences.getLastSavePath());
        File result = new File(path, CommonPreferences.chooseUniqueName(path, captureName + ".apc"));
        return FileUtils.canonicalise((File)result).getAbsolutePath();
    }
}

