/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.common.report.model;

import com.arm.streamline.common.model.Scales;
import com.arm.streamline.common.model.ZoomLevel;
import com.arm.streamline.common.report.model.Messages;
import org.eclipse.jdt.annotation.NonNull;

public enum ResolutionMode {
    SUMMARY(Messages.RESOLUTION_SUMMARY, "summary"),
    NORMAL(Messages.RESOLUTION_NORMAL, "normal"),
    HIGH(Messages.RESOLUTION_HIGH, "high"),
    ULTRAHIGH(Messages.RESOLUTION_ULTRA, "ultrahigh");

    private @NonNull String displayName;
    private @NonNull String stringValue;

    public static @NonNull ResolutionMode fromStringValue(String stringValue) throws IllegalArgumentException {
        ResolutionMode[] resolutionModeArray = ResolutionMode.values();
        int n = resolutionModeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ResolutionMode enumValue = resolutionModeArray[n2];
            if (enumValue.stringValue.equals(stringValue)) {
                return enumValue;
            }
            ++n2;
        }
        throw new IllegalArgumentException();
    }

    private ResolutionMode(String displayName, String stringValue) {
        this.stringValue = stringValue;
        this.displayName = displayName;
    }

    public @NonNull String getStringValue() {
        return this.stringValue;
    }

    public @NonNull String toString() {
        return this.displayName;
    }

    public @NonNull ZoomLevel toDensestZoomLevel() {
        switch (this) {
            case SUMMARY: {
                return Scales.DENSEST_SUMMARY_RES_ZOOM_LEVEL;
            }
            case NORMAL: {
                return Scales.DENSEST_LO_RES_ZOOM_LEVEL;
            }
            case HIGH: {
                return Scales.DENSEST_HI_RES_ZOOM_LEVEL;
            }
            case ULTRAHIGH: {
                return Scales.DENSEST_ULTRA_HI_RES_ZOOM_LEVEL;
            }
        }
        throw new AssertionError((Object)this);
    }

    public @NonNull ZoomLevel @NonNull [] toZoomLevels() {
        switch (this) {
            case SUMMARY: {
                return Scales.SUMMARY_RES_ZOOM_LEVELS;
            }
            case NORMAL: {
                return Scales.LO_RES_ZOOM_LEVELS;
            }
            case HIGH: {
                return Scales.HI_RES_ZOOM_LEVELS;
            }
            case ULTRAHIGH: {
                return Scales.ULTRA_HI_RES_ZOOM_LEVELS;
            }
        }
        throw new AssertionError((Object)this);
    }
}

