/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.common.model.warnings;

import com.arm.streamline.common.model.warnings.WarningSeverity;
import com.arm.streamline.common.model.warnings.WarningType;
import com.arm.streamline.common.utility.io.XMLGenerator;
import com.arm.streamline.common.utility.io.XMLParser;
import com.arm.utils.NullChecking;
import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class WarningItem {
    private static final String ATTR_CATEGORY_ID = "category_id";
    private static final String ATTR_DESCRIPTION = "description";
    private static final String ATTR_SEVERITY = "severity";
    private static final String ATTR_TITLE = "title";
    private static final String ATTR_VARIABLE = "variable";
    private final @NonNull String mDescription;
    private final boolean mPersist;
    private final @NonNull WarningSeverity mSeverity;
    private final @NonNull String mTitle;
    private final @NonNull WarningType mType;
    private final @Nullable String mVariableSubstitutionString;
    private final @Nullable String mVariableWithinList;

    public WarningItem(@NonNull WarningType type, @NonNull WarningSeverity severity, @NonNull String title, @NonNull String description) {
        this(type, severity, title, description, true);
    }

    public WarningItem(@NonNull WarningType type, @NonNull WarningSeverity severity, @NonNull String title, @NonNull String description, boolean persist) {
        this.mType = type;
        this.mSeverity = severity;
        this.mTitle = title;
        this.mDescription = description;
        this.mPersist = persist;
        this.mVariableSubstitutionString = null;
        this.mVariableWithinList = null;
    }

    public WarningItem(@NonNull WarningType type, @NonNull WarningSeverity severity, @NonNull String title, @NonNull String variableString, @NonNull String variable) {
        this.mType = type;
        this.mSeverity = severity;
        this.mTitle = title;
        this.mDescription = MessageFormat.format(variableString, variable);
        this.mPersist = true;
        this.mVariableSubstitutionString = variableString;
        this.mVariableWithinList = variable;
    }

    public WarningItem(@NonNull XMLParser xml) throws IOException {
        this.mType = WarningType.get(xml.getAttribute(ATTR_CATEGORY_ID), WarningType.MISC);
        this.mSeverity = WarningSeverity.get(xml.getAttribute(ATTR_SEVERITY), WarningSeverity.MEDIUM);
        this.mTitle = xml.getAttribute(ATTR_TITLE, "");
        if (xml.hasAttribute(ATTR_DESCRIPTION)) {
            this.mDescription = xml.getAttribute(ATTR_DESCRIPTION, "");
            this.mVariableWithinList = null;
            this.mVariableSubstitutionString = null;
            xml.skip();
        } else if (xml.hasAttribute(ATTR_VARIABLE)) {
            this.mVariableWithinList = xml.getAttribute(ATTR_VARIABLE);
            this.mVariableSubstitutionString = xml.getText();
            this.mDescription = MessageFormat.format(this.mVariableSubstitutionString, this.mVariableWithinList);
        } else {
            this.mDescription = (String)NullChecking.neverNullOr((Object)xml.getText(), (Object)"");
            this.mVariableWithinList = null;
            this.mVariableSubstitutionString = null;
        }
        this.mPersist = true;
    }

    public boolean equals(Object obj) {
        if (obj instanceof WarningItem) {
            WarningItem other = (WarningItem)obj;
            return this.mPersist == other.mPersist && NullChecking.equalsNullable((Object)this.mDescription, (Object)other.mDescription) && NullChecking.equalsNullable((Object)((Object)this.mSeverity), (Object)((Object)other.mSeverity)) && NullChecking.equalsNullable((Object)this.mTitle, (Object)other.mTitle) && NullChecking.equalsNullable((Object)((Object)this.mType), (Object)((Object)other.mType)) && NullChecking.equalsNullable((Object)this.mVariableSubstitutionString, (Object)other.mVariableSubstitutionString) && NullChecking.equalsNullable((Object)this.mVariableWithinList, (Object)other.mVariableWithinList);
        }
        return false;
    }

    public final @NonNull String getDescription() {
        return this.mDescription;
    }

    public final @NonNull WarningSeverity getSeverity() {
        return this.mSeverity;
    }

    public final @NonNull String getTitle() {
        return this.mTitle;
    }

    public final @NonNull WarningType getType() {
        return this.mType;
    }

    public final @Nullable String getVariable() {
        return this.mVariableWithinList;
    }

    public final @Nullable String getVariableSubstitutionString() {
        return this.mVariableSubstitutionString;
    }

    public int hashCode() {
        String mVariableSubstitutionString = this.mVariableSubstitutionString;
        String mVariableWithinList = this.mVariableWithinList;
        int prime = 31;
        int result = 1;
        result = 31 * result + this.mDescription.hashCode();
        result = 31 * result + (this.mPersist ? 1231 : 1237);
        result = 31 * result + this.mSeverity.hashCode();
        result = 31 * result + this.mTitle.hashCode();
        result = 31 * result + this.mType.hashCode();
        result = 31 * result + (mVariableSubstitutionString == null ? 0 : mVariableSubstitutionString.hashCode());
        result = 31 * result + (mVariableWithinList == null ? 0 : mVariableWithinList.hashCode());
        return result;
    }

    public final void save(String tag, XMLGenerator xml) throws IOException {
        if (this.mPersist) {
            xml.startTag(tag);
            xml.addAttribute(ATTR_CATEGORY_ID, this.mType.getXmlKey());
            xml.addAttribute(ATTR_SEVERITY, this.mSeverity.getXmlKey());
            xml.addAttribute(ATTR_TITLE, this.mTitle);
            if (this.mVariableWithinList == null) {
                xml.addText(this.mDescription);
            } else {
                xml.addAttribute(ATTR_VARIABLE, this.mVariableWithinList);
                xml.addText(this.mVariableSubstitutionString);
            }
            xml.endTag();
        }
    }

    public String toString() {
        return String.format("WarningItem [mType=%s, mSeverity=%s, mTitle=%s, mDescription=%s]", new Object[]{this.mType, this.mSeverity, this.mTitle, this.mDescription});
    }
}

