/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.common.model.warnings;

import com.arm.streamline.common.CommonPlugin;
import com.arm.streamline.common.model.warnings.IRawWarnings;
import com.arm.streamline.common.model.warnings.IWarningListener;
import com.arm.streamline.common.model.warnings.WarningItem;
import com.arm.streamline.common.utility.io.XMLGenerator;
import com.arm.streamline.common.utility.io.XMLParser;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;

public class RawWarnings
implements IRawWarnings {
    private static final String FILENAME = "warnings.xml";
    private static final String TAG_WARNINGS = "warnings";
    private static final String TAG_WARNING = "warning";
    private final @NonNull List<@NonNull WarningItem> mItems = new ArrayList<WarningItem>();
    private final @NonNull List<@NonNull IWarningListener> mListeners = new ArrayList<IWarningListener>();

    public RawWarnings() {
    }

    public RawWarnings(@NonNull IRawWarnings that) {
        this.mItems.addAll(that.getItems());
    }

    @Override
    public void add(@NonNull WarningItem item) {
        if (!this.mItems.contains(item)) {
            this.mItems.add(item);
            this.notifyListeners();
        }
    }

    @Override
    public final synchronized void addListener(@NonNull IWarningListener listener) {
        if (!this.mListeners.contains(listener)) {
            this.mListeners.add(listener);
        }
    }

    @Override
    public void clear() {
        if (!this.mItems.isEmpty()) {
            this.mItems.clear();
            this.notifyListeners();
        }
    }

    @Override
    public final boolean isEmpty() {
        return this.mItems.isEmpty();
    }

    @Override
    public @NonNull Iterator<@NonNull WarningItem> iterator() {
        return this.mItems.iterator();
    }

    @Override
    public void load(@NonNull File dir) {
        boolean notify = false;
        try {
            Throwable throwable = null;
            Object var4_7 = null;
            try (XMLParser xml = XMLParser.create(new File(dir, FILENAME));){
                String tag;
                while ((tag = xml.nextTag()) != null) {
                    if (!TAG_WARNINGS.equals(tag)) continue;
                    String marker = xml.getMarker();
                    while ((tag = xml.nextTag(marker)) != null) {
                        if (TAG_WARNING.equals(tag)) {
                            this.mItems.add(new WarningItem(xml));
                            notify = true;
                            continue;
                        }
                        xml.skip();
                    }
                    break;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (Exception ex) {
            CommonPlugin.error(ex);
        }
        if (notify) {
            this.notifyListeners();
        }
    }

    @Override
    public void remove(WarningItem item) {
        if (this.mItems.contains(item)) {
            this.mItems.remove(item);
            this.notifyListeners();
        }
    }

    @Override
    public final synchronized void removeListener(@NonNull IWarningListener listener) {
        this.mListeners.remove(listener);
    }

    @Override
    public final void save(@NonNull File dir) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (XMLGenerator xml = XMLGenerator.create(new File(dir, FILENAME));){
                xml.startDocument();
                xml.startTag(TAG_WARNINGS);
                for (WarningItem item : this.mItems) {
                    item.save(TAG_WARNING, xml);
                }
                xml.endTag();
                xml.endDocument();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {
            CommonPlugin.error(exception);
        }
    }

    @Override
    public int size() {
        return this.mItems.size();
    }

    @Override
    public @NonNull List<@NonNull WarningItem> getItems() {
        return this.mItems;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void notifyListeners() {
        IWarningListener[] listeners;
        RawWarnings rawWarnings = this;
        synchronized (rawWarnings) {
            listeners = this.mListeners.toArray(new IWarningListener[this.mListeners.size()]);
        }
        IWarningListener[] iWarningListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            IWarningListener listener = iWarningListenerArray[n2];
            listener.warningsUpdated();
            ++n2;
        }
    }
}

