/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.common.model.topology;

import com.arm.streamline.common.model.topology.DeviceType;
import com.arm.streamline.common.model.topology.ProcessingElementReference;
import com.arm.utils.NullChecking;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;

public class ProcessingElementReferenceSet
implements Iterable<Map.Entry<DeviceType, List<ProcessingElementReference>>> {
    private final @NonNull Map<@NonNull ProcessingElementReference, @NonNull ProcessingElementReference> processingElementReferences = new HashMap<ProcessingElementReference, ProcessingElementReference>();
    private final @NonNull Map<@NonNull DeviceType, @NonNull List<@NonNull ProcessingElementReference>> referencesByType = new HashMap<DeviceType, List<ProcessingElementReference>>();

    public ProcessingElementReferenceSet() {
    }

    public ProcessingElementReferenceSet(long vmUID, int numCores) {
        int i = 0;
        while (i < numCores) {
            this.get(DeviceType.CPU, vmUID, i);
            ++i;
        }
    }

    public @NonNull ProcessingElementReference get(@NonNull DeviceType deviceType, long vmUID, int deviceNumber) {
        @NonNull ProcessingElementReference result = ProcessingElementReference.create(deviceType, vmUID, deviceNumber);
        return this.processingElementReferences.computeIfAbsent(result, k -> {
            @NonNull @NonNull List list = this.referencesByType.computeIfAbsent(k.deviceType, dt -> new ArrayList());
            list.add(k);
            return k;
        });
    }

    public @NonNull List<@NonNull ProcessingElementReference> getList(@NonNull DeviceType deviceType) {
        return (List)NullChecking.applyIfNonNullOrDefault(this.referencesByType.get(deviceType), Collections.emptyList(), Collections::unmodifiableList);
    }

    @Override
    public @NonNull Iterator<@NonNull Map.Entry<@NonNull DeviceType, @NonNull List<@NonNull ProcessingElementReference>>> iterator() {
        return Collections.unmodifiableSet(this.referencesByType.entrySet()).iterator();
    }
}

