/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.common.model.topology;

import com.arm.streamline.common.utility.io.XMLGenerator;
import com.arm.streamline.common.utility.io.XMLParser;
import com.arm.utils.NullChecking;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class DeviceType
implements Comparable<DeviceType> {
    public static final @NonNull DeviceType CPU = new DeviceType(BasicDeviceType.CPU, BasicDeviceType.CPU.xmlValue);
    public static final @NonNull DeviceType DISPLAY = new DeviceType(BasicDeviceType.DISPLAY, BasicDeviceType.DISPLAY.xmlValue);
    public static final @NonNull DeviceType GPU = new DeviceType(BasicDeviceType.GPU, BasicDeviceType.GPU.xmlValue);
    public static final @NonNull DeviceType SYSTEM_WIDE = new DeviceType(BasicDeviceType.SYSTEM_WIDE, BasicDeviceType.SYSTEM_WIDE.xmlValue);
    public static final @NonNull DeviceType VIDEO = new DeviceType(BasicDeviceType.VIDEO, BasicDeviceType.VIDEO.xmlValue);
    public static final @NonNull String MALI_FAMILY_NAME_BIFROST = "Bifrost";
    public static final @NonNull String MALI_FAMILY_NAME_MIDGARD = "Midgard";
    public static final @NonNull String MALI_FAMILY_NAME_UTGARD = "Utgard";
    public static final @NonNull String MALI_FAMILY_NAME_VALHALL = "Valhall";
    public static final @NonNull String MALI_FAMILY_PREFIX = "Mali-";
    public static final @NonNull String MALI_COUNTER_GENERIC_PREFIX = "^ARM_Mali-(Midgard|Bifrost|Valhall)_";
    public static final @NonNull String @NonNull [] MALI_FAMILIES_ALL = new String[]{"Utgard", "Midgard", "Bifrost", "Valhall"};
    public static final @NonNull String @NonNull [] MALI_FAMILIES_MIDGARD_AND_SIMILAR = new String[]{"Midgard", "Bifrost", "Valhall"};
    private static final String ATTR_DEVTYPE_BASIC = "devtype_basic";
    private static final String ATTR_DEVTYPE_NAME = "devtype_name";
    private static Pattern BIFROST_OR_VALHALL_PATTERN = Pattern.compile("^Mali-T[a-zA-Z].*$");
    private static final Pattern MALI_PATTERN = Pattern.compile("^ARM_(Mali-[^_]*)");
    private static Pattern MIDGARD_PATTERN = Pattern.compile("^Mali-T[0-9].*$");
    private final @NonNull BasicDeviceType mDeviceType;
    private final @NonNull String mName;

    public static @NonNull DeviceType cpu(@Nullable String name) {
        if (name == null || CPU.getName().equals(name)) {
            return CPU;
        }
        return new DeviceType(BasicDeviceType.CPU, name);
    }

    public static @NonNull DeviceType parseDeviceType(boolean perCPU, @Nullable String counter) {
        Matcher matcher;
        if (counter != null && (matcher = MALI_PATTERN.matcher(counter)).find()) {
            @NonNull String name = (String)NullChecking.neverNull((Object)matcher.group(1));
            return DeviceType.parseMaliName(name);
        }
        return perCPU ? CPU : SYSTEM_WIDE;
    }

    public static @NonNull DeviceType gpu(@Nullable String name) {
        if (name == null || GPU.getName().equals(name)) {
            return GPU;
        }
        return new DeviceType(BasicDeviceType.GPU, name);
    }

    public static @NonNull DeviceType read(@NonNull XMLParser in, boolean defaultToSystemWide) {
        if (in.hasAttribute(ATTR_DEVTYPE_BASIC)) {
            @NonNull String basicType = (String)NullChecking.neverNull((Object)in.getAttribute(ATTR_DEVTYPE_BASIC));
            @Nullable BasicDeviceType deviceType = BasicDeviceType.find(basicType);
            if (deviceType == null) {
                throw new AssertionError();
            }
            @NonNull String name = (String)NullChecking.neverNull((Object)in.getAttribute(ATTR_DEVTYPE_NAME, deviceType.xmlValue));
            DeviceType result = new DeviceType(deviceType, name);
            if (result.equals(CPU)) {
                return CPU;
            }
            if (result.equals(SYSTEM_WIDE)) {
                return SYSTEM_WIDE;
            }
            if (result.equals(DISPLAY)) {
                return DISPLAY;
            }
            if (result.equals(GPU)) {
                return GPU;
            }
            if (result.equals(VIDEO)) {
                return VIDEO;
            }
            return result;
        }
        if (defaultToSystemWide) {
            return SYSTEM_WIDE;
        }
        return CPU;
    }

    private static @NonNull DeviceType parseMaliName(@NonNull String name) {
        if (name.startsWith("Mali-V")) {
            return new DeviceType(BasicDeviceType.VIDEO, name);
        }
        if (name.startsWith("Mali-D")) {
            return new DeviceType(BasicDeviceType.DISPLAY, name);
        }
        return new DeviceType(BasicDeviceType.GPU, name);
    }

    private static boolean startsWithFamily(@NonNull String name, @NonNull String family) {
        return name.startsWith(MALI_FAMILY_PREFIX) && name.startsWith(family, 5);
    }

    private DeviceType(@NonNull BasicDeviceType deviceType, @NonNull String name) {
        this.mDeviceType = deviceType;
        this.mName = name;
    }

    @Override
    public int compareTo(DeviceType o) {
        int typeResult = Integer.compare(this.mDeviceType.sortOrder, o.mDeviceType.sortOrder);
        if (typeResult != 0) {
            return typeResult;
        }
        return this.mName.compareTo(o.mName);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DeviceType) {
            DeviceType that = (DeviceType)obj;
            switch (this.mDeviceType) {
                case CPU: 
                case SYSTEM_WIDE: {
                    return this.mDeviceType == that.mDeviceType;
                }
                case DISPLAY: 
                case GPU: 
                case VIDEO: {
                    return this.mDeviceType == that.mDeviceType && this.mName.equalsIgnoreCase(that.mName);
                }
            }
            throw new AssertionError((Object)this.mDeviceType);
        }
        return false;
    }

    public @NonNull BasicDeviceType getBasicDeviceType() {
        return this.mDeviceType;
    }

    public @NonNull String getName() {
        return this.mName;
    }

    public int hashCode() {
        return this.mDeviceType.hashCode() * 31 + this.mName.hashCode();
    }

    public boolean isCPU() {
        return this.mDeviceType == BasicDeviceType.CPU;
    }

    public boolean isDisplay() {
        return this.mDeviceType == BasicDeviceType.DISPLAY;
    }

    public boolean isGeneric() {
        if (!this.mName.startsWith(MALI_FAMILY_PREFIX)) {
            return false;
        }
        String[] stringArray = MALI_FAMILIES_ALL;
        int n = MALI_FAMILIES_ALL.length;
        int n2 = 0;
        while (n2 < n) {
            String family = stringArray[n2];
            if (this.mName.startsWith(family, 5)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean isGPU() {
        return this.mDeviceType == BasicDeviceType.GPU;
    }

    public boolean isMaliBifrostOrValhall() {
        return this.isGPU() && (this.mName.startsWith("Mali-G") || BIFROST_OR_VALHALL_PATTERN.matcher(this.mName).find()) || DeviceType.startsWithFamily(this.mName, MALI_FAMILY_NAME_BIFROST) || DeviceType.startsWithFamily(this.mName, MALI_FAMILY_NAME_VALHALL);
    }

    public boolean isMaliDisplay() {
        return this.isVideo() && this.mName.startsWith("Mali-D");
    }

    public boolean isMaliMidgard() {
        return this.isGPU() && MIDGARD_PATTERN.matcher(this.mName).find() || DeviceType.startsWithFamily(this.mName, MALI_FAMILY_NAME_MIDGARD);
    }

    public boolean isMaliUtgard() {
        return this.isGPU() && this.mName.startsWith("Mali-4") || DeviceType.startsWithFamily(this.mName, MALI_FAMILY_NAME_UTGARD);
    }

    public boolean isMaliVideo() {
        return this.isVideo() && this.mName.startsWith("Mali-V");
    }

    public boolean isSystemWide() {
        return this.mDeviceType == BasicDeviceType.SYSTEM_WIDE;
    }

    public boolean isVideo() {
        return this.mDeviceType == BasicDeviceType.VIDEO;
    }

    public boolean supportsMultipleCores() {
        switch (this.mDeviceType) {
            case CPU: 
            case GPU: 
            case VIDEO: {
                return true;
            }
            case DISPLAY: 
            case SYSTEM_WIDE: {
                return false;
            }
        }
        throw new AssertionError((Object)this.mDeviceType);
    }

    public boolean supportsMultipleCoresControlledByCounterRecord() {
        return this.isMaliUtgard();
    }

    public @NonNull String toString() {
        return this.mName;
    }

    public void write(@NonNull XMLGenerator xml) throws IOException {
        xml.addAttribute(ATTR_DEVTYPE_BASIC, this.mDeviceType.xmlValue);
        xml.addAttributeNot(ATTR_DEVTYPE_NAME, this.mName, this.mDeviceType.xmlValue);
    }

    public static enum BasicDeviceType {
        CPU("cpu", 1),
        DISPLAY("display", 4),
        GPU("gpu", 2),
        SYSTEM_WIDE("system-wide", 0),
        VIDEO("video", 3);

        public final int sortOrder;
        public final @NonNull String xmlValue;

        public static @Nullable BasicDeviceType find(@NonNull String basicType) {
            BasicDeviceType[] basicDeviceTypeArray = BasicDeviceType.values();
            int n = basicDeviceTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                BasicDeviceType value = basicDeviceTypeArray[n2];
                if (value.xmlValue.equalsIgnoreCase(basicType)) {
                    return value;
                }
                ++n2;
            }
            return null;
        }

        private BasicDeviceType(String xmlValue, int sortOrder) {
            this.xmlValue = xmlValue;
            this.sortOrder = sortOrder;
        }
    }
}

