/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.common.model.emeter;

import org.eclipse.jdt.annotation.NonNull;

public enum EnergyType {
    CURRENT("Current"),
    ENERGY("Energy"),
    NONE("None"),
    POWER("Power"),
    VOLTAGE("Voltage");

    private final @NonNull String mName;

    public static final EnergyType get(String type) {
        if (type != null) {
            EnergyType[] energyTypeArray = EnergyType.values();
            int n = energyTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                EnergyType one = energyTypeArray[n2];
                if (one.name().equalsIgnoreCase(type)) {
                    return one;
                }
                ++n2;
            }
        }
        return NONE;
    }

    public static String[] getAll() {
        return new String[]{ENERGY.toString(), POWER.toString(), VOLTAGE.toString(), CURRENT.toString()};
    }

    private EnergyType(String name) {
        this.mName = name;
    }

    public String getUnits() {
        switch (this) {
            case ENERGY: {
                return "J";
            }
            case POWER: {
                return "W";
            }
            case VOLTAGE: {
                return "V";
            }
            case CURRENT: {
                return "A";
            }
        }
        return "";
    }

    public boolean hasPeakSeries() {
        return this.equals((Object)POWER) || this.equals((Object)VOLTAGE) || this.equals((Object)CURRENT);
    }

    public final String toString() {
        return this.mName;
    }
}

