/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.common.model.counters;

import com.arm.streamline.common.model.CommonModelMessages;
import org.eclipse.jdt.annotation.NonNull;

public enum SeriesComposition {
    LOG10(CommonModelMessages.SeriesComposition_LOG10_TITLE, true),
    OVERLAY(CommonModelMessages.SeriesComposition_OVERLAY_TITLE, true),
    STACKED(CommonModelMessages.SeriesComposition_STACKED_TITLE, true),
    VISUAL_ANNOTATION(CommonModelMessages.SeriesComposition_VISUAL_ANNOTATION_TITLE, false);

    public static final @NonNull SeriesComposition DEFAULT;
    private final boolean mCanBeSwitchedTo;
    private final String mPresentationName;

    static {
        DEFAULT = STACKED;
    }

    public static final @NonNull SeriesComposition get(String type) {
        if (type != null) {
            SeriesComposition[] seriesCompositionArray = SeriesComposition.values();
            int n = seriesCompositionArray.length;
            int n2 = 0;
            while (n2 < n) {
                SeriesComposition one = seriesCompositionArray[n2];
                if (one.name().equalsIgnoreCase(type)) {
                    return one;
                }
                ++n2;
            }
        }
        return DEFAULT;
    }

    private SeriesComposition(String presentationName, boolean canBeSwitchedTo) {
        this.mPresentationName = presentationName;
        this.mCanBeSwitchedTo = canBeSwitchedTo;
    }

    public final boolean canBeSwitchedTo() {
        return this.mCanBeSwitchedTo;
    }

    public final String getPresentationName() {
        return this.mPresentationName;
    }

    public final String toString() {
        return this.name().toLowerCase();
    }
}

