/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.common.model.counters;

import com.arm.streamline.common.model.counters.CounterClass;
import com.arm.streamline.common.model.counters.ModelMessages;
import com.arm.utils.NullChecking;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public enum CounterDisplay {
    ACCUMULATE(ModelMessages.ACCUMULATE){

        @Override
        public boolean isCompatibleWith(@NonNull CounterClass cclass) {
            return cclass.isDelta() || cclass.isIncident();
        }
    }
    ,
    AVERAGE(ModelMessages.AVERAGE){

        @Override
        public boolean isCompatibleWith(@NonNull CounterClass cclass) {
            return cclass.isAbsolute() || cclass.isActivity() || cclass.isConstant();
        }
    }
    ,
    HERTZ(ModelMessages.HERTZ){

        @Override
        public boolean isCompatibleWith(@NonNull CounterClass cclass) {
            return cclass.isDelta() || cclass.isIncident();
        }
    }
    ,
    MAXIMUM(ModelMessages.MAXIMUM){

        @Override
        public boolean isCompatibleWith(@NonNull CounterClass cclass) {
            return cclass.isAbsolute() || cclass.isConstant();
        }
    }
    ,
    MINIMUM(ModelMessages.MINIMUM){

        @Override
        public boolean isCompatibleWith(@NonNull CounterClass cclass) {
            return cclass.isAbsolute() || cclass.isConstant();
        }
    };

    private String mPresentationName;

    public static @NonNull List<@NonNull CounterDisplay> allCompatibleWith(@NonNull CounterClass cclass) {
        return Arrays.stream(CounterDisplay.values()).filter(display -> display.isCompatibleWith(cclass)).collect(Collectors.toList());
    }

    public static List<CounterDisplay> analysisDisplayOptions() {
        return Arrays.asList(ACCUMULATE, MAXIMUM, MINIMUM, AVERAGE);
    }

    public static @NonNull CounterDisplay getDefault() {
        return ACCUMULATE;
    }

    public static @NonNull CounterDisplay getDisplay(String text) {
        return CounterDisplay.getDisplay(text, CounterClass.DELTA);
    }

    public static @NonNull CounterDisplay getDisplay(@Nullable String text, @Nullable CounterClass cclass) {
        if (text == null) {
            if (cclass == null) {
                return ACCUMULATE;
            }
            if (cclass.isAbsolute()) {
                return MAXIMUM;
            }
            if (cclass.isActivity()) {
                return AVERAGE;
            }
            return ACCUMULATE;
        }
        if (text.equalsIgnoreCase(AVERAGE.name())) {
            return AVERAGE;
        }
        if (text.equalsIgnoreCase(HERTZ.name())) {
            return HERTZ;
        }
        if (text.equalsIgnoreCase(MAXIMUM.name())) {
            return MAXIMUM;
        }
        if (text.equalsIgnoreCase(MINIMUM.name())) {
            return MINIMUM;
        }
        if (cclass == null) {
            return ACCUMULATE;
        }
        if (cclass.isAbsolute()) {
            return MAXIMUM;
        }
        if (cclass.isActivity()) {
            return AVERAGE;
        }
        return ACCUMULATE;
    }

    public static String getSelectionDefault() {
        return "/data_";
    }

    private CounterDisplay(String presentationName) {
        this.mPresentationName = presentationName;
    }

    public String getPresentationName() {
        return this.mPresentationName;
    }

    public String getSelection() {
        switch (this) {
            case ACCUMULATE: {
                return "data_";
            }
            case AVERAGE: {
                return "average_";
            }
            case HERTZ: {
                return "data_";
            }
            case MAXIMUM: {
                return "maximum_";
            }
            case MINIMUM: {
                return "minimum_";
            }
        }
        return "invalid";
    }

    public boolean isAccumulate() {
        return this == ACCUMULATE;
    }

    public boolean isAverage() {
        return this == AVERAGE;
    }

    public abstract boolean isCompatibleWith(@NonNull CounterClass var1);

    public boolean isHertz() {
        return this == HERTZ;
    }

    public boolean isMaximum() {
        return this == MAXIMUM;
    }

    public boolean isMinimum() {
        return this == MINIMUM;
    }

    public @NonNull String toString() {
        return (String)NullChecking.neverNull((Object)this.name());
    }
}

