/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.common.model.counters;

import com.arm.streamline.common.model.counters.ModelMessages;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public enum CounterClass {
    DELTA(ModelMessages.DELTA),
    INCIDENT(ModelMessages.INCIDENT),
    ABSOLUTE(ModelMessages.ABSOLUTE),
    ACTIVITY(ModelMessages.ACTIVITY),
    CONSTANT(ModelMessages.CONSTANT);

    private final String mPresentationName;

    public static @NonNull CounterClass getCounterClass(@Nullable String text) {
        if (text != null && !text.isEmpty()) {
            if (text.equalsIgnoreCase(INCIDENT.name())) {
                return INCIDENT;
            }
            if (text.equalsIgnoreCase(ABSOLUTE.name())) {
                return ABSOLUTE;
            }
            if (text.equalsIgnoreCase(ACTIVITY.name())) {
                return ACTIVITY;
            }
            if (text.equalsIgnoreCase(DELTA.name())) {
                return DELTA;
            }
            if (text.equalsIgnoreCase(CONSTANT.name())) {
                return CONSTANT;
            }
        }
        return CounterClass.getDefault();
    }

    public static @NonNull CounterClass getDefault() {
        return DELTA;
    }

    private CounterClass(String presentationName) {
        this.mPresentationName = presentationName;
    }

    public String getPresentationName() {
        return this.mPresentationName;
    }

    public boolean isAbsolute() {
        return this.equals((Object)ABSOLUTE);
    }

    public boolean isActivity() {
        return this.equals((Object)ACTIVITY);
    }

    public boolean isClash(CounterClass other) {
        if (!this.equals((Object)other)) {
            return !this.equals((Object)INCIDENT) && !other.equals((Object)INCIDENT) || !this.equals((Object)DELTA) && !other.equals((Object)DELTA);
        }
        return false;
    }

    public boolean isDelta() {
        return this.equals((Object)DELTA);
    }

    public boolean isIncident() {
        return this.equals((Object)INCIDENT);
    }

    public boolean isConstant() {
        return this.equals((Object)CONSTANT);
    }

    public String toString() {
        return this.name();
    }
}

