/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.common.model.chart;

import com.arm.streamline.common.model.chart.ActivityChartUtils;
import com.arm.streamline.common.model.emeter.EnergyType;
import com.arm.utils.text.NumericStringComparator;
import org.eclipse.jdt.annotation.NonNull;

public final class SeriesComparator {
    private static final @NonNull String GPU_PREFIX = "GPU ";

    public static int compareSeries(int order1, String title1, String name1, boolean isActivity1, int order2, String title2, String name2, boolean isActivity2) {
        String s;
        String e1begin = null;
        String e1end = null;
        String e2begin = null;
        String e2end = null;
        int index = -1;
        boolean thisIsEnergy = false;
        boolean otherIsEnergy = false;
        if (title1.startsWith("Clock") && title2.startsWith("Clock")) {
            if (name1.startsWith("Frequency") && name2.startsWith("Cycles")) {
                return -1;
            }
            if (name2.startsWith("Frequency") && name1.startsWith("Cycles")) {
                return 1;
            }
        }
        if (ActivityChartUtils.isCPUActivityUser(title1, name1) && ActivityChartUtils.isCPUActivitySystem(title2, name2)) {
            return -1;
        }
        if (ActivityChartUtils.isCPUActivityUser(title2, name2) && ActivityChartUtils.isCPUActivitySystem(title1, name1)) {
            return 1;
        }
        int titleCompare = NumericStringComparator.caselessCompareStrings((String)title1, (String)title2);
        if (titleCompare == 0) {
            int orderCompare = -Integer.compare(order1, order2);
            if (orderCompare != 0) {
                return orderCompare;
            }
            return NumericStringComparator.caselessCompareStrings((String)name1, (String)name2);
        }
        if (isActivity1 && isActivity2) {
            if (title1.startsWith(GPU_PREFIX) && title2.startsWith(GPU_PREFIX)) {
                return titleCompare * -1;
            }
            return titleCompare;
        }
        if (isActivity1) {
            return -1;
        }
        if (isActivity2) {
            return 1;
        }
        String[] stringArray = EnergyType.getAll();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            s = stringArray[n2];
            if (index < 0) {
                index = title1.lastIndexOf(s);
            }
            ++n2;
        }
        if (title1.startsWith("Channel ") && index > "Channel ".length()) {
            e1begin = title1.substring(0, index);
            e1end = title1.substring(index);
            thisIsEnergy = true;
        }
        index = -1;
        stringArray = EnergyType.getAll();
        n = stringArray.length;
        n2 = 0;
        while (n2 < n) {
            s = stringArray[n2];
            if (index < 0) {
                index = title2.lastIndexOf(s);
            }
            ++n2;
        }
        if (title2.startsWith("Channel ") && index > "Channel ".length()) {
            e2begin = title2.substring(0, index);
            e2end = title2.substring(index);
            otherIsEnergy = true;
        }
        if (thisIsEnergy && otherIsEnergy && e1begin != null && e1end != null && e2begin != null) {
            titleCompare = NumericStringComparator.caselessCompareStrings((String)e1begin, (String)e2begin);
            if (titleCompare == 0) {
                int nameCompare = NumericStringComparator.caselessCompareStrings((String)e1end, (String)e2end);
                if (nameCompare == 0) {
                    return nameCompare;
                }
                if (EnergyType.ENERGY.toString().equals(e1end)) {
                    return -1;
                }
                if (EnergyType.ENERGY.toString().equals(e2end)) {
                    return 1;
                }
                if (EnergyType.POWER.toString().equals(e1end)) {
                    return -1;
                }
                if (EnergyType.POWER.toString().equals(e2end)) {
                    return 1;
                }
                if (EnergyType.VOLTAGE.toString().equals(e1end)) {
                    return -1;
                }
                if (EnergyType.VOLTAGE.toString().equals(e2end)) {
                    return 1;
                }
            }
        } else {
            if (thisIsEnergy) {
                return 1;
            }
            if (otherIsEnergy) {
                return -1;
            }
        }
        return titleCompare;
    }
}

